/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.validator;

import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.validator.Validator;
import jakarta.faces.validator.ValidatorException;
import java.text.MessageFormat;

public final class StringLengthValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "com.sun.webui.jsf.StringLength";
    private String tooShortMessage = null;
    private String tooLongMessage;
    private int minLength = 0;
    private int maxLength = 0;
    private boolean minimumSet = false;
    private static final boolean DEBUG = false;

    public StringLengthValidator() {
    }

    public StringLengthValidator(int max) {
        this.maxLength = max;
    }

    public StringLengthValidator(int max, int min) {
        this(max);
        this.minLength = min;
        this.minimumSet = true;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String string = value == null ? new String() : (String)value;
        if (string.length() > this.maxLength) {
            if (this.tooLongMessage == null) {
                Theme theme = ThemeUtilities.getTheme(context);
                this.tooLongMessage = theme.getMessage("StringLengthValidator.itemTooLong");
            }
            MessageFormat mf = new MessageFormat(this.tooLongMessage, context.getViewRoot().getLocale());
            Object[] params = new Object[]{String.valueOf(this.maxLength)};
            FacesMessage msg = new FacesMessage(mf.format(params));
            throw new ValidatorException(msg);
        }
        if (this.minimumSet && string.length() < this.minLength) {
            if (this.tooShortMessage == null) {
                Theme theme = ThemeUtilities.getTheme(context);
                this.tooShortMessage = theme.getMessage("StringLengthValidator.itemTooLong");
            }
            MessageFormat mf = new MessageFormat(this.tooShortMessage, context.getViewRoot().getLocale());
            Object[] params = new Object[]{String.valueOf(this.minLength)};
            FacesMessage msg = new FacesMessage(mf.format(params));
            throw new ValidatorException(msg);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maxLength, this.minLength, this.minimumSet ? Boolean.TRUE : Boolean.FALSE, this.tooLongMessage, this.tooShortMessage};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maxLength = (Integer)values[0];
        this.minLength = (Integer)values[1];
        this.minimumSet = (Boolean)values[2];
        if (values[3] != null) {
            this.tooLongMessage = values[3].toString();
        }
        if (values[4] != null) {
            this.tooShortMessage = values[4].toString();
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean transientValue) {
    }

    public String getTooLongMessage() {
        return this.tooLongMessage;
    }

    public void setTooLongMessage(String newTooLongMessage) {
        this.tooLongMessage = newTooLongMessage;
    }

    public String getTooShortMessage() {
        return this.tooShortMessage;
    }

    public void setTooShortMessage(String newTooShortMessage) {
        this.tooShortMessage = newTooShortMessage;
    }

    private static void log(String msg) {
        LogUtil.finest(StringLengthValidator.class.getName() + "::" + msg);
    }
}

