/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.ColumnResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.ConstructorResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.EntityResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.queries.SQLResultSetMapping;

public class SQLResultSetMappingMetadata
extends ORMetadata {
    private List<ColumnResultMetadata> m_columnResults = new ArrayList<ColumnResultMetadata>();
    private List<ConstructorResultMetadata> m_constructorResults = new ArrayList<ConstructorResultMetadata>();
    private List<EntityResultMetadata> m_entityResults = new ArrayList<EntityResultMetadata>();
    private String m_name;

    public SQLResultSetMappingMetadata() {
        super("<sql-result-set-mapping>");
    }

    public SQLResultSetMappingMetadata(MetadataAnnotation sqlResultSetMapping, MetadataAccessor accessor) {
        super(sqlResultSetMapping, accessor);
        this.m_name = sqlResultSetMapping.getAttributeString("name");
        for (Object entityResult : sqlResultSetMapping.getAttributeArray("entities")) {
            this.m_entityResults.add(new EntityResultMetadata((MetadataAnnotation)entityResult, accessor));
        }
        for (Object constructorResult : sqlResultSetMapping.getAttributeArray("classes")) {
            this.m_constructorResults.add(new ConstructorResultMetadata((MetadataAnnotation)constructorResult, accessor));
        }
        for (Object columnResult : sqlResultSetMapping.getAttributeArray("columns")) {
            this.m_columnResults.add(new ColumnResultMetadata((MetadataAnnotation)columnResult, accessor));
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof SQLResultSetMappingMetadata) {
            SQLResultSetMappingMetadata sqlResultSetMapping = (SQLResultSetMappingMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, sqlResultSetMapping.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_columnResults, sqlResultSetMapping.getColumnResults())) {
                return false;
            }
            if (!this.valuesMatch(this.m_constructorResults, sqlResultSetMapping.getConstructorResults())) {
                return false;
            }
            return this.valuesMatch(this.m_entityResults, sqlResultSetMapping.getEntityResults());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_columnResults != null ? this.m_columnResults.hashCode() : 0);
        result = 31 * result + (this.m_constructorResults != null ? this.m_constructorResults.hashCode() : 0);
        result = 31 * result + (this.m_entityResults != null ? this.m_entityResults.hashCode() : 0);
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        return result;
    }

    public List<ColumnResultMetadata> getColumnResults() {
        return this.m_columnResults;
    }

    public List<ConstructorResultMetadata> getConstructorResults() {
        return this.m_constructorResults;
    }

    public List<EntityResultMetadata> getEntityResults() {
        return this.m_entityResults;
    }

    @Override
    public String getIdentifier() {
        return this.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_entityResults, accessibleObject);
        this.initXMLObjects(this.m_constructorResults, accessibleObject);
        this.initXMLObjects(this.m_columnResults, accessibleObject);
    }

    public SQLResultSetMapping process() {
        SQLResultSetMapping mapping = new SQLResultSetMapping(this.getName());
        for (EntityResultMetadata entityResult : this.m_entityResults) {
            mapping.addResult((SQLResult)entityResult.process());
        }
        for (ConstructorResultMetadata constructorResult : this.m_constructorResults) {
            mapping.addResult((SQLResult)constructorResult.process());
        }
        for (ColumnResultMetadata columnResult : this.m_columnResults) {
            mapping.addResult((SQLResult)columnResult.process());
        }
        return mapping;
    }

    public void setColumnResults(List<ColumnResultMetadata> columnResults) {
        this.m_columnResults = columnResults;
    }

    public void setConstructorResults(List<ConstructorResultMetadata> constructorResults) {
        this.m_constructorResults = constructorResults;
    }

    public void setEntityResults(List<EntityResultMetadata> entityResults) {
        this.m_entityResults = entityResults;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

