/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.impl.transport.ConnectionImpl;
import com.sun.corba.ee.impl.transport.ContactInfoBase;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.ContactInfoList;
import com.sun.corba.ee.spi.transport.SocketInfo;

public class ContactInfoImpl
extends ContactInfoBase
implements SocketInfo {
    protected boolean isHashCodeCached = false;
    protected int cachedHashCode;
    protected String socketType;
    protected String hostname;
    protected int port;

    protected ContactInfoImpl() {
    }

    protected ContactInfoImpl(ORB orb, ContactInfoList contactInfoList) {
        this.orb = orb;
        this.contactInfoList = contactInfoList;
    }

    public ContactInfoImpl(ORB orb, ContactInfoList contactInfoList, String socketType, String hostname, int port) {
        this(orb, contactInfoList);
        this.socketType = socketType;
        this.hostname = hostname;
        this.port = port;
    }

    public ContactInfoImpl(ORB orb, ContactInfoList contactInfoList, IOR effectiveTargetIOR, short addressingDisposition, String socketType, String hostname, int port) {
        this(orb, contactInfoList, socketType, hostname, port);
        this.effectiveTargetIOR = effectiveTargetIOR;
        this.addressingDisposition = addressingDisposition;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    public boolean shouldCacheConnection() {
        return true;
    }

    @Override
    public String getConnectionCacheType() {
        return "SocketOrChannelConnectionCache";
    }

    @Override
    public Connection createConnection() {
        ConnectionImpl connection = new ConnectionImpl(this.orb, this, this.socketType, this.hostname, this.port);
        return connection;
    }

    @Override
    public String getMonitoringName() {
        return "SocketConnections";
    }

    @Override
    public String getType() {
        return this.socketType;
    }

    @Override
    public String getHost() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int hashCode() {
        if (!this.isHashCodeCached) {
            this.cachedHashCode = this.socketType.hashCode() ^ this.hostname.hashCode() ^ this.port;
            this.isHashCodeCached = true;
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactInfoImpl)) {
            return false;
        }
        ContactInfoImpl other = (ContactInfoImpl)obj;
        if (this.port != other.port) {
            return false;
        }
        if (!this.hostname.equals(other.hostname)) {
            return false;
        }
        return !(this.socketType == null ? other.socketType != null : !this.socketType.equals(other.socketType));
    }

    @Override
    public String toString() {
        return "SocketOrChannelContactInfoImpl[" + this.socketType + " " + this.hostname + " " + this.port + "]";
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("SocketOrChannelContactInfoImpl", msg);
    }
}

