/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessor;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.ComponentInfo;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.ProcessingContext;
import org.glassfish.apf.ProcessingResult;
import org.glassfish.apf.ResultType;
import org.glassfish.apf.Scanner;
import org.glassfish.apf.impl.AnnotationUtils;
import org.glassfish.apf.impl.DefaultErrorHandler;
import org.glassfish.apf.impl.HandlerProcessingResultImpl;
import org.glassfish.apf.impl.ProcessingContextImpl;
import org.glassfish.apf.impl.ProcessingResultImpl;
import org.glassfish.apf.impl.StackElement;

public class AnnotationProcessorImpl
implements AnnotationProcessor {
    private static final Logger LOG = AnnotationUtils.getLogger();
    private final Map<String, List<AnnotationHandler>> handlers = new HashMap<String, List<AnnotationHandler>>();
    private final Stack<StackElement> annotatedElements = new Stack();
    private final Set<Package> visitedPackages = new HashSet<Package>();
    private AnnotationProcessorImpl delegate;
    private int errorCount;

    public void setDelegate(AnnotationProcessorImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public ProcessingContext createContext() {
        ProcessingContextImpl ctx = new ProcessingContextImpl(this);
        ctx.setErrorHandler(new DefaultErrorHandler());
        return ctx;
    }

    @Override
    public void log(Level level, AnnotationInfo locator, String localizedMessage) {
        if (LOG.isLoggable(level)) {
            if (locator == null) {
                LOG.log(level, localizedMessage);
            } else {
                LOG.log(level, MessageFormat.format("{2}\n symbol: {0}\n location: {1}", locator.getAnnotation().annotationType().getName(), locator.getAnnotatedElement(), localizedMessage));
            }
        }
    }

    @Override
    public ProcessingResult process(ProcessingContext ctx) throws AnnotationProcessorException {
        Scanner scanner = ctx.getProcessingInput();
        ProcessingResultImpl result = new ProcessingResultImpl();
        this.errorCount = 0;
        for (Class<?> c : scanner.getElements()) {
            result.add(this.process(ctx, c));
        }
        return result;
    }

    @Override
    public ProcessingResult process(ProcessingContext ctx, Class<?>[] classes) throws AnnotationProcessorException {
        ProcessingResultImpl result = new ProcessingResultImpl();
        for (Class<?> c : classes) {
            result.add(this.process(ctx, c));
        }
        return result;
    }

    private ProcessingResult process(ProcessingContext ctx, Class<?> c) throws AnnotationProcessorException {
        Scanner scanner = ctx.getProcessingInput();
        ProcessingResultImpl result = new ProcessingResultImpl();
        Package classPackage = c.getPackage();
        if (classPackage != null && this.visitedPackages.add(classPackage)) {
            result.add(classPackage, this.processAnnotations(ctx, ElementType.PACKAGE, classPackage));
        }
        ComponentInfo info = null;
        try {
            info = scanner.getComponentInfo(c);
        }
        catch (NoClassDefFoundError err) {
            AnnotationProcessorException ape = new AnnotationProcessorException(MessageFormat.format("Class [ {0} ] not found. Error while loading [ {1} ]", err.getMessage(), c));
            ctx.getErrorHandler().error(ape);
            return result;
        }
        AnnotatedElementHandler handler = ctx.getHandler();
        this.logStart(handler, ElementType.TYPE, c);
        result.add(c, this.processAnnotations(ctx, c));
        for (Field field : info.getFields()) {
            result.add(field, this.processAnnotations(ctx, ElementType.FIELD, field));
        }
        for (AccessibleObject accessibleObject : info.getConstructors()) {
            this.logStart(ctx.getHandler(), ElementType.CONSTRUCTOR, accessibleObject);
            result.add(accessibleObject, this.processAnnotations(ctx, accessibleObject));
            this.processParameters(ctx, ((Constructor)accessibleObject).getParameterAnnotations());
            this.logEnd(ctx.getHandler(), ElementType.CONSTRUCTOR, accessibleObject);
        }
        for (AccessibleObject accessibleObject : info.getMethods()) {
            this.logStart(ctx.getHandler(), ElementType.METHOD, accessibleObject);
            result.add(accessibleObject, this.processAnnotations(ctx, accessibleObject));
            this.processParameters(ctx, ((Method)accessibleObject).getParameterAnnotations());
            this.logEnd(ctx.getHandler(), ElementType.METHOD, accessibleObject);
        }
        for (Class<?> currentClass = c.getSuperclass(); currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            result.add(c, this.processAnnotations(ctx, currentClass));
        }
        this.logEnd(ctx.getHandler(), ElementType.TYPE, c);
        return result;
    }

    private HandlerProcessingResult processParameters(ProcessingContext ctx, Annotation[][] parametersAnnotations) throws AnnotationProcessorException {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        for (Annotation[] parameterAnnotations : parametersAnnotations) {
            this.logStart(ctx.getHandler(), ElementType.PARAMETER, null);
            if (parameterAnnotations != null) {
                for (Annotation annotation : parameterAnnotations) {
                    AnnotationInfo info = new AnnotationInfo(ctx, null, annotation, ElementType.PARAMETER);
                    this.process(ctx, info, result);
                    this.dumpProcessingResult(result);
                }
            }
            this.logEnd(ctx.getHandler(), ElementType.PARAMETER, null);
        }
        return result;
    }

    private HandlerProcessingResult processAnnotations(ProcessingContext ctx, ElementType type, AnnotatedElement element) throws AnnotationProcessorException {
        AnnotatedElementHandler handler = ctx.getHandler();
        this.logStart(handler, type, element);
        HandlerProcessingResult result = this.processAnnotations(ctx, element);
        this.logEnd(handler, type, element);
        this.dumpProcessingResult(result);
        return result;
    }

    private HandlerProcessingResult processAnnotations(ProcessingContext ctx, AnnotatedElement element) throws AnnotationProcessorException {
        HandlerProcessingResultImpl result = new HandlerProcessingResultImpl();
        try {
            for (Annotation annotation : element.getAnnotations()) {
                AnnotationInfo subElement = new AnnotationInfo(ctx, element, annotation, this.getTopElementType());
                if (result.processedAnnotations().containsKey(annotation.annotationType())) {
                    LOG.log(Level.FINER, "Annotation {0} already processed.", annotation.annotationType());
                    continue;
                }
                this.process(ctx, subElement, result);
            }
        }
        catch (ArrayStoreException e) {
            LOG.info("Exception " + String.valueOf(e) + " encountered while processing annotaton for element " + String.valueOf(element) + ". Message is: " + e.getMessage() + ". Ignoring annotations and proceeding.");
        }
        return result;
    }

    private void process(ProcessingContext ctx, AnnotationInfo element, HandlerProcessingResultImpl result) throws AnnotationProcessorException {
        Annotation annotation = element.getAnnotation();
        LOG.log(Level.FINER, "Processing annotation: {0} delegate = {1}", new Object[]{element, this.delegate});
        result.addResult(annotation.annotationType(), ResultType.UNPROCESSED);
        Package annPackage = annotation.annotationType().getPackage();
        if (annPackage != null && annPackage.getName().startsWith("java.lang")) {
            return;
        }
        List<AnnotationHandler> annotationHandlers = this.handlers.get(annotation.annotationType().getName());
        if (annotationHandlers == null) {
            if (this.delegate == null) {
                LOG.log(Level.FINER, "No handler defined for {0}", annotation);
            } else {
                this.delegate.process(ctx, element, result);
            }
            return;
        }
        for (AnnotationHandler handler : annotationHandlers) {
            Object[] dependencies = handler.getTypeDependencies();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "Dependencies of handler " + String.valueOf(handler) + ", " + Arrays.toString(dependencies));
            }
            if (dependencies != null) {
                AnnotatedElement ae = element.getAnnotatedElement();
                for (Object annotationType : dependencies) {
                    ResultType resultType;
                    Object depAnnotation = ae.getAnnotation(annotationType);
                    if (depAnnotation == null || (resultType = result.processedAnnotations().get(annotationType)) != null && resultType != ResultType.UNPROCESSED) continue;
                    AnnotationInfo info = new AnnotationInfo(ctx, ae, (Annotation)depAnnotation, this.getTopElementType());
                    this.process(ctx, info, result);
                }
            }
            HandlerProcessingResult processingResult = null;
            try {
                processingResult = handler.processAnnotation(element);
            }
            catch (AnnotationProcessorException ape) {
                this.log(Level.SEVERE, ape.getAnnotationInfo(), ape.getMessage());
                if (ape.isFatal()) {
                    throw ape;
                }
                if (++this.errorCount > 100) {
                    throw new AnnotationProcessorException("Too many errors, annotation processing abandoned.");
                }
                processingResult = HandlerProcessingResultImpl.getDefaultResult(annotation.annotationType(), ResultType.FAILED);
            }
            catch (Throwable e) {
                throw new AnnotationProcessorException(e.getMessage(), element, e);
            }
            result.addAll(processingResult);
        }
    }

    private void dumpProcessingResult(HandlerProcessingResult result) {
        if (result == null || !LOG.isLoggable(Level.FINER)) {
            return;
        }
        Map<Class<? extends Annotation>, ResultType> annotationResults = result.processedAnnotations();
        for (Map.Entry<Class<? extends Annotation>, ResultType> element : annotationResults.entrySet()) {
            LOG.finer("Annotation " + String.valueOf(element.getKey()) + " : " + String.valueOf((Object)element.getValue()));
        }
    }

    @Override
    public void pushAnnotationHandler(AnnotationHandler handler) {
        String type = handler.getAnnotationType().getName();
        this.pushAnnotationHandler(type, handler);
    }

    public void pushAnnotationHandler(String type, AnnotationHandler handler) {
        List<AnnotationHandler> currentHandlers = this.handlers.get(type);
        if (currentHandlers == null) {
            currentHandlers = new ArrayList<AnnotationHandler>();
            this.handlers.put(type, currentHandlers);
        }
        currentHandlers.add(handler);
    }

    @Override
    public void popAnnotationHandler(Class<? extends Annotation> type) {
        List<AnnotationHandler> currentHandlers = this.handlers.get(type.getName());
        if (currentHandlers != null) {
            currentHandlers.remove(currentHandlers.size() - 1);
        }
    }

    @Override
    public AnnotationHandler getAnnotationHandler(Class<? extends Annotation> type) {
        List<AnnotationHandler> currentHandlers = this.handlers.get(type.getName());
        if (currentHandlers != null && currentHandlers.size() > 0) {
            return currentHandlers.get(0);
        }
        return null;
    }

    @Override
    public AnnotatedElement getLastAnnotatedElement(ElementType type) {
        for (int i = this.annotatedElements.size(); i != 0; --i) {
            StackElement e = (StackElement)this.annotatedElements.get(i - 1);
            if (!e.getElementType().equals((Object)type)) continue;
            return e.getAnnotatedElement();
        }
        return null;
    }

    public Stack<StackElement> getStack() {
        return this.annotatedElements;
    }

    private void logStart(AnnotatedElementHandler handler, ElementType type, AnnotatedElement c) throws AnnotationProcessorException {
        LOG.log(Level.FINEST, "{0} START : {1}", new Object[]{type, c});
        this.annotatedElements.push(new StackElement(type, c));
        if (this.delegate != null) {
            this.delegate.getStack().push(new StackElement(type, c));
        }
        if (handler != null) {
            handler.startElement(type, c);
        }
    }

    private void logEnd(AnnotatedElementHandler handler, ElementType type, AnnotatedElement c) throws AnnotationProcessorException {
        LOG.log(Level.FINEST, "{0} END : {1}", new Object[]{type, c});
        this.annotatedElements.pop();
        if (this.delegate != null) {
            this.delegate.getStack().pop();
        }
        if (handler != null) {
            handler.endElement(type, c);
        }
    }

    private ElementType getTopElementType() {
        try {
            StackElement top = this.annotatedElements.peek();
            return top.getElementType();
        }
        catch (EmptyStackException ex) {
            return null;
        }
    }
}

