/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.jaas;

import com.sun.security.auth.login.ConfigFile;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;

public class ExtendedConfigFile
extends ConfigFile {
    private static final System.Logger LOG = System.getLogger(ExtendedConfigFile.class.getName());
    private Class<?> moduleClass;

    public static ExtendedConfigFile fromFileName(String configFileName) {
        if (configFileName == null) {
            return new ExtendedConfigFile();
        }
        try {
            return new ExtendedConfigFile(new URI(configFileName));
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException(use);
        }
    }

    public ExtendedConfigFile() {
    }

    public ExtendedConfigFile(URI uri) {
        super(uri);
    }

    public ExtendedConfigFile(Class<?> moduleClass) {
        this.moduleClass = moduleClass;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        if (this.moduleClass == null) {
            return super.getAppConfigurationEntry(applicationName);
        }
        AppConfigurationEntry appConfigurationEntry = new AppConfigurationEntry(this.moduleClass.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.emptyMap());
        return new AppConfigurationEntry[]{appConfigurationEntry};
    }

    public String[] getAppNames(Class<?>[] authModuleClass) {
        Set nameSet;
        try {
            Field field = ConfigFile.class.getDeclaredField("configuration");
            field.setAccessible(true);
            Map map = (Map)field.get(this);
            nameSet = map.keySet();
        }
        catch (ReflectiveOperationException pae) {
            throw new SecurityException(pae.getCause());
        }
        if (authModuleClass != null) {
            String[] names;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (String id : names = nameSet.toArray(new String[nameSet.size()])) {
                boolean hasAuthModule = false;
                AppConfigurationEntry[] entry = this.getAppConfigurationEntry(id);
                block5: for (int i = 0; i < entry.length && !hasAuthModule; ++i) {
                    String clazz = entry[i].getLoginModuleName();
                    try {
                        Class<?> c = Class.forName(clazz, true, loader);
                        for (Class<?> required : authModuleClass) {
                            if (!required.isAssignableFrom(c)) continue;
                            hasAuthModule = true;
                            continue block5;
                        }
                        continue;
                    }
                    catch (Throwable t) {
                        LOG.log(System.Logger.Level.WARNING, () -> "Skipping unloadable class: " + clazz + " of entry: " + id, t);
                    }
                }
                if (hasAuthModule) continue;
                nameSet.remove(id);
            }
        }
        return nameSet.toArray(new String[nameSet.size()]);
    }
}

