/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp;

import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.tagext.TagInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.wasp.Options;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.Compiler;
import org.glassfish.wasp.compiler.JspRuntimeContext;
import org.glassfish.wasp.compiler.JspUtil;
import org.glassfish.wasp.compiler.Localizer;
import org.glassfish.wasp.compiler.ServletWriter;
import org.glassfish.wasp.compiler.TagLibraryInfoImpl;
import org.glassfish.wasp.servlet.JspServletWrapper;
import org.glassfish.wasp.servlet.WaspLoader;

public class JspCompilationContext {
    private String className;
    private String jspUri;
    private boolean isErrPage;
    private String basePackageName;
    private String derivedPackageName;
    private String servletJavaFileName;
    private String javaPath;
    private String classFileName;
    private String contentType;
    private ServletWriter writer;
    private Options options;
    private JspServletWrapper jsw;
    private Compiler jspCompiler;
    private String classPath;
    private String baseURI;
    private String outputDir;
    private ServletContext context;
    private ClassLoader loader;
    private JspRuntimeContext rctxt;
    private int removed = 0;
    private URL baseUrl;
    private Class<?> servletClass;
    private boolean isTagFile;
    private boolean protoTypeMode;
    private TagInfo tagInfo;
    private URL tagFileJarUrl;
    private ConcurrentHashMap<String, TagLibraryInfoImpl> taglibs;
    private ConcurrentHashMap<String, URL> tagFileJarUrls;
    static Object outputDirLock = new Object();

    public JspCompilationContext(String jspUri, boolean isErrPage, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt) throws WaspException {
        this.jspUri = JspCompilationContext.canonicalURI(jspUri);
        this.isErrPage = isErrPage;
        this.options = options;
        this.jsw = jsw;
        this.context = context;
        this.baseURI = jspUri.substring(0, jspUri.lastIndexOf(47) + 1);
        if (this.baseURI == null) {
            this.baseURI = "/";
        } else if (this.baseURI.charAt(0) != '/') {
            this.baseURI = "/" + this.baseURI;
        }
        if (this.baseURI.charAt(this.baseURI.length() - 1) != '/') {
            this.baseURI = this.baseURI + "/";
        }
        this.rctxt = rctxt;
        this.basePackageName = "org.apache.jsp";
        this.taglibs = (ConcurrentHashMap)JspCompilationContext.cast(context.getAttribute("com.sun.jsp.taglibraryCache"));
        this.tagFileJarUrls = (ConcurrentHashMap)JspCompilationContext.cast(context.getAttribute("com.sun.jsp.tagFileJarUrlsCache"));
    }

    private static <T> T cast(Object x) {
        return (T)x;
    }

    public JspCompilationContext(String tagfile, TagInfo tagInfo, Options options, ServletContext context, JspServletWrapper jsw, JspRuntimeContext rctxt, URL tagFileJarUrl) throws WaspException {
        this(tagfile, false, options, context, jsw, rctxt);
        this.isTagFile = true;
        this.tagInfo = tagInfo;
        this.tagFileJarUrl = tagFileJarUrl;
    }

    public void addTaglib(String uri, TagLibraryInfoImpl taglib) {
        this.taglibs.put(uri, taglib);
    }

    public ConcurrentHashMap<String, TagLibraryInfoImpl> getTaglibs() {
        return this.taglibs;
    }

    public void clearTaglibs() {
        this.taglibs.clear();
    }

    public void clearTagFileJarUrls() {
        this.tagFileJarUrls.clear();
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return this.rctxt.getClassPath();
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public ClassLoader getClassLoader() {
        if (this.loader == null) {
            this.loader = this.rctxt.getParentClassLoader();
        }
        return this.loader;
    }

    public void setClassLoader(URLClassLoader loader) {
        this.setClassLoader((ClassLoader)loader);
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public String getOutputDir() {
        if (this.outputDir == null) {
            this.createOutputDir();
        }
        return this.outputDir;
    }

    public Compiler createParser() throws WaspException {
        this.jspCompiler = new Compiler(this, this.jsw);
        return this.jspCompiler;
    }

    public Compiler createCompiler(boolean jspcMode) throws WaspException {
        if (this.jspCompiler != null) {
            return this.jspCompiler;
        }
        this.jspCompiler = new Compiler(this, this.jsw, jspcMode);
        return this.jspCompiler;
    }

    public Compiler getCompiler() {
        return this.jspCompiler;
    }

    public String resolveRelativeUri(String uri) {
        if (uri.startsWith("/") || uri.startsWith(File.separator)) {
            return uri;
        }
        return this.baseURI + uri;
    }

    public InputStream getResourceAsStream(String res) throws WaspException {
        return this.context.getResourceAsStream(JspCompilationContext.canonicalURI(res));
    }

    public URL getResource(String res) throws MalformedURLException {
        URL result = null;
        if (res.startsWith("/META-INF/")) {
            URL jarUrl = this.tagFileJarUrls.get(res);
            if (jarUrl == null) {
                jarUrl = this.tagFileJarUrl;
            }
            if (jarUrl != null) {
                result = new URL(jarUrl.toExternalForm() + res.substring(1));
            }
        } else if (res.startsWith("jar:file:")) {
            result = new URL(res);
        } else {
            try {
                result = this.context.getResource(JspCompilationContext.canonicalURI(res));
            }
            catch (WaspException ex) {
                throw new MalformedURLException(ex.getMessage());
            }
        }
        return result;
    }

    public Set<String> getResourcePaths(String path) throws WaspException {
        return this.context.getResourcePaths(JspCompilationContext.canonicalURI(path));
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }

    public ConcurrentHashMap<String, URL> getTagFileJarUrls() {
        return this.tagFileJarUrls;
    }

    public URL getTagFileJarUrl() {
        return this.tagFileJarUrl;
    }

    public String getServletClassName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.isTagFile) {
            this.className = this.tagInfo.getTagClassName();
            int lastIndex = this.className.lastIndexOf(46);
            if (lastIndex != -1) {
                this.className = this.className.substring(lastIndex + 1);
            }
        } else {
            int iSep = this.jspUri.lastIndexOf(47) + 1;
            this.className = JspUtil.makeJavaIdentifier(this.jspUri.substring(iSep));
        }
        return this.className;
    }

    public void setServletClassName(String className) {
        this.className = className;
    }

    public String getJspFile() {
        return this.jspUri;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public boolean isTagFile() {
        return this.isTagFile;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    public void setTagInfo(TagInfo tagi) {
        this.tagInfo = tagi;
    }

    public boolean isPrototypeMode() {
        return this.protoTypeMode;
    }

    public void setPrototypeMode(boolean pm) {
        this.protoTypeMode = pm;
    }

    public String getServletPackageName() {
        if (this.isTagFile()) {
            String className = this.tagInfo.getTagClassName();
            int lastIndex = className.lastIndexOf(46);
            String pkgName = "";
            if (lastIndex != -1) {
                pkgName = className.substring(0, lastIndex);
            }
            return pkgName;
        }
        String dPackageName = this.getDerivedPackageName();
        if (dPackageName.length() == 0) {
            return this.basePackageName;
        }
        return this.basePackageName + "." + this.getDerivedPackageName();
    }

    private String getDerivedPackageName() {
        if (this.derivedPackageName == null) {
            int iSep = this.jspUri.lastIndexOf(47);
            this.derivedPackageName = iSep > 0 ? JspUtil.makeJavaPackage(this.jspUri.substring(1, iSep)) : "";
        }
        return this.derivedPackageName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.basePackageName = servletPackageName;
    }

    public String getServletJavaFileName() {
        if (this.servletJavaFileName == null) {
            this.servletJavaFileName = this.getOutputDir() + this.getServletClassName() + ".java";
        }
        return this.servletJavaFileName;
    }

    public Options getOptions() {
        return this.options;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public JspRuntimeContext getRuntimeContext() {
        return this.rctxt;
    }

    public String getFullClassName() {
        if (this.isTagFile()) {
            return this.tagInfo.getTagClassName();
        }
        return this.getServletPackageName() + "." + this.getServletClassName();
    }

    public String getJavaPath() {
        if (this.javaPath != null) {
            return this.javaPath;
        }
        this.javaPath = this.getFullClassName().replace('.', '/') + ".java";
        return this.javaPath;
    }

    public String getClassFileName() {
        if (this.classFileName == null) {
            this.classFileName = this.getOutputDir() + this.getServletClassName() + ".class";
        }
        return this.classFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public String[] getTldLocation(String uri) throws WaspException {
        String[] location = this.getOptions().getTldScanner().getLocation(uri);
        return location;
    }

    public boolean keepGenerated() {
        return this.getOptions().getKeepGenerated();
    }

    public void incrementRemoved() {
        if (this.removed > 1) {
            if (this.jspCompiler != null) {
                this.jspCompiler.removeGeneratedFiles();
            }
            if (this.rctxt != null) {
                this.rctxt.removeWrapper(this.jspUri);
            }
        }
        ++this.removed;
    }

    public boolean isRemoved() {
        return this.removed > 1;
    }

    public void compile() throws WaspException, FileNotFoundException {
        this.createCompiler(false);
        if (this.jspCompiler.isOutDated()) {
            try {
                this.jspCompiler.compile(true);
                this.jsw.setReload(true);
                this.jsw.setCompilationException(null);
            }
            catch (WaspException ex) {
                this.jsw.setCompilationException(ex);
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                WaspException je = new WaspException(Localizer.getMessage("jsp.error.unable.compile"), ex);
                this.jsw.setCompilationException(je);
                throw je;
            }
        }
    }

    public Class<?> load() throws WaspException, ClassNotFoundException {
        try {
            String name = this.getFullClassName();
            this.servletClass = this.options.getUsePrecompiled() ? this.getClassLoader().loadClass(name) : this.getJspLoader().loadClass(name);
        }
        catch (ClassNotFoundException cex) {
            if (this.options.getUsePrecompiled()) {
                throw cex;
            }
            throw new WaspException(Localizer.getMessage("jsp.error.unable.load"), cex);
        }
        catch (Exception ex) {
            throw new WaspException(Localizer.getMessage("jsp.error.unable.compile"), ex);
        }
        this.removed = 0;
        return this.servletClass;
    }

    public ClassLoader getJspLoader() {
        return new WaspLoader(new URL[]{this.baseUrl}, this.getClassLoader(), this.rctxt.getBytecodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeOutputDir(String outdir) {
        Object object = outputDirLock;
        synchronized (object) {
            File outDirFile = new File(outdir);
            outDirFile.mkdirs();
            this.outputDir = outdir;
        }
    }

    private void createOutputDir() {
        String path = null;
        if (this.isTagFile()) {
            String tagName = this.tagInfo.getTagClassName();
            path = tagName.replace('.', '/');
            path = path.substring(0, path.lastIndexOf(47));
        } else {
            path = this.getServletPackageName().replace('.', '/');
        }
        try {
            File f = new File(this.options.getScratchDir(), path);
            this.makeOutputDir(f.getPath() + File.separator);
            this.baseUrl = this.options.getScratchDir().toURI().toURL();
        }
        catch (Exception e) {
            throw new IllegalStateException("No output directory: " + e.getMessage());
        }
    }

    private static final boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    private static final String canonicalURI(String s) throws WaspException {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int len = s.length();
        int pos = 0;
        block4: while (pos < len) {
            char c = s.charAt(pos);
            if (JspCompilationContext.isPathSeparator(c)) {
                while (pos + 1 < len && JspCompilationContext.isPathSeparator(s.charAt(pos + 1))) {
                    ++pos;
                }
                if (pos + 1 < len && s.charAt(pos + 1) == '.') {
                    if (pos + 2 >= len) break;
                    switch (s.charAt(pos + 2)) {
                        case '/': 
                        case '\\': {
                            pos += 2;
                            continue block4;
                        }
                        case '.': {
                            if (pos + 3 >= len || !JspCompilationContext.isPathSeparator(s.charAt(pos + 3))) break;
                            pos += 3;
                            int separatorPos = result.length() - 1;
                            if (separatorPos < 0) {
                                throw new WaspException(Localizer.getMessage("jsp.error.badpath", s));
                            }
                            while (separatorPos >= 0 && !JspCompilationContext.isPathSeparator(result.charAt(separatorPos))) {
                                --separatorPos;
                            }
                            if (separatorPos < 0) continue block4;
                            result.setLength(separatorPos);
                            continue block4;
                        }
                    }
                }
            }
            result.append(c);
            ++pos;
        }
        return result.toString();
    }
}

