/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parameter;
import org.glassfish.hk2.classmodel.reflect.ParameterizedType;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Service;

@Service
public class SnifferManagerImpl
implements SnifferManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SnifferManagerImpl.class);
    @Inject
    protected ServiceLocator serviceLocator;

    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>(this.serviceLocator.getAllServices(Sniffer.class, new Annotation[0]));
        Collections.sort(sniffers, (o1, o2) -> o1.getModuleType().compareTo(o2.getModuleType()));
        return sniffers;
    }

    public final boolean hasNoSniffers() {
        return this.getSniffers().isEmpty();
    }

    public Sniffer getSniffer(String appType) {
        assert (appType != null);
        for (Sniffer sniffer : this.getSniffers()) {
            if (!appType.equalsIgnoreCase(sniffer.getModuleType())) continue;
            return sniffer;
        }
        return null;
    }

    public Collection<Sniffer> getSniffers(DeploymentContext context) {
        return this.getSniffers(context, context.getArchiveHandler().getClassPathURIs(context.getSource()), (Types)context.getTransientAppMetaData(Types.class.getName(), Types.class));
    }

    public Collection<Sniffer> getSniffers(DeploymentContext context, List<URI> uris, Types types) {
        Collection<Sniffer> regularSniffers = this.getSniffers();
        List<Sniffer> appSniffers = this.getApplicableSniffers(context, uris, types, regularSniffers, true);
        for (Sniffer sniffer : regularSniffers) {
            if (appSniffers.contains(sniffer) || !sniffer.handles(context)) continue;
            appSniffers.add(sniffer);
        }
        return appSniffers;
    }

    private <T extends Sniffer> List<T> getApplicableSniffers(DeploymentContext context, List<URI> uris, Types types, Collection<T> sniffers, boolean checkPath) {
        if (sniffers == null || sniffers.isEmpty() || types == null || types.getAllTypes().isEmpty()) {
            return new ArrayList();
        }
        ArchiveType archiveType = (ArchiveType)this.serviceLocator.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        ArrayList<Sniffer> applicableSniffers = new ArrayList<Sniffer>();
        for (Sniffer sniffer : sniffers) {
            if (!this.isSnifferApplicable(sniffer, archiveType, context, uris, types, checkPath)) continue;
            applicableSniffers.add(sniffer);
        }
        return applicableSniffers;
    }

    private <T extends Sniffer> boolean isSnifferApplicable(T sniffer, ArchiveType archiveType, DeploymentContext context, List<URI> uris, Types types, boolean checkPath) {
        if (archiveType != null && !sniffer.supportsArchiveType(archiveType)) {
            return false;
        }
        String[] annotationNames = sniffer.getAnnotationNames(context);
        if (annotationNames == null) {
            return false;
        }
        for (String annotationName : annotationNames) {
            Type type = types.getBy(annotationName);
            if (!(type instanceof AnnotationType)) continue;
            AnnotationType annotationType = (AnnotationType)type;
            Collection elements = annotationType.allAnnotatedTypes();
            for (AnnotatedElement element : elements) {
                if (checkPath) {
                    Type t = SnifferManagerImpl.getDeclaringType(element);
                    if (t == null || !t.wasDefinedIn(uris)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public void validateSniffers(Collection<? extends Sniffer> sniffers, DeploymentContext context) {
        HashMap sniffersByModuleType = null;
        for (Sniffer sniffer : sniffers) {
            String[] incompatibleTypes = sniffer.getIncompatibleSnifferTypes();
            if (incompatibleTypes == null || incompatibleTypes.length == 0) continue;
            if (sniffersByModuleType == null) {
                sniffersByModuleType = SnifferManagerImpl.createMapOfSniffersByModuleType(sniffers);
            }
            for (String type : incompatibleTypes) {
                if (!sniffersByModuleType.containsKey(type)) continue;
                throw new IllegalArgumentException(localStrings.getLocalString("invalidarchivepackaging", "Invalid archive packaging {2}", new Object[]{sniffer.getModuleType(), type, context.getSourceDir().getPath()}));
            }
        }
    }

    private static HashMap createMapOfSniffersByModuleType(Collection<? extends Sniffer> sniffers) {
        HashMap<String, Sniffer> sniffersByModuleType = new HashMap<String, Sniffer>();
        for (Sniffer sniffer : sniffers) {
            sniffersByModuleType.put(sniffer.getModuleType(), sniffer);
        }
        return sniffersByModuleType;
    }

    private static Type getDeclaringType(AnnotatedElement element) {
        if (element instanceof Type) {
            return (Type)element;
        }
        if (element instanceof Member) {
            return ((Member)element).getDeclaringType();
        }
        if (element instanceof Parameter) {
            return SnifferManagerImpl.getDeclaringType((AnnotatedElement)((Parameter)element).getMethod());
        }
        if (element instanceof ParameterizedType) {
            return ((ParameterizedType)element).getType();
        }
        throw new IllegalStateException("Unable to recognise declaring type: " + element.getName());
    }
}

