/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class UniqueConstraintMetadata
extends ORMetadata {
    private String m_name;
    private List<String> m_columnNames;
    private String m_options;

    public UniqueConstraintMetadata() {
        super("<unique-constraint>");
    }

    public UniqueConstraintMetadata(MetadataAnnotation uniqueConstraint, MetadataAccessor accessor) {
        super(uniqueConstraint, accessor);
        this.m_name = uniqueConstraint.getAttributeString("name");
        this.m_options = uniqueConstraint.getAttributeString("options");
        this.m_columnNames = new ArrayList<String>();
        for (Object columnName : uniqueConstraint.getAttributeArray("columnNames")) {
            this.m_columnNames.add((String)columnName);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof UniqueConstraintMetadata) {
            UniqueConstraintMetadata uniqueConstraint = (UniqueConstraintMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, uniqueConstraint.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_columnNames, uniqueConstraint.getColumnNames())) {
                return false;
            }
            return this.valuesMatch(this.m_options, uniqueConstraint.getOptions());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_columnNames != null ? this.m_columnNames.hashCode() : 0);
        result = 31 * result + (this.m_options != null ? this.m_options.hashCode() : 0);
        return result;
    }

    public List<String> getColumnNames() {
        return this.m_columnNames;
    }

    public String getName() {
        return this.m_name;
    }

    public String getOptions() {
        return this.m_options;
    }

    public boolean hasName() {
        return this.m_name != null && !this.m_name.isEmpty();
    }

    public void setColumnNames(List<String> columnNames) {
        this.m_columnNames = columnNames;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOptions(String options) {
        this.m_options = options;
    }
}

