/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.cluster.SynchronizeInstanceCommand;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.servermgmt.cli.ServerLifeSignCheck;
import com.sun.enterprise.admin.servermgmt.cli.StartServerCommand;
import com.sun.enterprise.admin.servermgmt.cli.StartServerHelper;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-local-instance")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
public class StartLocalInstanceCommand
extends SynchronizeInstanceCommand
implements StartServerCommand {
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;
    @Param(optional=true, shortName="w", defaultValue="false")
    private boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private boolean debug;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private boolean dryRun;
    @Param(optional=true)
    private Integer timeout;
    @Param(name="check-pid-file", optional=true, defaultValue="true")
    private boolean checkPidFile;
    @Param(name="check-process-alive", optional=true, defaultValue="true")
    private boolean checkProcessAlive;
    @Param(name="check-admin-port", optional=true, defaultValue="true")
    private boolean checkAdminEndpoint;
    @Param(name="server-output", shortName="o", optional=true)
    private Boolean printServerOutput;
    @Param(name="custom-endpoints", optional=true)
    private String customEndpoints;
    private GFLauncherInfo launchParameters;
    private GFLauncher launcher;
    private StartServerHelper startServerHelper;

    public RuntimeType getType() {
        return RuntimeType.INSTANCE;
    }

    @Override
    protected boolean mkdirs(File f) {
        return false;
    }

    public Duration getTimeout() {
        return this.timeout == null ? CLIConstants.WAIT_FOR_DAS_TIME_MS : Duration.ofSeconds(this.timeout.intValue());
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        File dir = this.getServerDirs().getServerDir();
        if (!dir.isDirectory()) {
            throw new CommandException(Strings.get("Instance.noSuchInstance"));
        }
    }

    @Override
    protected int executeCommand() throws CommandException {
        logger.finer(() -> this.toString());
        if (this.sync.equals("none")) {
            logger.info(Strings.get("Instance.nosync"));
        } else if (!this.synchronizeInstance()) {
            File domainXml = new File(new File(this.instanceDir, "config"), "domain.xml");
            if (!domainXml.exists()) {
                logger.info(Strings.get("Instance.nodomainxml"));
                return 1;
            }
            logger.info(Strings.get("Instance.syncFailed"));
        }
        try {
            this.launcher = this.createLauncher();
            List userEndpoints = StartServerHelper.parseCustomEndpoints((String)this.customEndpoints);
            ServerLifeSignCheck signOfLife = new ServerLifeSignCheck("instance " + this.getInstanceName(), this.printServerOutput, this.checkPidFile, this.checkProcessAlive, this.checkAdminEndpoint, userEndpoints);
            this.startServerHelper = new StartServerHelper(this.programOpts.isTerse(), this.getTimeout(), this.getServerDirs(), this.launcher, signOfLife);
            if (this.dryRun) {
                logger.log(Level.FINE, Strings.get("dry_run_msg"));
                logger.log(Level.INFO, this.launcher.getCommandLine().toString("\n"));
                return 0;
            }
            this.launcher.launch();
            if (this.verbose || this.watchdog) {
                return this.startServerHelper.talkWithUser();
            }
            String report = this.startServerHelper.waitForServerStart(this.getTimeout());
            logger.info(report);
            return 0;
        }
        catch (GFLauncherException e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
        catch (MiniXmlParserException e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    public final GFLauncher createLauncher() throws GFLauncherException, MiniXmlParserException, CommandException {
        GFLauncher gfLauncher = GFLauncherFactory.getInstance((RuntimeType)this.getType());
        this.launchParameters = gfLauncher.getParameters();
        this.launchParameters.setInstanceName(this.instanceName);
        this.launchParameters.setInstanceRootDir(this.instanceDir);
        this.launchParameters.setVerbose(this.verbose);
        this.launchParameters.setIgnoreOutput(this.printServerOutput == Boolean.FALSE);
        this.launchParameters.setWatchdog(this.watchdog);
        this.launchParameters.setDebug(this.debug);
        this.launchParameters.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getModulePath(), this.programOpts.getClassPath(), this.respawnArgs());
        this.launchParameters.setAsadminAdminAddress(this.getUserProvidedAdminAddress());
        gfLauncher.setup();
        this.launchParameters.addSecurityToken("AS_ADMIN_MASTERPASSWORD", this.getMasterPassword());
        return gfLauncher;
    }

    public String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)((Object)this));
    }

    private String[] respawnArgs() {
        ArrayList<Object> args = new ArrayList<Object>(15);
        args.addAll(Arrays.asList(this.programOpts.getProgramArguments()));
        args.add(this.getName());
        args.add("--verbose=" + String.valueOf(this.verbose));
        args.add("--watchdog=" + String.valueOf(this.watchdog));
        args.add("--debug=" + String.valueOf(this.debug));
        if (StartLocalInstanceCommand.ok((String)this.nodeDir)) {
            args.add("--nodedir");
            args.add(this.nodeDir);
        }
        if (StartLocalInstanceCommand.ok((String)this.node)) {
            args.add("--node");
            args.add(this.node);
        }
        if (StartLocalInstanceCommand.ok((String)this.instanceName)) {
            args.add(this.instanceName);
        }
        logger.log(Level.FINER, "Respawn args: {0}", args);
        return (String[])args.toArray(String[]::new);
    }
}

