/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.graphs;

import java.util.Map;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.AttributeGroup;

public class NamedAttributeNodeMetadata
extends ORMetadata {
    protected String m_name;
    protected String m_subgraph;
    protected String m_keySubgraph;

    public NamedAttributeNodeMetadata() {
        super("<named-entity-graph>");
    }

    public NamedAttributeNodeMetadata(MetadataAnnotation namedAttributeNode, ClassAccessor accessor) {
        super(namedAttributeNode, accessor);
        this.m_name = namedAttributeNode.getAttributeString("value");
        this.m_subgraph = namedAttributeNode.getAttributeString("subgraph");
        this.m_keySubgraph = namedAttributeNode.getAttributeString("key-subgraph");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NamedAttributeNodeMetadata) {
            NamedAttributeNodeMetadata attributeNode = (NamedAttributeNodeMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, attributeNode.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_subgraph, attributeNode.getSubgraph())) {
                return false;
            }
            return this.valuesMatch(this.m_keySubgraph, attributeNode.getKeySubgraph());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_subgraph != null ? this.m_subgraph.hashCode() : 0);
        result = 31 * result + (this.m_keySubgraph != null ? this.m_keySubgraph.hashCode() : 0);
        return result;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public String getKeySubgraph() {
        return this.m_keySubgraph;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSubgraph() {
        return this.m_subgraph;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Map<String, Map<String, AttributeGroup>> attributeGraphs, AttributeGroup graph, AttributeGroup rootGraph) {
        String subgraph = this.getSubgraph();
        if (subgraph != null && !subgraph.isEmpty()) {
            if (!attributeGraphs.containsKey(subgraph)) throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"managed_component_not_found", (Object[])new Object[]{graph.getName(), this.getName(), subgraph}));
            graph.addAttribute(this.getName(), attributeGraphs.get(subgraph).values());
        } else {
            graph.addAttribute(this.getName());
        }
        subgraph = this.getKeySubgraph();
        if (subgraph == null || subgraph.isEmpty()) return;
        if (!attributeGraphs.containsKey(subgraph)) throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"managed_component_not_found", (Object[])new Object[]{graph.getName(), this.getName(), subgraph}));
        graph.getItem(this.getName()).addKeyGroups(attributeGraphs.get(subgraph).values());
    }

    public void setKeySubgraph(String keySubgraph) {
        this.m_keySubgraph = keySubgraph;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSubgraph(String subgraph) {
        this.m_subgraph = subgraph;
    }
}

