/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.nosql.metadata.reflection;

import jakarta.nosql.AttributeConverter;
import jakarta.nosql.Embeddable;
import jakarta.nosql.Entity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collection;
import org.eclipse.jnosql.mapping.metadata.ArrayParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.glassfish.main.jnosql.nosql.metadata.reflection.DefaultParameterMetaData;

class DefaultArrayParameterMetaData
extends DefaultParameterMetaData
implements ArrayParameterMetaData {
    private final Class<?> elementType;
    private final boolean embeddableField;

    DefaultArrayParameterMetaData(String name, Class<?> type, boolean id, Class<? extends AttributeConverter<?, ?>> converter, MappingType mappingType, Class<?> elementType) {
        super(name, type, id, converter, mappingType);
        this.elementType = elementType;
        this.embeddableField = this.hasFieldAnnotation(Embeddable.class) || this.hasFieldAnnotation(Entity.class);
    }

    public boolean isEmbeddable() {
        return this.embeddableField;
    }

    public Class<?> elementType() {
        return this.elementType;
    }

    public Object arrayInstance(Collection<?> collection) {
        Object array = Array.newInstance(this.elementType, collection.size());
        int index = 0;
        for (Object item : collection) {
            Array.set(array, index++, item);
        }
        return array;
    }

    private boolean hasFieldAnnotation(Class<? extends Annotation> annotation) {
        return this.elementType.getAnnotation(annotation) != null;
    }
}

