/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util;

import com.sun.enterprise.util.CULoggerInfo;
import com.sun.enterprise.util.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.common.util.ObjectInputOutputStreamFactory;
import org.glassfish.common.util.ObjectInputStreamWithLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class OSGiObjectInputOutputStreamFactoryImpl
implements ObjectInputOutputStreamFactory {
    private static final Logger logger = CULoggerInfo.getLogger();
    private BundleContext ctx;
    PackageAdmin pkgAdm;
    private ConcurrentHashMap<String, Long> name2Id = new ConcurrentHashMap();
    private static final String NOT_A_BUNDLE_KEY = ":";

    public OSGiObjectInputOutputStreamFactoryImpl(BundleContext ctx) {
        this.ctx = ctx;
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        this.pkgAdm = (PackageAdmin)PackageAdmin.class.cast(ctx.getService(ref));
        BundleTracker bt = new BundleTracker(ctx, 46, new BundleTrackerCustomizer(){

            public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object o) {
            }

            public Object addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                String key = OSGiObjectInputOutputStreamFactoryImpl.this.makeKey(bundle);
                OSGiObjectInputOutputStreamFactoryImpl.this.name2Id.put(key, bundle.getBundleId());
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "BundleTracker.addingBundle BUNDLE " + key + " ==> " + bundle.getBundleId() + "  for " + bundle.getSymbolicName());
                }
                return null;
            }

            public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Object o) {
                String key = OSGiObjectInputOutputStreamFactoryImpl.this.makeKey(bundle);
                Long bundleID = OSGiObjectInputOutputStreamFactoryImpl.this.name2Id.remove(key);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "BundleTracker.removedBundle BUNDLE " + key + "  ==> " + bundle.getSymbolicName());
                }
                if (bundleID == null) {
                    logger.log(Level.WARNING, "NCLS-COMUTIL-00042", key);
                }
            }
        });
        bt.open();
    }

    private String makeKey(Bundle bundle) {
        return bundle.getSymbolicName() + NOT_A_BUNDLE_KEY + String.valueOf(bundle.getVersion());
    }

    @Override
    public ObjectInputStream createObjectInputStream(InputStream in) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = Utility.getClassLoader();
        }
        return new OSGiObjectInputStream(in, loader);
    }

    @Override
    public ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return new OSGiObjectOutputStream(out);
    }

    @Override
    public Class<?> resolveClass(ObjectInputStream in, ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Long bundleId;
        String key = in.readUTF();
        if (!NOT_A_BUNDLE_KEY.equals(key) && (bundleId = this.name2Id.get(key)) != null) {
            Bundle b = this.ctx.getBundle(bundleId.longValue());
            String cname = desc.getName();
            if (cname.startsWith("[")) {
                return this.loadArrayClass(b, cname);
            }
            return this.loadClassFromBundle(b, cname);
        }
        return null;
    }

    @Override
    public void annotateClass(ObjectOutputStream out, Class<?> cl) throws IOException {
        String key = NOT_A_BUNDLE_KEY;
        Bundle b = this.pkgAdm.getBundle(cl);
        if (b != null) {
            key = this.makeKey(b);
        }
        out.writeUTF(key);
    }

    private Class loadArrayClass(Bundle b, String cname) throws ClassNotFoundException {
        assert (cname.charAt(0) == 'L');
        int dcount = 1;
        while (cname.charAt(dcount) == '[') {
            ++dcount;
        }
        assert (cname.charAt(dcount) == 'L');
        Class component = this.loadClassFromBundle(b, cname.substring(dcount + 1, cname.length() - 1));
        int[] dim = new int[dcount];
        for (int i = 0; i < dcount; ++i) {
            dim[i] = 0;
        }
        return Array.newInstance(component, dim).getClass();
    }

    private Class loadClassFromBundle(final Bundle b, final String cname) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return b.loadClass(cname);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ClassNotFoundException {
                    return b.loadClass(cname);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    private class OSGiObjectInputStream
    extends ObjectInputStreamWithLoader {
        public OSGiObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
            super(in, loader);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            Class clazz = OSGiObjectInputOutputStreamFactoryImpl.this.resolveClass(this, desc);
            if (clazz == null) {
                clazz = super.resolveClass(desc);
            }
            return clazz;
        }
    }

    private class OSGiObjectOutputStream
    extends ObjectOutputStream {
        private OSGiObjectOutputStream(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> cl) throws IOException {
            OSGiObjectInputOutputStreamFactoryImpl.this.annotateClass(this, cl);
        }
    }
}

