/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.logviewer;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class LineEndNormalizingWriter
extends FilterWriter {
    private boolean seenCR;
    private static final int CR = 13;
    private static final int LF = 10;

    public LineEndNormalizingWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(int c) throws IOException {
        if (!this.seenCR && c == 10) {
            super.write("\r\n");
        } else {
            super.write(c);
        }
        this.seenCR = c == 13;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        int writeBegin = off;
        for (int i = off; i < end; ++i) {
            char ch = cbuf[i];
            if (!this.seenCR && ch == '\n') {
                super.write(cbuf, writeBegin, i - writeBegin);
                super.write("\r\n");
                writeBegin = i + 1;
            }
            this.seenCR = ch == '\r';
        }
        super.write(cbuf, writeBegin, end - writeBegin);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int end = off + len;
        int writeBegin = off;
        for (int i = off; i < end; ++i) {
            char ch = str.charAt(i);
            if (!this.seenCR && ch == '\n') {
                super.write(str, writeBegin, i - writeBegin);
                super.write("\r\n");
                writeBegin = i + 1;
            }
            this.seenCR = ch == '\r';
        }
        super.write(str, writeBegin, end - writeBegin);
    }
}

