/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractCommonAttributeHandler;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.TypeUtil;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotatedElementHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;

abstract class AbstractAuthAnnotationHandler
extends AbstractCommonAttributeHandler
implements PostProcessor<EjbContext> {
    private static final Logger LOG = DOLUtils.getDefaultLogger();

    AbstractAuthAnnotationHandler() {
    }

    protected abstract void processEjbMethodSecurity(Annotation var1, MethodDescriptor var2, EjbDescriptor var3);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        if (!this.validateAccessControlAnnotations(ainfo)) {
            return this.getDefaultFailedResult();
        }
        Annotation authAnnotation = ainfo.getAnnotation();
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (ElementType.TYPE.equals((Object)ainfo.getElementType())) {
                ejbContext.addPostProcessInfo(ainfo, this);
                continue;
            }
            Method annMethod = (Method)ainfo.getAnnotatedElement();
            for (MethodDescriptor md : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                Method m;
                if (this.hasMethodPermissionsFromDD(md, ejbDesc) || !TypeUtil.sameMethodSignature(m = md.getMethod(ejbDesc), annMethod)) continue;
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        }
        return this.getDefaultProcessedResult();
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebComponentContext[] webCompContexts) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult((AnnotatedElementHandler)webCompContexts[0], ainfo);
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, WebBundleContext webBundleContext) throws AnnotationProcessorException {
        return this.getInvalidAnnotatedElementHandlerResult((AnnotatedElementHandler)webBundleContext, ainfo);
    }

    @Override
    public void postProcessAnnotation(AnnotationInfo ainfo, EjbContext ejbContext) throws AnnotationProcessorException {
        EjbDescriptor ejbDesc = ejbContext.getDescriptor();
        Annotation authAnnotation = ainfo.getAnnotation();
        if (ejbContext.isInherited() || !ejbDesc.getMethodPermissionsFromDD().isEmpty()) {
            Class classAn = (Class)ainfo.getAnnotatedElement();
            for (MethodDescriptor md : ejbDesc.getSecurityBusinessMethodDescriptors()) {
                if (!classAn.equals(ejbContext.getDeclaringClass(md)) || this.hasMethodPermissionsFromDD(md, ejbDesc)) continue;
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        } else {
            for (MethodDescriptor md : this.getMethodAllDescriptors(ejbDesc)) {
                this.processEjbMethodSecurity(authAnnotation, md, ejbDesc);
            }
        }
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }

    protected Class<? extends Annotation>[] relatedAnnotationTypes() {
        return new Class[0];
    }

    private Set<MethodDescriptor> getMethodAllDescriptors(EjbDescriptor ejbDesc) {
        HashSet<MethodDescriptor> methodAlls = new HashSet<MethodDescriptor>();
        if (ejbDesc.isRemoteInterfacesSupported() || ejbDesc.isRemoteBusinessInterfacesSupported()) {
            methodAlls.add(new MethodDescriptor("*", "", "Remote"));
            if (ejbDesc.isRemoteInterfacesSupported()) {
                methodAlls.add(new MethodDescriptor("*", "", "Home"));
            }
        }
        if (ejbDesc.isLocalInterfacesSupported() || ejbDesc.isLocalBusinessInterfacesSupported()) {
            methodAlls.add(new MethodDescriptor("*", "", "Local"));
            if (ejbDesc.isLocalInterfacesSupported()) {
                methodAlls.add(new MethodDescriptor("*", "", "LocalHome"));
            }
        }
        if (ejbDesc.isLocalBean()) {
            methodAlls.add(new MethodDescriptor("*", "", "Local"));
        }
        if (ejbDesc.hasWebServiceEndpointInterface()) {
            methodAlls.add(new MethodDescriptor("*", "", "ServiceEndpoint"));
        }
        return methodAlls;
    }

    private boolean hasMethodPermissionsFromDD(MethodDescriptor methodDesc, EjbDescriptor ejbDesc) {
        Map<MethodPermission, ArrayList<MethodDescriptor>> methodPermissionsFromDD = ejbDesc.getMethodPermissionsFromDD();
        if (methodPermissionsFromDD.isEmpty()) {
            return false;
        }
        Set<MethodDescriptor> allMethods = ejbDesc.getMethodDescriptors();
        for (List list : methodPermissionsFromDD.values()) {
            for (MethodDescriptor md : list) {
                for (MethodDescriptor style3Md : md.doStyleConversion(ejbDesc, allMethods)) {
                    LOG.log(Level.FINEST, "Comparing style3Md: {0} and methodDesc: {1}", new Object[]{style3Md, methodDesc});
                    if (!methodDesc.equals((Object)style3Md)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean validateAccessControlAnnotations(AnnotationInfo ainfo) throws AnnotationProcessorException {
        boolean validity = true;
        AnnotatedElement ae = ainfo.getAnnotatedElement();
        int count = 0;
        count += ae.isAnnotationPresent(RolesAllowed.class) ? 1 : 0;
        if (ae.isAnnotationPresent(DenyAll.class)) {
            ++count;
        }
        if (count < 2 && ae.isAnnotationPresent(PermitAll.class)) {
            ++count;
        }
        if (count > 1) {
            this.log(Level.SEVERE, ainfo, I18N.getLocalString("enterprise.deployment.annotation.handlers.morethanoneauthannotation", "One cannot have more than one of @RolesAllowed, @PermitAll, @DenyAll in the same AnnotatedElement."));
            validity = false;
        }
        return validity;
    }
}

