/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class ExitManager
implements Runnable {
    private final File tempStatusFile;
    private final File statusFile;
    private PrintWriter reportWriter;
    private CommentWriter commentWriter;
    private Throwable reportedFailure = null;
    private AtomicInteger reportedStatus = new AtomicInteger(0);
    private static final Logger logger = Logger.getLogger(ExitManager.class.getName());

    ExitManager(String testReportLocation) {
        this.statusFile = new File(this.statusFileName(testReportLocation));
        this.tempStatusFile = new File(this.statusTempFileName(testReportLocation));
        this.prepareReportWriter(this.tempStatusFile);
        Runtime.getRuntime().addShutdownHook(new Thread(this));
        logger.log(Level.FINE, "ExitManager initialized");
    }

    @Override
    public void run() {
        logger.log(Level.FINE, "ExitManager writing output");
        this.reportWriter.println("jws.exit.status=" + String.valueOf(this.reportedStatus));
        if (this.reportedFailure != null) {
            this.reportedFailure.printStackTrace(this.commentWriter);
        }
        this.reportWriter.close();
        if (!this.tempStatusFile.renameTo(this.statusFile)) {
            throw new RuntimeException("Could not rename temp status file from " + this.tempStatusFile.getAbsolutePath() + " to " + this.statusFile.getAbsolutePath());
        }
    }

    private void prepareReportWriter(File tempTestReportFile) {
        try {
            this.reportWriter = new PrintWriter(tempTestReportFile);
            this.commentWriter = new CommentWriter(this.reportWriter);
            logger.log(Level.FINE, "PrintWriter for temp exit file {0} ready", tempTestReportFile.getAbsolutePath());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String statusFileName(String testReportLocation) {
        return testReportLocation + ".status";
    }

    private String statusTempFileName(String testReportLocation) {
        return this.statusFileName(testReportLocation) + ".tmp";
    }

    void recordFailure(Throwable t) {
        logger.log(Level.FINE, "Recording failure", t);
        this.reportedFailure = t;
        this.recordExit(1);
    }

    void recordExit(int status) {
        logger.log(Level.FINE, "Recording exit {0}", status);
        this.reportedStatus.set(status);
    }

    private static class CommentWriter
    extends PrintWriter {
        private CommentWriter(PrintWriter delegate) {
            super(delegate);
        }

        @Override
        public void println() {
            super.println();
            this.print("#");
        }
    }
}

