/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.java;

import java.io.CharConversionException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;

public class ScannerInputReader
extends FilterReader
implements Constants {
    Environment env;
    long pos;
    private long chpos;
    private int pushBack = -1;
    private static final int BUFFERLEN = 10240;
    private final char[] buffer = new char[10240];
    private int currentIndex = 0;
    private int numChars = 0;

    public ScannerInputReader(Environment env, InputStream in) throws UnsupportedEncodingException {
        super(env.getCharacterEncoding() != null ? new InputStreamReader(in, env.getCharacterEncoding()) : new InputStreamReader(in));
        this.env = env;
        this.chpos = 0x100000000L;
    }

    private int getNextChar() throws IOException {
        if (this.currentIndex >= this.numChars) {
            this.numChars = this.in.read(this.buffer);
            if (this.numChars == -1) {
                return -1;
            }
            this.currentIndex = 0;
        }
        return this.buffer[this.currentIndex++];
    }

    @Override
    public int read(char[] buffer, int off, int len) {
        throw new CompilerError("ScannerInputReader is not a fully implemented reader.");
    }

    @Override
    public int read() throws IOException {
        this.pos = this.chpos++;
        int c = this.pushBack;
        if (c == -1) {
            try {
                if (this.currentIndex >= this.numChars) {
                    this.numChars = this.in.read(this.buffer);
                    if (this.numChars == -1) {
                        c = -1;
                    }
                    this.currentIndex = 0;
                }
                c = this.buffer[this.currentIndex++];
            }
            catch (CharConversionException e) {
                this.env.error(this.pos, "invalid.encoding.char");
                return -1;
            }
        } else {
            this.pushBack = -1;
        }
        switch (c) {
            case -2: {
                return 92;
            }
            case 92: {
                c = this.getNextChar();
                if (c != 117) {
                    this.pushBack = c == 92 ? -2 : c;
                    return 92;
                }
                ++this.chpos;
                while ((c = this.getNextChar()) == 117) {
                    ++this.chpos;
                }
                int d = 0;
                int i = 0;
                while (i < 4) {
                    switch (c) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            d = (d << 4) + c - 48;
                            break;
                        }
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            d = (d << 4) + 10 + c - 97;
                            break;
                        }
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: {
                            d = (d << 4) + 10 + c - 65;
                            break;
                        }
                        default: {
                            this.env.error(this.pos, "invalid.escape.char");
                            this.pushBack = c;
                            return d;
                        }
                    }
                    ++i;
                    ++this.chpos;
                    c = this.getNextChar();
                }
                this.pushBack = c;
                switch (d) {
                    case 10: {
                        this.chpos += 0x100000000L;
                        return 10;
                    }
                    case 13: {
                        c = this.getNextChar();
                        if (c != 10) {
                            this.pushBack = c;
                        } else {
                            ++this.chpos;
                        }
                        this.chpos += 0x100000000L;
                        return 10;
                    }
                }
                return d;
            }
            case 10: {
                this.chpos += 0x100000000L;
                return 10;
            }
            case 13: {
                c = this.getNextChar();
                if (c != 10) {
                    this.pushBack = c;
                } else {
                    ++this.chpos;
                }
                this.chpos += 0x100000000L;
                return 10;
            }
        }
        return c;
    }
}

