/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.Signature;
import org.jboss.logging.annotations.TransformException;
import org.jboss.logging.processor.apt.AbstractClassType;
import org.jboss.logging.processor.apt.ParameterFactory;
import org.jboss.logging.processor.apt.ProcessingException;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.model.ThrowableType;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.util.Objects;

final class ThrowableTypeFactory {
    private ThrowableTypeFactory() {
    }

    public static ThrowableType forReturnType(ProcessingEnvironment processingEnv, TypeMirror type, MessageMethod messageMethod) {
        AptReturnThrowableType result = new AptReturnThrowableType(processingEnv, messageMethod, type);
        result.init();
        return result;
    }

    public static ThrowableType of(ProcessingEnvironment processingEnv, TypeMirror type) {
        AptThrowableType result = new AptThrowableType(processingEnv, type, null);
        result.init();
        return result;
    }

    private static class AptReturnThrowableType
    extends AptThrowableType {
        private final MessageMethod messageMethod;
        private final Set<Parameter> constructionParameters;
        private final Set<ThrowableType> suggestions;
        private boolean useConstructionParameters = false;
        private boolean causeSet = false;

        private AptReturnThrowableType(ProcessingEnvironment processingEnv, MessageMethod messageMethod, TypeMirror type) {
            super(processingEnv, type, messageMethod.hasCause() ? messageMethod.cause().asType() : null);
            this.messageMethod = messageMethod;
            this.constructionParameters = new LinkedHashSet<Parameter>();
            this.suggestions = new LinkedHashSet<ThrowableType>();
        }

        @Override
        protected void init() {
            MessageMethod method = this.messageMethod;
            Signature signature = method.getAnnotation(Signature.class);
            if (signature != null) {
                List<TypeMirror> args = ElementHelper.getClassArrayAnnotationValue(method, Signature.class, "value");
                if (!ElementHelper.hasConstructor(this.types, this, args)) {
                    throw new ProcessingException((Element)method, "Constructor of type %s could not be found with arguments %s", this.asType(), args);
                }
                int causeIndex = signature.causeIndex();
                int messageIndex = signature.messageIndex();
                if (messageIndex < 0) {
                    throw new ProcessingException((Element)method, "A messageIndex of 0 or greater is required. Value %d is invalid.", messageIndex);
                }
                ArrayList<Parameter> methodConstructorParameters = new ArrayList<Parameter>(this.messageMethod.parametersAnnotatedWith(Param.class));
                this.constructionParameters.clear();
                this.useConstructionParameters = true;
                this.causeSet = !this.messageMethod.hasCause();
                int len = methodConstructorParameters.size() + (causeIndex < 0 ? 1 : 2);
                int offset = 0;
                for (int i = 0; i < len; ++i) {
                    if (causeIndex == i) {
                        this.causeSet = true;
                        this.constructionParameters.add(this.messageMethod.cause());
                        ++offset;
                        continue;
                    }
                    if (messageIndex == i) {
                        this.constructionParameters.add(ParameterFactory.forMessageMethod(this.messageMethod));
                        ++offset;
                        continue;
                    }
                    this.constructionParameters.add((Parameter)methodConstructorParameters.get(i - offset));
                }
            } else {
                super.init();
            }
            Optional parameter = this.messageMethod.parametersAnnotatedWith(TransformException.class).stream().findFirst();
            if (parameter.isPresent()) {
                List<TypeMirror> suggestions = ElementHelper.getClassArrayAnnotationValue((Element)parameter.get(), TransformException.class, "value");
                for (TypeMirror suggestion : suggestions) {
                    AptThrowableType result = new AptThrowableType(this.processingEnv, suggestion, null);
                    result.init();
                    this.suggestions.add(result);
                }
            }
        }

        @Override
        protected void init(List<? extends VariableElement> params) {
            Set<Parameter> methodConstructorParameters = this.messageMethod.parametersAnnotatedWith(Param.class);
            if (methodConstructorParameters.isEmpty() || this.useConstructionParameters) {
                return;
            }
            int neededParamSize = methodConstructorParameters.size() + (this.messageMethod.hasCause() ? 2 : 1);
            if (neededParamSize == params.size()) {
                Iterator<Parameter> methodParameterIterator = methodConstructorParameters.iterator();
                LinkedHashSet<Parameter> matchedParams = new LinkedHashSet<Parameter>();
                boolean match = false;
                boolean causeFound = false;
                boolean messageFound = false;
                for (VariableElement variableElement : params) {
                    Parameter parameter;
                    if (!causeFound && this.messageMethod.hasCause() && this.types.isAssignable(this.causeType, variableElement.asType())) {
                        causeFound = true;
                        matchedParams.add(this.messageMethod.cause());
                        continue;
                    }
                    if (!messageFound && this.types.isAssignable(variableElement.asType(), this.stringType)) {
                        messageFound = true;
                        matchedParams.add(ParameterFactory.forMessageMethod(this.messageMethod));
                        continue;
                    }
                    if (methodParameterIterator.hasNext() && (match = this.types.isAssignable((parameter = methodParameterIterator.next()).asType(), variableElement.asType()))) {
                        matchedParams.add(parameter);
                    }
                    if (match) continue;
                    break;
                }
                if (match) {
                    this.constructionParameters.clear();
                    this.useConstructionParameters = true;
                    this.constructionParameters.addAll(matchedParams);
                    this.causeSet = causeFound;
                }
            }
        }

        @Override
        public boolean useConstructionParameters() {
            return this.useConstructionParameters;
        }

        @Override
        public Set<Parameter> constructionParameters() {
            return this.constructionParameters;
        }

        @Override
        public boolean causeSetInConstructor() {
            return this.causeSet;
        }

        @Override
        public Collection<ThrowableType> suggestions() {
            return this.suggestions;
        }
    }

    private static class AptThrowableType
    extends AbstractClassType
    implements ThrowableType {
        protected final TypeMirror stringType;
        protected final TypeMirror causeType;
        private final TypeMirror type;
        private final boolean isChecked;
        private final Element delegate;
        private boolean defaultConstructor = false;
        private boolean stringConstructor = false;
        private boolean throwableConstructor = false;
        private boolean stringAndThrowableConstructor = false;
        private boolean throwableAndStringConstructor = false;

        private AptThrowableType(ProcessingEnvironment processingEnv, TypeMirror type, TypeMirror causeType) {
            super(processingEnv, type);
            this.type = type;
            this.delegate = this.types.asElement(type);
            this.stringType = ElementHelper.toType(this.elements, String.class);
            this.causeType = causeType == null ? ElementHelper.toType(this.elements, Throwable.class) : causeType;
            TypeMirror runtimeException = ElementHelper.toType(this.elements, RuntimeException.class);
            TypeMirror error = ElementHelper.toType(this.elements, Error.class);
            this.isChecked = !this.types.isAssignable(runtimeException, type) || !this.types.isAssignable(error, type);
        }

        protected void init() {
            if (!this.type.getKind().isPrimitive() && this.type.getKind() != TypeKind.VOID) {
                Element element = this.types.asElement(this.type);
                List<ExecutableElement> constructors = ElementFilter.constructorsIn(element.getEnclosedElements());
                for (ExecutableElement constructor : constructors) {
                    if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                    List<? extends VariableElement> params = constructor.getParameters();
                    switch (params.size()) {
                        case 0: {
                            this.defaultConstructor = true;
                            break;
                        }
                        case 1: {
                            if (this.types.isAssignable(this.stringType, params.get(0).asType())) {
                                this.stringConstructor = true;
                                break;
                            }
                            if (!this.types.isAssignable(this.causeType, params.get(0).asType())) break;
                            this.throwableConstructor = true;
                            break;
                        }
                        case 2: {
                            if (this.types.isAssignable(this.stringType, params.get(0).asType()) && this.types.isAssignable(this.causeType, params.get(1).asType())) {
                                this.stringAndThrowableConstructor = true;
                                break;
                            }
                            if (!this.types.isAssignable(this.causeType, params.get(0).asType()) || !this.types.isAssignable(this.stringType, params.get(1).asType())) break;
                            this.throwableAndStringConstructor = true;
                        }
                    }
                    this.init(params);
                }
            }
        }

        protected void init(List<? extends VariableElement> params) {
        }

        @Override
        public Element getDelegate() {
            return this.delegate;
        }

        @Override
        public TypeMirror asType() {
            return this.type;
        }

        @Override
        public boolean hasDefaultConstructor() {
            return this.defaultConstructor;
        }

        @Override
        public boolean hasStringAndThrowableConstructor() {
            return this.stringAndThrowableConstructor;
        }

        @Override
        public boolean hasStringConstructor() {
            return this.stringConstructor;
        }

        @Override
        public boolean hasThrowableAndStringConstructor() {
            return this.throwableAndStringConstructor;
        }

        @Override
        public boolean hasThrowableConstructor() {
            return this.throwableConstructor;
        }

        @Override
        public boolean useConstructionParameters() {
            return false;
        }

        @Override
        public Set<Parameter> constructionParameters() {
            return Collections.emptySet();
        }

        @Override
        public boolean isChecked() {
            return this.isChecked;
        }

        @Override
        public String name() {
            return this.type.toString();
        }

        @Override
        public int hashCode() {
            return Objects.HashCodeBuilder.builder().add(this.type).toHashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AptThrowableType)) {
                return false;
            }
            AptThrowableType other = (AptThrowableType)obj;
            return Objects.areEqual(this.type, other.type);
        }

        public String toString() {
            return Objects.ToStringBuilder.of(this).add("type", this.type).add("stringConstructor", this.stringConstructor).add("throwableConstructor", this.throwableConstructor).add("stringAndThrowableConstructor", this.stringAndThrowableConstructor).add("throwableAndStringConstructor", this.throwableAndStringConstructor).toString();
        }

        @Override
        public int compareTo(ThrowableType o) {
            return this.name().compareTo(o.name());
        }
    }
}

