/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

class RadixTreeNode {
    private static final System.Logger LOG = System.getLogger(RadixTreeNode.class.getName());
    private static final LocalStringsImpl _strings = new LocalStringsImpl(RadixTreeNode.class);
    private String _key;
    private String _value;
    private Map<Character, RadixTreeNode> _childNodes;
    private RadixTreeNode _parentNode;

    RadixTreeNode(String key, String value) {
        this._key = key;
        this._value = value;
    }

    String getKey() {
        return this._key;
    }

    void setKey(String key) {
        this._key = key;
    }

    String getValue() {
        return this._value;
    }

    void setValue(String value) {
        this._value = value;
    }

    RadixTreeNode getParentNode() {
        return this._parentNode;
    }

    Collection<RadixTreeNode> getChildNodes() {
        return this._childNodes == null ? Collections.emptyList() : this._childNodes.values();
    }

    void addChildNode(RadixTreeNode node) {
        RadixTreeNode oldNode;
        if (node == null || node._key == null || node._key.isEmpty()) {
            throw new IllegalArgumentException(_strings.get("errorInEmptyNullKeyInstertion"));
        }
        char c = node._key.charAt(0);
        if (this._childNodes == null) {
            this._childNodes = new HashMap<Character, RadixTreeNode>();
        }
        if ((oldNode = this._childNodes.put(Character.valueOf(c), node)) != null) {
            LOG.log(System.Logger.Level.WARNING, "Parent node: {0} contains child node: {1} whose key starts with same character as the key of given node: {2}", this, oldNode, node);
            oldNode._parentNode = null;
        }
        node._parentNode = this;
    }

    void removeChildNode(RadixTreeNode node) {
        if (node == null || node._key == null || node._key.isEmpty()) {
            throw new IllegalArgumentException(_strings.get("invalidNodeKey"));
        }
        char c = node._key.charAt(0);
        if (this._childNodes != null) {
            RadixTreeNode matchedNode = this._childNodes.get(Character.valueOf(c));
            if (matchedNode == node) {
                node = this._childNodes.remove(Character.valueOf(c));
                node._parentNode = null;
            } else {
                throw new IllegalArgumentException(_strings.get("invalidChildNode", new Object[]{node, this}));
            }
        }
    }

    RadixTreeNode getChildNode(char c) {
        return this._childNodes == null ? null : this._childNodes.get(Character.valueOf(c));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Node Key : " + this._key + ", Value : " + this._value);
        return buffer.toString();
    }
}

