/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MessageEnumeration
implements Enumeration {
    ResultSet rs = null;
    PreparedStatement pstmt = null;
    Connection conn = null;
    String sql = null;
    MessageDAOImpl dao = null;
    Packet nextPacket = null;
    Store store = null;
    boolean closed = false;

    MessageEnumeration(ResultSet rs, PreparedStatement pstmt, Connection conn, String sql, MessageDAOImpl dao, Store store) {
        this.rs = rs;
        this.pstmt = pstmt;
        this.conn = conn;
        this.sql = sql;
        this.dao = dao;
        this.store = store;
    }

    @Override
    public boolean hasMoreElements() {
        block10: {
            try {
                this.nextPacket = (Packet)this.dao.loadData(this.rs, true);
                if (this.nextPacket == null && this.setClosed()) {
                    try {
                        Util.close(this.rs, this.pstmt, this.conn, null);
                    }
                    catch (Throwable t) {
                        this.dao.logger.log(16, this.dao.br.getKString("B2233", t.toString()));
                    }
                }
            }
            catch (Throwable e) {
                Throwable myex = e;
                this.nextPacket = null;
                if (e instanceof IOException) {
                    myex = DBManager.wrapIOException("[" + this.sql + "]", (IOException)e);
                } else if (e instanceof SQLException) {
                    myex = DBManager.wrapSQLException("[" + this.sql + "]", (SQLException)e);
                }
                this.dao.logger.logStack(32, myex.getMessage(), e);
                if (!this.setClosed()) break block10;
                try {
                    Util.close(this.rs, this.pstmt, this.conn, myex);
                }
                catch (Exception ee) {
                    this.dao.logger.log(16, this.dao.br.getKString("B2233", ee.toString()));
                }
            }
        }
        return this.nextPacket != null;
    }

    public Object nextElement() {
        if (this.nextPacket == null) {
            throw new NoSuchElementException();
        }
        if (this.store.isClosed()) {
            throw new NoSuchElementException(this.dao.br.getKString("B1341"));
        }
        return this.nextPacket;
    }

    public void cancel() {
        if (!this.closed) {
            try {
                this.pstmt.cancel();
            }
            catch (Throwable t) {
                this.dao.logger.log(16, this.dao.br.getKString("B2234", "[" + this.sql + "]", t.toString()));
            }
        }
    }

    private synchronized boolean setClosed() {
        if (!this.closed) {
            this.closed = true;
            return true;
        }
        return false;
    }

    public void close() {
        if (this.setClosed()) {
            try {
                Util.close(this.rs, this.pstmt, this.conn, null);
            }
            catch (Exception e) {
                this.dao.logger.log(16, this.dao.br.getKString("B2233", e.toString()));
            }
        }
    }
}

