/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.collections.AST;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLAST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.glassfish.persistence.common.I18NHelper;

public class VariableTable {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(VariableTable.class);
    private ErrorMsg errorMsg;
    private List declaredVars;
    private Map varInfos;

    public VariableTable(ErrorMsg errorMsg) {
        this.errorMsg = errorMsg;
        this.declaredVars = new ArrayList();
        this.varInfos = new HashMap();
    }

    public VariableTable(VariableTable other) {
        this.errorMsg = other.errorMsg;
        this.declaredVars = other.declaredVars;
        this.varInfos = new HashMap();
        for (Map.Entry entry : other.varInfos.entrySet()) {
            this.varInfos.put(entry.getKey(), new VarInfo((VarInfo)entry.getValue()));
        }
    }

    public void add(String name) {
        this.declaredVars.add(name);
        this.varInfos.put(name, new VarInfo());
    }

    public void markUsed(JQLAST variable, String dependendVar) {
        String name = variable.getText();
        VarInfo entry = (VarInfo)this.varInfos.get(name);
        if (entry == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.variabletable.markused.varnotfound", (Object[])new Object[]{name}));
        }
        entry.used.add(variable);
        if (dependendVar != null) {
            VarInfo dependendVarInfo = (VarInfo)this.varInfos.get(dependendVar);
            if (dependendVarInfo.dependsOn != null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.variabletable.markused.multidep", (Object[])new Object[]{dependendVar, dependendVarInfo.dependsOn, name}));
            }
            dependendVarInfo.dependsOn = name;
        }
    }

    public void markConstraint(JQLAST variable, JQLAST expr) {
        String old;
        String name = variable.getText();
        VarInfo entry = (VarInfo)this.varInfos.get(name);
        if (entry == null) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.variabletable.markconstraint.varnotfound", (Object[])new Object[]{name}));
        }
        String string = old = entry.constraint == null ? null : entry.constraint.getText();
        if (old != null && !old.equals(expr.getText())) {
            this.errorMsg.unsupported(variable.getLine(), variable.getColumn(), I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.variabletable.markconstraint.multiple", (Object[])new Object[]{name}));
        }
        entry.constraint = expr;
    }

    public void merge(VariableTable other) {
        for (String name : this.declaredVars) {
            VarInfo info = (VarInfo)this.varInfos.get(name);
            VarInfo otherInfo = (VarInfo)other.varInfos.get(name);
            if (info.constraint == null && info.used.size() == 0) {
                info.constraint = otherInfo.constraint;
                info.used = otherInfo.used;
                info.dependsOn = otherInfo.dependsOn;
                info.status = otherInfo.status;
                continue;
            }
            if (otherInfo.constraint == null && otherInfo.used.size() == 0) continue;
            if (info.constraint != null && otherInfo.constraint != null) {
                if (!otherInfo.constraint.getText().equals(info.constraint.getText())) {
                    throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.variabletable.merge.different", (Object[])new Object[]{name}));
                }
            } else {
                info.constraint = null;
                info.dependsOn = null;
                info.status = 0;
            }
            info.used.addAll(otherInfo.used);
        }
    }

    public void checkConstraints() {
        for (String name : this.declaredVars) {
            VarInfo info = (VarInfo)this.varInfos.get(name);
            this.checkConstraint(name, info);
        }
    }

    protected void checkConstraint(String variable, VarInfo info) {
        switch (info.status) {
            case 0: {
                info.status = 1;
                break;
            }
            case 1: {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.variabletable.checkconstraint.cycle", (Object[])new Object[]{variable}));
            }
            case 2: {
                return;
            }
        }
        if (info.dependsOn != null) {
            VarInfo dependendVarInfo = (VarInfo)this.varInfos.get(info.dependsOn);
            this.checkConstraint(info.dependsOn, dependendVarInfo);
        }
        if (info.constraint != null && info.used.size() == 0) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"jqlc.variabletable.checkconstraint.unused", (Object[])new Object[]{variable}));
        }
        this.attachConstraintToUsedAST(info);
        info.status = 2;
    }

    protected void attachConstraintToUsedAST(VarInfo info) {
        for (JQLAST varNode : info.used) {
            if (varNode.getFirstChild() != null) continue;
            varNode.setFirstChild(JQLAST.Factory.getInstance().dupTree((AST)info.constraint));
        }
    }

    static class VarInfo {
        JQLAST constraint;
        Set used;
        String dependsOn;
        int status;
        static final int UNCHECKED = 0;
        static final int IN_PROGRESS = 1;
        static final int CHECKED = 2;

        VarInfo() {
            this.constraint = null;
            this.used = new HashSet();
            this.dependsOn = null;
            this.status = 0;
        }

        VarInfo(VarInfo other) {
            this.constraint = other.constraint;
            this.used = new HashSet(other.used);
            this.dependsOn = other.dependsOn;
            this.status = other.status;
        }
    }
}

