/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.main.jul.GlassFishLogManager;
import org.glassfish.main.jul.handler.LogRecordBuffer;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

final class LoggingOutputStream
extends ByteArrayOutputStream {
    private final String lineSeparator;
    private final Level logRecordLevel;
    private final LogRecordBuffer logRecordBuffer;
    private final String loggerName;
    private final Pump pump;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Charset charset;

    LoggingOutputStream(Logger logger, Level logRecordLevel, int bufferCapacity, Charset charset) {
        this.lineSeparator = System.lineSeparator();
        this.loggerName = logger.getName();
        this.logRecordLevel = logRecordLevel;
        this.charset = charset;
        this.logRecordBuffer = new LogRecordBuffer(bufferCapacity);
        this.pump = new Pump(logger, this.logRecordBuffer);
    }

    void addRecord(Throwable throwable) {
        if (this.closed.get()) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(this.logRecordLevel, "", this.isSourceDetectionEnabled());
        record.setThrown(throwable);
        record.setLoggerName(this.loggerName);
        this.logRecordBuffer.add(record);
    }

    @Override
    public void flush() throws IOException {
        if (this.closed.get()) {
            return;
        }
        String message = this.getMessage();
        if (message.isEmpty() || this.lineSeparator.equals(message)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(this.logRecordLevel, message, this.isSourceDetectionEnabled());
        record.setLoggerName(this.loggerName);
        this.logRecordBuffer.add(record);
    }

    private synchronized String getMessage() throws IOException {
        super.flush();
        String logMessage = super.toString(this.charset).trim();
        super.reset();
        return logMessage;
    }

    private boolean isSourceDetectionEnabled() {
        GlassFishLogManager manager = GlassFishLogManager.getLogManager();
        return manager == null ? false : manager.getConfiguration().isClassAndMethodDetectionEnabled();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.closed.set(true);
        this.pump.shutdown();
        super.close();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " redirecting messages to the logger " + this.loggerName;
    }

    private static final class Pump
    extends Thread {
        private final LogRecordBuffer buffer;
        private final Logger logger;
        private volatile boolean pumpClosed;

        private Pump(Logger logger, LogRecordBuffer buffer) {
            this.buffer = buffer;
            this.logger = logger;
            this.setName("Logging pump for '" + logger.getName() + "'");
            this.setDaemon(true);
            this.setPriority(10);
            this.start();
        }

        @Override
        public void run() {
            while (!this.pumpClosed) {
                try {
                    this.logAllPendingRecordsOrWait();
                }
                catch (Exception e) {
                    GlassFishLoggingTracer.error(this.getClass(), "Pump failed to log records!", e);
                }
            }
        }

        void shutdown() {
            this.pumpClosed = true;
            while (this.getState() == Thread.State.RUNNABLE) {
                Thread.onSpinWait();
            }
            if (this.getState() == Thread.State.WAITING || this.getState() == Thread.State.BLOCKED || this.getState() == Thread.State.TIMED_WAITING) {
                this.interrupt();
            }
            try {
                this.join();
            }
            catch (InterruptedException e) {
                GlassFishLoggingTracer.error(this.getClass(), "Pump interrupted while waiting for shutdown.", e);
            }
            this.logAllPendingRecords();
        }

        private void logAllPendingRecordsOrWait() {
            if (!this.logRecord(this.buffer.pollOrWait())) {
                return;
            }
            this.logAllPendingRecords();
        }

        private void logAllPendingRecords() {
            GlassFishLogRecord record;
            while (this.logRecord(record = this.buffer.poll())) {
            }
        }

        private boolean logRecord(LogRecord record) {
            if (record == null) {
                return false;
            }
            this.logger.log(record);
            return true;
        }
    }
}

