/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import jakarta.inject.Inject;
import javax.naming.NamingException;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.glassfish.weld.WeldDeployer;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@NamespacePrefixes(value={"java:comp/BeanManager"})
public class BeanManagerNamingProxy
implements NamedNamingObjectProxy {
    private static final System.Logger LOG = System.getLogger(BeanManagerNamingProxy.class.getName());
    static final String BEAN_MANAGER_CONTEXT = "java:comp/BeanManager";
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private WeldDeployer weldDeployer;

    public Object handle(String name) throws NamingException {
        LOG.log(System.Logger.Level.TRACE, "handle(name={0})", name);
        if (!BEAN_MANAGER_CONTEXT.equals(name)) {
            throw new BeanManagerException("this proxy doesn't handle " + name + ", but just java:comp/BeanManager");
        }
        try {
            ComponentInvocation componentInvocation = this.invocationManager.getCurrentInvocation();
            if (componentInvocation == null) {
                throw new BeanManagerException("current invocation context is null!");
            }
            String componentId = componentInvocation.getComponentId();
            JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(componentId);
            if (componentEnv == null) {
                throw new BeanManagerException("no descriptor found for componentId=" + componentId);
            }
            BundleDescriptor descriptor = this.getBundleDescriptor(componentEnv);
            BeanManagerImpl beanManager = this.getBeanManager(descriptor);
            if (beanManager == null) {
                throw new BeanManagerException("no bean manager found for descriptor.class=" + String.valueOf(descriptor.getClass()));
            }
            return beanManager;
        }
        catch (BeanManagerException e) {
            LOG.log(System.Logger.Level.DEBUG, e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable t) {
            throw new BeanManagerException(t);
        }
    }

    private BundleDescriptor getBundleDescriptor(JndiNameEnvironment descriptor) throws BeanManagerException {
        LOG.log(System.Logger.Level.TRACE, "getBundleDescriptor(descriptor.class={0})", descriptor.getClass());
        if (descriptor instanceof EjbDescriptor) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)descriptor;
            return (BundleDescriptor)ejbDescriptor.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        }
        if (descriptor instanceof WebBundleDescriptor) {
            return (BundleDescriptor)descriptor;
        }
        throw new BeanManagerException("no descriptor found for descriptor.class=" + String.valueOf(descriptor.getClass()));
    }

    private BeanManagerImpl getBeanManager(BundleDescriptor descriptor) throws BeanManagerException {
        LOG.log(System.Logger.Level.TRACE, "getBeanManager(descriptor.class={0})", descriptor.getClass());
        BeanDeploymentArchive beanDeploymentArchive = this.weldDeployer.getBeanDeploymentArchiveForBundle(descriptor);
        if (beanDeploymentArchive == null) {
            throw new BeanManagerException("no CDI bean deployment archive found for descriptor.name=" + descriptor.getName());
        }
        Application application = descriptor.getApplication();
        if (application == null) {
            throw new BeanManagerException("descriptor with name " + descriptor.getName() + " doesn't contain any application.");
        }
        WeldBootstrap weldBootstrap = this.weldDeployer.getBootstrapForApp(application);
        if (weldBootstrap == null) {
            throw new BeanManagerException("no WeldBootstrap found for application.name=" + application.getName());
        }
        return weldBootstrap.getManager(beanDeploymentArchive);
    }

    private static class BeanManagerException
    extends NamingException {
        private static final long serialVersionUID = 6867680921109852571L;

        BeanManagerException(String reason) {
            super("Cannot handle the java:comp/BeanManager, because " + reason);
        }

        BeanManagerException(Throwable cause) {
            super("Cannot handle the java:comp/BeanManager.");
            this.initCause(cause);
        }
    }
}

