/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.disk.PHashMap;
import com.sun.messaging.jmq.io.disk.PHashMapLoadException;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class PropertiesFile {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    BrokerConfig config = Globals.getConfig();
    static final String PROP_FILE_SIZE_PROP = "imq.persist.file.property.file.size";
    static final long DEFAULT_PROP_FILE_SIZE = 1024L;
    static final String BASENAME = "property";
    private PHashMap propMap = null;
    private File backingFile = null;
    private LoadException loadException = null;

    PropertiesFile(FileStore p, File topDir, boolean clear) throws BrokerException {
        SizeString filesize = this.config.getSizeProperty(PROP_FILE_SIZE_PROP, 1024L);
        this.backingFile = new File(topDir, BASENAME);
        try {
            this.propMap = new PHashMap(this.backingFile, filesize.getBytes(), false, clear, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.logStack(32, "B4113", e);
            throw new BrokerException(this.br.getString("B4113"), e);
        }
        try {
            this.propMap.load(p);
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.logStack(32, "B4113", e);
            throw new BrokerException(this.br.getString("B4113"), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4196", le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = this.propMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of persisted properties", w);
        }
        if (clear && Store.getDEBUG()) {
            this.logger.log(1, "PropertiesFile initialized with clear option");
        }
        if (Store.getDEBUG()) {
            this.logger.log(4, "PropertiesFile: loaded " + this.propMap.size() + " properties");
        }
    }

    LoadException getLoadException() {
        return this.loadException;
    }

    PropertiesFile(FileStore p, File topDir, File oldTop) throws BrokerException {
        File oldFile = new File(oldTop, BASENAME);
        PHashMap olddata = null;
        this.backingFile = new File(topDir, BASENAME);
        try {
            olddata = new PHashMap(oldFile, false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4154", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4154", oldFile, this.backingFile), e);
        }
        try {
            olddata.load(p);
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(32, "B4154", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4154", oldFile, this.backingFile), e);
        }
        catch (PHashMapLoadException le) {
            while (le != null) {
                this.logger.log(16, "B4201", le);
                LoadException e = new LoadException(le.getMessage(), le.getCause());
                e.setKey(le.getKey());
                e.setValue(le.getValue());
                e.setKeyCause(le.getKeyCause());
                e.setValueCause(le.getValueCause());
                e.setNextException(this.loadException);
                this.loadException = e;
                le = le.getNextException();
            }
        }
        VRFileWarning w = olddata.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of persisted properties in old store", w);
        }
        try {
            this.propMap = new PHashMap(this.backingFile, oldFile.length(), false, false, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
        }
        catch (IOException e) {
            this.logger.log(32, "B4158", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4158", oldFile, this.backingFile), e);
        }
        try {
            this.propMap.load(p);
        }
        catch (PHashMapLoadException | IOException | ClassNotFoundException e) {
            this.logger.log(32, "B4154", oldFile, this.backingFile, e);
            throw new BrokerException(this.br.getString("B4154", oldFile, this.backingFile), e);
        }
        w = this.propMap.getWarning();
        if (w != null) {
            this.logger.log(16, "possible loss of persisted properties", w);
        }
        for (Map.Entry entry : olddata.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.propMap.put(key, value);
        }
        olddata.close();
        if (p.upgradeNoBackup() && !oldFile.delete()) {
            this.logger.log(32, "B1044", oldFile);
        }
    }

    void updateProperty(String name, Object value, boolean sync) throws BrokerException {
        try {
            boolean updated = false;
            if (value == null) {
                Object old = this.propMap.remove(name);
                updated = old != null;
            } else {
                this.propMap.put(name, value);
                updated = true;
            }
            if (updated && sync) {
                this.sync();
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4112", name);
            throw new BrokerException(this.br.getString("B4112", name), e);
        }
    }

    Object getProperty(String name) throws BrokerException {
        return this.propMap.get(name);
    }

    String[] getPropertyNames() throws BrokerException {
        ConcurrentHashMap.KeySetView keys = this.propMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    Properties getProperties() throws BrokerException {
        Properties props = new Properties();
        for (Map.Entry e : this.propMap.entrySet()) {
            props.put(e.getKey(), e.getValue());
        }
        return props;
    }

    void clearAll(boolean sync) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "PropertiesFile.clearAll() called");
        }
        this.propMap.clear();
        if (sync) {
            try {
                this.sync();
            }
            catch (BrokerException e) {
                this.logger.log(32, "Got exception while synchronizing data to disk", e);
            }
        }
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "PropertiesFile: closing, " + this.propMap.size() + " properties");
        }
        this.propMap.close();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Properties", String.valueOf(this.propMap.size()));
        return t;
    }

    void printInfo(PrintStream out) {
        out.println("\nProperties");
        out.println("----------");
        out.println("backing file: " + String.valueOf(this.backingFile));
        Set entries = this.propMap.entrySet();
        for (Map.Entry entry : entries) {
            out.println((String)entry.getKey() + "=" + String.valueOf(entry.getValue()));
        }
    }

    private void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String msg = "PropertiesFile sync()";
                this.logger.log(4, msg);
            }
            this.propMap.force();
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize file: " + String.valueOf(this.backingFile), e);
        }
    }
}

