/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnectionRequest;

class NetPackageRequest
extends NetConnectionRequest {
    private static final String COLLECTIONNAME = "NULLID";

    NetPackageRequest(NetAgent netAgent, int n) {
        super(netAgent, n);
    }

    private void buildCommonPKGNAMinfo(Section section) throws SqlException {
        String string = COLLECTIONNAME;
        int n = 255;
        CcsidManager ccsidManager = this.netAgent_.getCurrentCcsidManager();
        byte[] byArray = ccsidManager.convertFromJavaString(this.netAgent_.netConnection_.databaseName_, this.netAgent_);
        byte[] byArray2 = ccsidManager.convertFromJavaString(string, this.netAgent_);
        byte[] byArray3 = ccsidManager.convertFromJavaString(section.getPackageName(), this.netAgent_);
        boolean bl = this.checkPKGNAMlengths(this.netAgent_.netConnection_.databaseName_, byArray.length, this.netAgent_.netConnection_.databaseMetaData_.serverSupportLongRDBNAM() ? 1024 : 255, 18);
        if (!bl) {
            bl = this.checkPKGNAMlengths(string, byArray2.length, n, 18);
        }
        if (!bl) {
            bl = this.checkPKGNAMlengths(section.getPackageName(), byArray3.length, n, 18);
        }
        if (!bl) {
            byte by = ccsidManager.space_;
            this.writeScalarPaddedBytes(byArray, 18, by);
            this.writeScalarPaddedBytes(byArray2, 18, by);
            this.writeScalarPaddedBytes(byArray3, 18, by);
        } else {
            this.buildSCLDTA(byArray, 18);
            this.buildSCLDTA(byArray2, 18);
            this.buildSCLDTA(byArray3, 18);
        }
    }

    private void buildSCLDTA(byte[] byArray, int n) throws SqlException {
        int n2 = Math.max(n, byArray.length);
        this.write2Bytes(n2);
        byte by = this.netAgent_.getCurrentCcsidManager().space_;
        this.writeScalarPaddedBytes(byArray, n2, by);
    }

    void buildPKGNAMCSN(Section section) throws SqlException {
        if (!this.canCommandUseDefaultPKGNAMCSN()) {
            this.markLengthBytes(8467);
            if (section.getPKGNAMCBytes() != null) {
                this.writeStoredPKGNAMCBytes(section);
            } else {
                this.markForCachingPKGNAMCSN();
                this.buildCommonPKGNAMinfo(section);
                this.writeScalarPaddedBytes(Configuration.getDncPackageConsistencyToken(), 8, (byte)0);
                this.storePKGNAMCBytes(section);
            }
            this.write2Bytes(section.getSectionNumber());
            this.updateLengthBytes();
        } else {
            this.writeScalar2Bytes(8460, section.getSectionNumber());
        }
    }

    private void storePKGNAMCBytes(Section section) {
        int n = this.popMarkForCachingPKGNAMCSN();
        byte[] byArray = new byte[this.buffer.position() - n];
        this.buffer.position(n);
        this.buffer.get(byArray);
        section.setPKGNAMCBytes(byArray);
    }

    private void writeStoredPKGNAMCBytes(Section section) {
        this.writeBytes(section.getPKGNAMCBytes());
    }

    private boolean canCommandUseDefaultPKGNAMCSN() {
        return false;
    }

    private boolean checkPKGNAMlengths(String string, int n, int n2, int n3) throws SqlException {
        if (n > n2) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("42622"), string, n2);
        }
        return n > n3;
    }

    private void buildNOCMorNOCS(String string) throws SqlException {
        if (string == null) {
            this.write2Bytes(65535);
        } else if (this.netAgent_.typdef_.isCcsidMbcSet()) {
            byte[] byArray = string.getBytes(this.netAgent_.typdef_.getCcsidMbcEncoding());
            this.write1Byte(0);
            this.write4Bytes(byArray.length);
            this.writeBytes(byArray, byArray.length);
            this.write1Byte(255);
        } else {
            byte[] byArray = string.getBytes(this.netAgent_.typdef_.getCcsidSbcEncoding());
            this.write1Byte(255);
            this.write1Byte(0);
            this.write4Bytes(byArray.length);
            this.writeBytes(byArray, byArray.length);
        }
    }

    private void buildSQLSTTGRP(String string) throws SqlException {
        this.buildNOCMorNOCS(string);
    }

    private void buildSQLSTT(String string) throws SqlException {
        this.buildSQLSTTGRP(string);
    }

    protected void buildSQLSTTcommandData(String string) throws SqlException {
        this.createEncryptedCommandData();
        int n = this.buffer.position();
        this.markLengthBytes(9236);
        this.buildSQLSTT(string);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(n);
        }
    }

    protected void buildSQLATTRcommandData(String string) throws SqlException {
        this.createEncryptedCommandData();
        int n = this.buffer.position();
        this.markLengthBytes(9296);
        this.buildSQLSTT(string);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(n);
        }
    }

    void encryptDataStream(int n) throws SqlException {
        byte[] byArray = new byte[this.buffer.position() - n];
        this.buffer.position(n);
        this.buffer.get(byArray);
        byte[] byArray2 = this.netAgent_.netConnection_.getEncryptionManager().encryptData(byArray, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
        this.buffer.position(n);
        this.writeBytes(byArray2);
        this.buffer.putShort(n - 6, (short)byArray2.length);
    }
}

