/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.mgmt.transport.buffers;

import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.shoal.gms.mgmt.transport.buffers.Buffer;

public abstract class ExpandableBufferWriter {
    private final OutputStream outputStream = new BufferOutputStream();

    public abstract Buffer getBuffer();

    public abstract Buffer toBuffer();

    public abstract int position();

    public abstract void position(int var1);

    protected abstract void ensureCapacity(int var1);

    public void reserve(int size) {
        this.ensureCapacity(size);
        this.position(this.position() + size);
    }

    public ExpandableBufferWriter put(byte b) {
        this.ensureCapacity(1);
        this.getBuffer().put(b);
        return this;
    }

    public ExpandableBufferWriter put(int index, byte b) {
        this.ensureCapacity(index - this.position() + 1);
        this.getBuffer().put(index, b);
        return this;
    }

    public ExpandableBufferWriter put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public ExpandableBufferWriter put(byte[] src, int offset, int length) {
        this.ensureCapacity(length);
        this.getBuffer().put(src, offset, length);
        return this;
    }

    public ExpandableBufferWriter putChar(char value) {
        this.ensureCapacity(2);
        this.getBuffer().putChar(value);
        return this;
    }

    public ExpandableBufferWriter putChar(int index, char value) {
        this.ensureCapacity(index - this.position() + 2);
        this.getBuffer().putChar(index, value);
        return this;
    }

    public ExpandableBufferWriter putShort(short value) {
        this.ensureCapacity(2);
        this.getBuffer().putShort(value);
        return this;
    }

    public ExpandableBufferWriter putShort(int index, short value) {
        this.ensureCapacity(index - this.position() + 2);
        this.getBuffer().putShort(index, value);
        return this;
    }

    public ExpandableBufferWriter putInt(int value) {
        this.ensureCapacity(4);
        this.getBuffer().putInt(value);
        return this;
    }

    public ExpandableBufferWriter putInt(int index, int value) {
        this.ensureCapacity(this.position() - index + 4);
        this.getBuffer().putInt(index, value);
        return this;
    }

    public ExpandableBufferWriter putLong(long value) {
        this.ensureCapacity(8);
        this.getBuffer().putLong(value);
        return this;
    }

    public ExpandableBufferWriter putLong(int index, long value) {
        this.ensureCapacity(index - this.position() + 8);
        this.getBuffer().putLong(index, value);
        return this;
    }

    public ExpandableBufferWriter putFloat(float value) {
        this.ensureCapacity(4);
        this.getBuffer().putFloat(value);
        return this;
    }

    public ExpandableBufferWriter putFloat(int index, float value) {
        this.ensureCapacity(index - this.position() + 4);
        this.getBuffer().putFloat(index, value);
        return this;
    }

    public ExpandableBufferWriter putDouble(double value) {
        this.ensureCapacity(8);
        this.getBuffer().putDouble(value);
        return this;
    }

    public ExpandableBufferWriter putDouble(int index, double value) {
        this.ensureCapacity(index - this.position() + 8);
        this.getBuffer().putDouble(index, value);
        return this;
    }

    public OutputStream asOutputStream() {
        return this.outputStream;
    }

    private final class BufferOutputStream
    extends OutputStream {
        private BufferOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            ExpandableBufferWriter.this.put(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            ExpandableBufferWriter.this.put((byte)b);
        }
    }
}

