/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel;

import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelConnection;
import java.io.IOException;
import java.io.InputStream;

public class HttpTunnelInputStream
extends InputStream {
    private HttpTunnelConnection conn = null;
    private byte[] singlebyte = new byte[1];

    protected HttpTunnelInputStream(HttpTunnelConnection conn) {
        this.conn = conn;
    }

    @Override
    public synchronized int read() throws IOException {
        int n = this.conn.readData(this.singlebyte);
        if (n == 0) {
            return -1;
        }
        return this.singlebyte[0] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int n = this.conn.readData(b, off, len);
        if (n == 0) {
            return -1;
        }
        return n;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        int skipped = 0;
        while ((long)skipped < n) {
            int ret;
            try {
                ret = this.conn.readData(null, 0, (int)n - skipped);
            }
            catch (IOException e) {
                if (skipped != 0) break;
                throw e;
            }
            if (ret == 0) break;
            skipped += ret;
        }
        return skipped;
    }

    @Override
    public synchronized int available() throws IOException {
        return this.conn.available();
    }

    @Override
    public synchronized void close() throws IOException {
    }
}

