/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.policy;

import jakarta.ejb.Stateful;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionManagement;
import java.lang.reflect.Method;

public enum EjbTransactionType {
    NOT_SUPPORTED,
    NEVER,
    MANDATORY,
    SUPPORTS,
    REQUIRES_NEW,
    REQUIRED,
    NOT_DEFINED;


    public static EjbTransactionType getDefaultFor(Class<?> seiClass) {
        EjbTransactionType result = NOT_DEFINED;
        TransactionAttribute txnAttr = seiClass.getAnnotation(TransactionAttribute.class);
        if (txnAttr != null) {
            result = EjbTransactionType.valueOf(EjbTransactionType.class, txnAttr.value().name());
        }
        return result;
    }

    public EjbTransactionType getEffectiveType(Method method) {
        TransactionAttribute txnAttr = method.getAnnotation(TransactionAttribute.class);
        if (txnAttr != null) {
            return EjbTransactionType.valueOf(EjbTransactionType.class, txnAttr.value().name());
        }
        return this;
    }

    public static boolean isContainerManagedEJB(Class<?> c) {
        TransactionManagement tm = c.getAnnotation(TransactionManagement.class);
        if (tm != null) {
            switch (tm.value()) {
                case BEAN: {
                    return false;
                }
            }
            return true;
        }
        return c.getAnnotation(Stateful.class) != null || c.getAnnotation(Stateless.class) != null;
    }
}

