/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.tools.ws.resources.WsdlMessages;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class VersionChecker
extends XMLFilterImpl {
    private String version = null;
    private boolean seenRoot = false;
    private boolean seenBindings = false;
    private Locator locator;
    private Locator rootTagStart;
    private static final Set<String> VERSIONS = new HashSet<String>(List.of("3.0"));

    public VersionChecker(XMLReader parent) {
        this.setParent(parent);
    }

    public VersionChecker(ContentHandler handler, ErrorHandler eh, EntityResolver er) {
        this.setContentHandler(handler);
        if (eh != null) {
            this.setErrorHandler(eh);
        }
        if (er != null) {
            this.setEntityResolver(er);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qName, atts);
        if (!this.seenRoot) {
            this.seenRoot = true;
            this.rootTagStart = new LocatorImpl(this.locator);
            this.version = atts.getValue("https://jakarta.ee/xml/ns/jaxws", "version");
            if (namespaceURI.equals("https://jakarta.ee/xml/ns/jaxws")) {
                String version2 = atts.getValue("", "version");
                if (this.version != null && version2 != null) {
                    SAXParseException e = new SAXParseException(WsdlMessages.INTERNALIZER_TWO_VERSION_ATTRIBUTES(), this.locator);
                    this.getErrorHandler().error(e);
                }
                if (this.version == null) {
                    String string = this.version = version2 != null ? version2 : "3.0";
                }
            }
        }
        if ("https://jakarta.ee/xml/ns/jaxws".equals(namespaceURI)) {
            this.seenBindings = true;
            if (this.version == null) {
                this.version = "3.0";
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        SAXParseException e;
        super.endDocument();
        if (this.seenBindings && this.version == null) {
            e = new SAXParseException(WsdlMessages.INTERNALIZER_VERSION_NOT_PRESENT(), this.rootTagStart);
            this.getErrorHandler().error(e);
        }
        if (this.version != null && !VERSIONS.contains(this.version)) {
            e = new SAXParseException(WsdlMessages.INTERNALIZER_INCORRECT_VERSION(), this.rootTagStart);
            this.getErrorHandler().error(e);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }
}

