/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppClientContainerAgent {
    private static final Logger LOG = Logger.getLogger(AppClientContainerAgent.class.getName());

    public static void premain(String agentArgsText, Instrumentation instrumentation) {
        ClassLoader loader = ClassLoader.getSystemClassLoader().getParent();
        try {
            long now = System.currentTimeMillis();
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> containerInitClass = loader.loadClass("org.glassfish.appclient.client.AppClientContainerHolder");
            Method initContainer = containerInitClass.getMethod("init", String.class, Instrumentation.class);
            try {
                initContainer.invoke(null, AppClientContainerAgent.optionsValue(agentArgsText), instrumentation);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            LOG.fine("AppClientContainerAgent finished after " + (System.currentTimeMillis() - now) + " ms");
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String optionsValue(String agentArgsText) throws FileNotFoundException, IOException {
        if (agentArgsText == null) {
            throw new IllegalArgumentException();
        }
        if (!agentArgsText.startsWith("argsfile=")) {
            return agentArgsText;
        }
        Path argsFile = new File(agentArgsText.substring("argsfile=".length())).toPath();
        String result = Files.readString(argsFile).trim();
        if (Boolean.getBoolean("keep.argsfile")) {
            System.err.println("Agent arguments file retained: " + String.valueOf(argsFile));
        } else if (!Files.deleteIfExists(argsFile)) {
            LOG.log(Level.FINE, "Unable to delete temporary args file {0}; continuing", argsFile);
        }
        return result;
    }
}

