/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.messageinterpolation;

import jakarta.el.ExpressionFactory;
import jakarta.validation.MessageInterpolator;
import java.util.Locale;
import org.hibernate.validator.internal.engine.messageinterpolation.ElTermResolver;
import org.hibernate.validator.internal.engine.messageinterpolation.ParameterTermResolver;

public class TermInterpolator {
    private static final String EL_DESIGNATION_CHARACTER = "$";
    private final ElTermResolver elTermResolver;

    public TermInterpolator(ExpressionFactory expressionFactory) {
        this.elTermResolver = new ElTermResolver(expressionFactory);
    }

    public static boolean isElExpression(String expression) {
        return expression.startsWith(EL_DESIGNATION_CHARACTER);
    }

    public String interpolate(MessageInterpolator.Context context, String expression, Locale locale) {
        if (TermInterpolator.isElExpression(expression)) {
            return this.elTermResolver.interpolate(context, locale, expression);
        }
        return ParameterTermResolver.INSTANCE.interpolate(context, locale, expression);
    }
}

