/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.chars;

import com.sun.jndi.toolkit.chars.CharacterEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class HexDumpEncoder
extends CharacterEncoder {
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private byte[] thisLine = new byte[16];

    protected int bytesPerAtom() {
        return 1;
    }

    protected int bytesPerLine() {
        return 16;
    }

    protected void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        this.thisLine[this.currentByte] = byArray[n];
        HexDumpEncoder.hexDigit(this.pStream, byArray[n]);
        this.pStream.print(" ");
        ++this.currentByte;
        if (this.currentByte == 8) {
            this.pStream.print("  ");
        }
    }

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.offset = 0;
        super.encodeBufferPrefix(outputStream);
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(this.pStream, (byte)(this.offset & 0xFF));
        this.pStream.print(": ");
        this.currentByte = 0;
        this.thisLineLength = n;
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        int n;
        if (this.thisLineLength < 16) {
            n = this.thisLineLength;
            while (n < 16) {
                this.pStream.print("   ");
                if (n == 7) {
                    this.pStream.print("  ");
                }
                ++n;
            }
        }
        this.pStream.print(" ");
        n = 0;
        while (n < this.thisLineLength) {
            if (this.thisLine[n] < 32 || this.thisLine[n] > 122) {
                this.pStream.print(".");
            } else {
                this.pStream.write(this.thisLine[n]);
            }
            ++n;
        }
        this.pStream.println();
        this.offset += this.thisLineLength;
    }

    static void hexDigit(PrintStream printStream, byte by) {
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        printStream.write(c);
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 65) : (char)(c + 48);
        printStream.write(c);
    }
}

