/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.OptimizerPlan;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.DistinctNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.GroupByNode;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VerifyAggregateExpressionsVisitor;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowFunctionNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowResultSetNode;
import org.apache.derby.shared.common.error.StandardException;

class SelectNode
extends ResultSetNode {
    FromList fromList;
    FromTable targetTable;
    private List<AggregateNode> selectAggregates;
    private List<AggregateNode> whereAggregates;
    private List<AggregateNode> havingAggregates;
    ValueNode whereClause;
    ValueNode originalWhereClause;
    GroupByList groupByList;
    WindowList windows;
    OptimizerPlan overridingPlan;
    List<WindowFunctionNode> windowFuncCalls;
    private boolean wasGroupBy;
    boolean orderByQuery;
    ResultSetNode.QueryExpressionClauses qec = new ResultSetNode.QueryExpressionClauses();
    PredicateList wherePredicates;
    SubqueryList selectSubquerys;
    SubqueryList whereSubquerys;
    SubqueryList havingSubquerys;
    private boolean bindTargetListOnly;
    private boolean isDistinct;
    private boolean orderByAndDistinctMerged;
    boolean originalWhereClauseHadSubqueries;
    private FromList preJoinFL;
    ValueNode havingClause;
    private int nestingLevel;

    SelectNode(ResultColumnList resultColumnList, FromList fromList, ValueNode valueNode, GroupByList groupByList, ValueNode valueNode2, WindowList windowList, OptimizerPlan optimizerPlan, ContextManager contextManager) throws StandardException {
        super(contextManager);
        CollectNodesVisitor<ValueNode> collectNodesVisitor;
        this.setResultColumns(resultColumnList);
        if (this.getResultColumns() != null) {
            this.getResultColumns().markInitialSize();
        }
        this.fromList = fromList;
        this.whereClause = valueNode;
        this.originalWhereClause = valueNode;
        this.groupByList = groupByList;
        this.havingClause = valueNode2;
        this.windows = windowList;
        this.overridingPlan = optimizerPlan;
        this.bindTargetListOnly = false;
        this.originalWhereClauseHadSubqueries = false;
        if (this.whereClause != null) {
            collectNodesVisitor = new CollectNodesVisitor<SubqueryNode>(SubqueryNode.class, SubqueryNode.class);
            this.whereClause.accept(collectNodesVisitor);
            if (!collectNodesVisitor.getList().isEmpty()) {
                this.originalWhereClauseHadSubqueries = true;
            }
        }
        if (this.getResultColumns() != null) {
            collectNodesVisitor = new CollectNodesVisitor<WindowFunctionNode>(WindowFunctionNode.class, SelectNode.class);
            this.getResultColumns().accept(collectNodesVisitor);
            this.windowFuncCalls = collectNodesVisitor.getList();
            for (int i = 0; i < this.windowFuncCalls.size(); ++i) {
                WindowFunctionNode windowFunctionNode = this.windowFuncCalls.get(i);
                if (!(windowFunctionNode.getWindow() instanceof WindowDefinitionNode)) continue;
                this.windows = this.addInlinedWindowDefinition(this.windows, windowFunctionNode);
            }
        }
    }

    private WindowList addInlinedWindowDefinition(WindowList windowList, WindowFunctionNode windowFunctionNode) {
        WindowDefinitionNode windowDefinitionNode;
        WindowDefinitionNode windowDefinitionNode2 = (WindowDefinitionNode)windowFunctionNode.getWindow();
        if (windowList == null) {
            windowList = new WindowList(this.getContextManager());
        }
        if ((windowDefinitionNode = windowDefinitionNode2.findEquivalentWindow(windowList)) != null) {
            windowFunctionNode.setWindow(windowDefinitionNode);
        } else {
            windowList.addWindow((WindowDefinitionNode)windowFunctionNode.getWindow());
        }
        return windowList;
    }

    @Override
    public String toString() {
        return "";
    }

    String statementToString() {
        return "SELECT";
    }

    void makeDistinct() {
        this.isDistinct = true;
    }

    void clearDistinct() {
        this.isDistinct = false;
    }

    boolean hasDistinct() {
        return this.isDistinct;
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    FromList getFromList() {
        return this.fromList;
    }

    ColumnReference findColumnReferenceInResult(String string) throws StandardException {
        if (this.fromList.size() != 1) {
            return null;
        }
        FromTable fromTable = (FromTable)this.fromList.elementAt(0);
        if (!(fromTable instanceof ProjectRestrictNode && ((ProjectRestrictNode)fromTable).getChildResult() instanceof FromBaseTable || fromTable instanceof FromBaseTable)) {
            return null;
        }
        for (ResultColumn resultColumn : this.getResultColumns()) {
            if (!(resultColumn.getExpression() instanceof ColumnReference)) {
                return null;
            }
            ColumnReference columnReference = (ColumnReference)resultColumn.getExpression();
            if (!columnReference.getColumnName().equals(string)) continue;
            return (ColumnReference)columnReference.getClone();
        }
        return null;
    }

    ValueNode getWhereClause() {
        return this.whereClause;
    }

    PredicateList getWherePredicates() {
        return this.wherePredicates;
    }

    SubqueryList getSelectSubquerys() {
        return this.selectSubquerys;
    }

    SubqueryList getWhereSubquerys() {
        return this.whereSubquerys;
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        int n;
        int n2 = this.fromList.size();
        this.wherePredicates = new PredicateList(this.getContextManager());
        this.preJoinFL = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        this.nestingLevel = fromList.size() == 0 ? 0 : ((FromTable)fromList.elementAt(0)).getLevel() + 1;
        this.fromList.setLevel(this.nestingLevel);
        for (n = 0; n < n2; ++n) {
            fromList.insertElementAt((ResultSetNode)this.fromList.elementAt(n), 0);
        }
        this.fromList.bindTables(dataDictionary, fromList);
        for (n = 0; n < n2; ++n) {
            fromList.removeElementAt(0);
        }
        if (this.overridingPlan != null) {
            this.overridingPlan.bind(dataDictionary, this.getLanguageConnectionContext(), this.getCompilerContext());
        }
        return this;
    }

    @Override
    void bindExpressions(FromList fromList) throws StandardException {
        int n;
        boolean bl = this.getCompilerContext().skipTypePrivileges(true);
        int n2 = fromList.size();
        int n3 = this.fromList.size();
        for (n = 0; n < this.qec.size(); ++n) {
            OrderByList orderByList = this.qec.getOrderByList(n);
            if (orderByList == null) continue;
            orderByList.pullUpOrderByColumns(this);
        }
        if (!this.bindTargetListOnly) {
            this.fromList.bindExpressions(fromList);
        }
        this.selectSubquerys = new SubqueryList(this.getContextManager());
        this.selectAggregates = new ArrayList<AggregateNode>();
        for (n = 0; n < n3; ++n) {
            fromList.insertElementAt((ResultSetNode)this.fromList.elementAt(n), n);
        }
        fromList.setWindows(this.windows);
        this.getResultColumns().bindExpressions(fromList, this.selectSubquerys, this.selectAggregates);
        if (this.bindTargetListOnly) {
            for (n = 0; n < n3; ++n) {
                fromList.removeElementAt(0);
            }
            return;
        }
        this.whereAggregates = new ArrayList<AggregateNode>();
        this.whereSubquerys = new SubqueryList(this.getContextManager());
        CompilerContext compilerContext = this.getCompilerContext();
        if (this.whereClause != null) {
            compilerContext.beginScope("whereScope");
            compilerContext.pushCurrentPrivType(0);
            int n4 = this.orReliability(16384);
            this.whereClause = this.whereClause.bindExpression(fromList, this.whereSubquerys, this.whereAggregates);
            compilerContext.setReliability(n4);
            if (this.whereAggregates.size() > 0) {
                throw StandardException.newException("42903", new Object[0]);
            }
            if (this.whereClause.isParameterNode()) {
                throw StandardException.newException("42X19.S.2", new Object[0]);
            }
            this.whereClause = this.whereClause.checkIsBoolean();
            this.getCompilerContext().popCurrentPrivType();
            compilerContext.endScope("whereScope");
            SelectNode.checkNoWindowFunctions(this.whereClause, "WHERE");
        }
        if (this.havingClause != null) {
            int n5 = this.orReliability(16384);
            this.havingAggregates = new ArrayList<AggregateNode>();
            this.havingSubquerys = new SubqueryList(this.getContextManager());
            this.havingClause.bindExpression(fromList, this.havingSubquerys, this.havingAggregates);
            this.havingClause = this.havingClause.checkIsBoolean();
            SelectNode.checkNoWindowFunctions(this.havingClause, "HAVING");
            compilerContext.setReliability(n5);
        }
        for (int i = 0; i < n3; ++i) {
            fromList.removeElementAt(0);
        }
        if (this.groupByList != null) {
            ArrayList<AggregateNode> arrayList = new ArrayList<AggregateNode>(0);
            this.groupByList.bindGroupByColumns(this, arrayList);
            SelectNode.checkNoWindowFunctions(this.groupByList, "GROUP BY");
        }
        if (this.groupByList != null || this.selectAggregates.size() > 0) {
            VerifyAggregateExpressionsVisitor verifyAggregateExpressionsVisitor = new VerifyAggregateExpressionsVisitor(this.groupByList);
            this.getResultColumns().accept(verifyAggregateExpressionsVisitor);
        }
        int n6 = SelectNode.numDistinctAggregates(this.selectAggregates);
        if (this.groupByList == null && n6 > 1) {
            throw StandardException.newException("42Z02", new Object[0]);
        }
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if (orderByList != null) {
                orderByList.bindOrderByColumns(this);
            }
            SelectNode.bindOffsetFetch(this.qec.getOffset(i), this.qec.getFetchFirst(i));
        }
        this.getCompilerContext().skipTypePrivileges(bl);
    }

    @Override
    void bindExpressionsWithTables(FromList fromList) throws StandardException {
        this.bindExpressions(fromList);
    }

    @Override
    void bindTargetExpressions(FromList fromList) throws StandardException {
        CollectNodesVisitor<FromSubquery> collectNodesVisitor = new CollectNodesVisitor<FromSubquery>(FromSubquery.class, FromSubquery.class);
        this.fromList.accept(collectNodesVisitor);
        this.bindTargetListOnly = collectNodesVisitor.getList().isEmpty();
        this.bindExpressions(fromList);
        this.bindTargetListOnly = false;
    }

    @Override
    void bindResultColumns(FromList fromList) throws StandardException {
        this.fromList.bindResultColumns(fromList);
        super.bindResultColumns(fromList);
        if (this.getResultColumns().size() > 1012) {
            throw StandardException.newException("54004", new Object[0]);
        }
        if (this.getResultColumns().size() == 0) {
            throw StandardException.newException("42X81", new Object[0]);
        }
    }

    @Override
    void bindResultColumns(TableDescriptor tableDescriptor, FromVTI fromVTI, ResultColumnList resultColumnList, DMLStatementNode dMLStatementNode, FromList fromList) throws StandardException {
        this.fromList.bindResultColumns(fromList);
        super.bindResultColumns(tableDescriptor, fromVTI, resultColumnList, dMLStatementNode, fromList);
    }

    void pushExpressionsIntoSelect(Predicate predicate) throws StandardException {
        this.wherePredicates.pullExpressions(this.getReferencedTableMap().size(), predicate.getAndNode());
        this.fromList.pushPredicates(this.wherePredicates);
    }

    @Override
    void verifySelectStarSubquery(FromList fromList, int n) throws StandardException {
        for (ResultColumn resultColumn : this.getResultColumns()) {
            if (!(resultColumn instanceof AllResultColumn)) continue;
            if (n != 15) {
                throw StandardException.newException("42X38", new Object[0]);
            }
            String string = ((AllResultColumn)resultColumn).getFullTableName();
            if (string == null || this.fromList.getFromTableByName(string, null, true) != null || fromList.getFromTableByName(string, null, true) != null || this.fromList.getFromTableByName(string, null, false) != null || fromList.getFromTableByName(string, null, false) != null) continue;
            throw StandardException.newException("42X10", string);
        }
    }

    @Override
    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        return this.fromList.getFromTableByName(string, string2, bl);
    }

    @Override
    void rejectParameters() throws StandardException {
        super.rejectParameters();
        this.fromList.rejectParameters();
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.qec.push();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.qec.setOrderByList(orderByList);
        this.orderByQuery = true;
    }

    @Override
    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2, boolean bl) {
        this.qec.setOffset(valueNode);
        this.qec.setFetchFirst(valueNode2);
        this.qec.setHasJDBCLimitClause(bl);
    }

    @Override
    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        ResultSetNode resultSetNode = this;
        this.whereClause = this.normExpressions(this.whereClause);
        this.havingClause = this.normExpressions(this.havingClause);
        boolean bl = this.fromList.LOJ_reorderable(n);
        if (bl) {
            FromList fromList2 = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindExpressions(fromList2);
            this.fromList.bindResultColumns(fromList2);
        }
        this.fromList.preprocess(n, this.groupByList, this.whereClause);
        this.getResultColumns().preprocess(n, this.fromList, this.whereSubquerys, this.wherePredicates);
        if (this.whereClause != null) {
            if (this.whereSubquerys != null) {
                this.whereSubquerys.markWhereSubqueries();
            }
            this.whereClause = this.whereClause.preprocess(n, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.groupByList != null) {
            this.groupByList.preprocess(n, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.havingClause != null) {
            this.havingSubquerys.markHavingSubqueries();
            this.havingClause = this.havingClause.preprocess(n, this.fromList, this.havingSubquerys, this.wherePredicates);
        }
        if (this.whereClause != null) {
            this.wherePredicates.pullExpressions(n, this.whereClause);
            this.whereClause = null;
        }
        this.fromList.flattenFromTables(this.getResultColumns(), this.wherePredicates, this.whereSubquerys, this.groupByList, this.havingClause);
        if (this.wherePredicates != null && this.wherePredicates.size() > 0 && this.fromList.size() > 0) {
            if (this.fromList.size() > 1) {
                this.performTransitiveClosure(n);
            }
            for (int i = 0; i < this.qec.size(); ++i) {
                OrderByList orderByList = this.qec.getOrderByList(i);
                if (orderByList == null) continue;
                orderByList.removeConstantColumns(this.wherePredicates);
                if (orderByList.size() != 0) continue;
                this.qec.setOrderByList(i, null);
                this.getResultColumns().removeOrderByColumns();
            }
        }
        if (this.groupByList != null && this.havingClause == null && this.selectAggregates.isEmpty() && this.whereAggregates.isEmpty()) {
            this.isDistinct = true;
            this.groupByList = null;
            this.wasGroupBy = true;
        }
        if (this.isDistinct && this.groupByList == null) {
            int n2 = this.getResultColumns().allTopCRsFromSameTable();
            if (n2 != -1 && this.fromList.returnsAtMostSingleRow(this.getResultColumns(), this.whereClause, this.wherePredicates, this.getDataDictionary())) {
                this.isDistinct = false;
            }
            for (int i = 0; i < this.qec.size(); ++i) {
                OrderByList orderByList = this.qec.getOrderByList(i);
                if (!this.isDistinct || orderByList == null || !orderByList.allAscending()) continue;
                if (orderByList.isInOrderPrefix(this.getResultColumns())) {
                    this.qec.setOrderByList(i, null);
                } else {
                    resultSetNode = this.genProjectRestrictForReordering();
                    orderByList.resetToSourceRCs();
                    this.setResultColumns(orderByList.reorderRCL(this.getResultColumns()));
                    resultSetNode.getResultColumns().removeOrderByColumns();
                    this.qec.setOrderByList(i, null);
                }
                this.orderByAndDistinctMerged = true;
            }
        }
        this.fromList.pushPredicates(this.wherePredicates);
        this.setReferencedTableMap(new JBitSet(n));
        int n3 = this.fromList.size();
        for (int i = 0; i < n3; ++i) {
            this.getReferencedTableMap().or(((FromTable)this.fromList.elementAt(i)).getReferencedTableMap());
        }
        if (resultSetNode != this) {
            resultSetNode.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
        }
        if (this.qec.getOrderByList(0) != null) {
            CollectNodesVisitor<WindowFunctionNode> collectNodesVisitor = new CollectNodesVisitor<WindowFunctionNode>(WindowFunctionNode.class);
            this.qec.getOrderByList(0).accept(collectNodesVisitor);
            for (WindowFunctionNode windowFunctionNode : collectNodesVisitor.getList()) {
                this.windowFuncCalls.add(windowFunctionNode);
                if (!(windowFunctionNode.getWindow() instanceof WindowDefinitionNode)) continue;
                this.windows = this.addInlinedWindowDefinition(this.windows, windowFunctionNode);
            }
        }
        return resultSetNode;
    }

    private void performTransitiveClosure(int n) throws StandardException {
        this.wherePredicates.joinClauseTransitiveClosure(n, this.fromList, this.getCompilerContext());
        this.wherePredicates.searchClauseTransitiveClosure(n, this.fromList.hashJoinSpecified());
    }

    private ValueNode normExpressions(ValueNode valueNode) throws StandardException {
        if (valueNode != null) {
            valueNode = valueNode.eliminateNots(false);
            valueNode = valueNode.putAndsOnTop();
            valueNode = valueNode.changeToCNF(true);
        }
        return valueNode;
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.wherePredicates.addPredicate(predicate);
        return this;
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        if (this.isDistinct) {
            return false;
        }
        if (this.fromList.size() > 1) {
            return false;
        }
        if (this.selectSubquerys != null && this.selectSubquerys.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        if (!this.getResultColumns().isCloneable()) {
            return false;
        }
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            return false;
        }
        for (int i = 0; i < this.qec.size(); ++i) {
            if (this.qec.getOrderByList(i) != null && this.qec.getOrderByList(i).size() > 0) {
                return false;
            }
            if (this.qec.getOffset(i) == null && this.qec.getFetchFirst(i) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    ResultSetNode genProjectRestrict(int n) throws StandardException {
        QueryTreeNode queryTreeNode;
        int n2;
        SingleChildResultSetNode singleChildResultSetNode;
        List<AggregateNode> list;
        boolean[] blArray = new boolean[this.qec.size()];
        FromTable fromTable = new ProjectRestrictNode((ResultSetNode)this.fromList.elementAt(0), this.getResultColumns(), this.whereClause, this.wherePredicates, this.selectSubquerys, this.whereSubquerys, null, this.getContextManager());
        if (this.selectAggregates != null && this.selectAggregates.size() > 0 || this.groupByList != null) {
            list = this.selectAggregates;
            if (this.havingAggregates != null && !this.havingAggregates.isEmpty()) {
                this.havingAggregates.addAll(this.selectAggregates);
                list = this.havingAggregates;
            }
            singleChildResultSetNode = new GroupByNode(fromTable, this.groupByList, list, this.havingClause, this.havingSubquerys, this.nestingLevel, this.getContextManager());
            ((GroupByNode)singleChildResultSetNode).considerPostOptimizeOptimizations(this.originalWhereClause != null);
            singleChildResultSetNode.assignCostEstimate(this.getOptimizer().getOptimizedCost());
            this.groupByList = null;
            fromTable = ((GroupByNode)singleChildResultSetNode).getParent();
            for (n2 = 0; n2 < blArray.length; ++n2) {
                blArray[n2] = blArray[n2] || ((GroupByNode)singleChildResultSetNode).getIsInSortedOrder();
            }
        }
        if (this.windows != null) {
            if (this.windows.size() > 1) {
                throw StandardException.newException("42ZC1", new Object[0]);
            }
            list = (WindowDefinitionNode)this.windows.elementAt(0);
            singleChildResultSetNode = new WindowResultSetNode(fromTable, (WindowDefinitionNode)((Object)list), this.windowFuncCalls, this.nestingLevel, this.getContextManager());
            fromTable = ((WindowResultSetNode)singleChildResultSetNode).getParent();
            singleChildResultSetNode.assignCostEstimate(this.getOptimizer().getOptimizedCost());
        }
        if (this.isDistinct) {
            this.getResultColumns().verifyAllOrderable();
            boolean bl = false;
            if (n == 1 && !this.orderByAndDistinctMerged) {
                boolean bl2 = true;
                HashSet<BaseColumnNode> hashSet = new HashSet<BaseColumnNode>();
                int n3 = this.getResultColumns().size();
                for (int i = 1; i <= n3; ++i) {
                    queryTreeNode = this.getResultColumns().getResultColumn(i).getBaseColumnNode();
                    if (queryTreeNode == null) {
                        bl2 = false;
                        break;
                    }
                    hashSet.add((BaseColumnNode)queryTreeNode);
                }
                if (bl2 && fromTable.isPossibleDistinctScan(hashSet)) {
                    fromTable.markForDistinctScan();
                    bl = true;
                }
            }
            if (!bl) {
                boolean bl3 = this.isOrderedResult(this.getResultColumns(), fromTable, !this.orderByAndDistinctMerged);
                fromTable = new DistinctNode(fromTable, bl3, null, this.getContextManager());
                fromTable.setCostEstimate(this.getCostEstimate().cloneMe());
                for (n2 = 0; n2 < blArray.length; ++n2) {
                    blArray[n2] = blArray[n2] || bl3;
                }
            }
        }
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if (orderByList != null) {
                if (orderByList.getSortNeeded()) {
                    fromTable = new OrderByNode(fromTable, orderByList, null, this.getContextManager());
                    fromTable.setCostEstimate(this.getCostEstimate().cloneMe());
                }
                if ((n2 = this.getResultColumns().getOrderBySelect()) > 0) {
                    ResultColumnList resultColumnList = fromTable.getResultColumns();
                    ResultColumnList resultColumnList2 = resultColumnList.copyListAndObjects();
                    fromTable.setResultColumns(resultColumnList2);
                    resultColumnList.removeOrderByColumns();
                    resultColumnList.genVirtualColumnNodes(fromTable, resultColumnList2);
                    fromTable = new ProjectRestrictNode(fromTable, resultColumnList, null, null, null, null, null, this.getContextManager());
                }
            }
            ValueNode valueNode = this.qec.getOffset(i);
            ValueNode valueNode2 = this.qec.getFetchFirst(i);
            if (valueNode == null && valueNode2 == null) continue;
            ResultColumnList resultColumnList = fromTable.getResultColumns();
            queryTreeNode = resultColumnList.copyListAndObjects();
            fromTable.setResultColumns((ResultColumnList)queryTreeNode);
            resultColumnList.genVirtualColumnNodes(fromTable, (ResultColumnList)queryTreeNode);
            fromTable = new RowCountNode(fromTable, resultColumnList, valueNode, valueNode2, this.qec.getHasJDBCLimitClause()[i], this.getContextManager());
        }
        if (this.wasGroupBy && this.getResultColumns().numGeneratedColumnsForGroupBy() > 0 && this.windows == null) {
            ResultColumnList resultColumnList = fromTable.getResultColumns();
            ResultColumnList resultColumnList3 = resultColumnList.copyListAndObjects();
            fromTable.setResultColumns(resultColumnList3);
            resultColumnList.removeGeneratedGroupingColumns();
            resultColumnList.genVirtualColumnNodes(fromTable, resultColumnList3);
            fromTable = new ProjectRestrictNode(fromTable, resultColumnList, null, null, null, null, null, this.getContextManager());
        }
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList orderByList = this.qec.getOrderByList(i);
            if ((orderByList == null || !orderByList.getSortNeeded()) && this.orderByQuery) {
                blArray[i] = true;
            }
            if (blArray[i]) {
                fromTable.adjustForSortElimination(orderByList);
            }
            fromTable.setCostEstimate(this.getCostEstimate().cloneMe());
        }
        return fromTable;
    }

    private boolean isOrderedResult(ResultColumnList resultColumnList, ResultSetNode resultSetNode, boolean bl) throws StandardException {
        int n = 0;
        for (ResultColumn resultColumn : resultColumnList) {
            if (resultColumn.getExpression() instanceof ColumnReference) {
                ++n;
                continue;
            }
            if (resultColumn.getExpression() instanceof ConstantNode) continue;
            return false;
        }
        if (n == 0) {
            return true;
        }
        ColumnReference[] columnReferenceArray = new ColumnReference[n];
        int n2 = 0;
        for (ResultColumn resultColumn : resultColumnList) {
            if (!(resultColumn.getExpression() instanceof ColumnReference)) continue;
            columnReferenceArray[n2++] = (ColumnReference)resultColumn.getExpression();
        }
        return resultSetNode.isOrderedOn(columnReferenceArray, bl, null);
    }

    @Override
    ResultSetNode ensurePredicateList(int n) throws StandardException {
        return this;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        int n;
        for (n = 0; n < this.qec.size(); ++n) {
            OrderByList orderByList = this.qec.getOrderByList(n);
            if (orderByList == null || orderByList.size() <= 1) continue;
            orderByList.removeDupColumns();
        }
        if (this.wherePredicates != null) {
            for (n = this.wherePredicates.size() - 1; n >= 0; --n) {
                if (!((Predicate)this.wherePredicates.elementAt(n)).isScopedForPush()) continue;
                this.wherePredicates.removeOptPredicate(n);
            }
        }
        if (predicateList != null) {
            if (this.wherePredicates == null) {
                this.wherePredicates = new PredicateList(this.getContextManager());
            }
            n = predicateList.size();
            for (int i = n - 1; i >= 0; --i) {
                Predicate predicate = (Predicate)predicateList.getOptPredicate(i);
                if (!predicate.isScopedToSourceResultSet()) continue;
                this.wherePredicates.addOptPredicate(predicate);
                predicateList.removeOptPredicate(predicate);
            }
        }
        Optimizer optimizer = this.getOptimizer(this.fromList, this.wherePredicates, dataDictionary, this.qec.getOrderByList(0), this.overridingPlan);
        optimizer.setOuterRows(d);
        while (optimizer.getNextPermutation()) {
            while (optimizer.getNextDecoratedPermutation()) {
                optimizer.costPermutation();
            }
        }
        if (this.wherePredicates != null) {
            for (n = this.wherePredicates.size() - 1; n >= 0; --n) {
                Predicate predicate = (Predicate)this.wherePredicates.getOptPredicate(n);
                if (!predicate.isScopedForPush()) continue;
                predicateList.addOptPredicate(predicate);
                this.wherePredicates.removeOptPredicate(predicate);
            }
        }
        this.setCostEstimate(optimizer.getOptimizedCost());
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            this.getCostEstimate().setEstimatedRowCount((long)d);
            this.getCostEstimate().setSingleScanRowCount(1.0);
        }
        this.selectSubquerys.optimize(dataDictionary, this.getCostEstimate().rowCount());
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.optimize(dataDictionary, this.getCostEstimate().rowCount());
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.optimize(dataDictionary, this.getCostEstimate().rowCount());
        }
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceEndQueryBlock();
        }
        return this;
    }

    private Optimizer getOptimizer(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, RequiredRowOrdering requiredRowOrdering, OptimizerPlan optimizerPlan) throws StandardException {
        if (this.getOptimizer() == null) {
            OptimizerFactory optimizerFactory = this.getLanguageConnectionContext().getOptimizerFactory();
            this.setOptimizer(optimizerFactory.getOptimizer(optimizableList, optimizablePredicateList, dataDictionary, requiredRowOrdering, this.getCompilerContext().getNumTables(), optimizerPlan, this.getLanguageConnectionContext()));
        }
        this.getOptimizer().prepForNextRound();
        return this.getOptimizer();
    }

    @Override
    ResultSetNode modifyAccessPaths(PredicateList predicateList) throws StandardException {
        this.getOptimizerImpl().addScopedPredicatesToList(predicateList, this.getContextManager());
        return this.modifyAccessPaths();
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        int n = this.fromList.size();
        this.getOptimizer().modifyAccessPaths();
        this.setCostEstimate(this.getOptimizer().getFinalCost());
        this.selectSubquerys.modifyAccessPaths();
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.modifyAccessPaths();
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.modifyAccessPaths();
        }
        this.preJoinFL.removeAllElements();
        this.preJoinFL.nondestructiveAppend(this.fromList);
        while (this.fromList.size() > 1) {
            ResultSetNode resultSetNode = (ResultSetNode)this.fromList.elementAt(0);
            ResultColumnList resultColumnList = resultSetNode.getResultColumns();
            resultSetNode.setResultColumns(resultColumnList.copyListAndObjects());
            resultColumnList.genVirtualColumnNodes(resultSetNode, resultSetNode.getResultColumns());
            ResultSetNode resultSetNode2 = (ResultSetNode)this.fromList.elementAt(1);
            ResultColumnList resultColumnList2 = resultSetNode2.getResultColumns();
            resultSetNode2.setResultColumns(resultColumnList2.copyListAndObjects());
            resultColumnList2.genVirtualColumnNodes(resultSetNode2, resultSetNode2.getResultColumns());
            resultColumnList2.adjustVirtualColumnIds(resultColumnList.size());
            resultColumnList.nondestructiveAppend(resultColumnList2);
            this.fromList.setElementAt(new JoinNode(resultSetNode, resultSetNode2, null, null, resultColumnList, null, this.fromList.properties, this.getContextManager()), 0);
            this.fromList.removeElementAt(1);
        }
        return this.genProjectRestrict(n);
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        return this.getOptimizer().getFinalCost();
    }

    @Override
    boolean isUpdatableCursor(DataDictionary dataDictionary) throws StandardException {
        if (this.isDistinct) {
            return false;
        }
        if (this.selectAggregates == null || this.selectAggregates.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        if (this.fromList.size() != 1) {
            return false;
        }
        this.targetTable = (FromTable)this.fromList.elementAt(0);
        if (this.targetTable instanceof FromVTI) {
            return ((FromVTI)this.targetTable).isUpdatableCursor();
        }
        if (!(this.targetTable instanceof FromBaseTable)) {
            return false;
        }
        if (!this.targetTable.columnsAreUpdatable()) {
            return false;
        }
        TableDescriptor tableDescriptor = this.getTableDescriptor(((FromBaseTable)this.targetTable).getBaseTableName(), this.getSchemaDescriptor(((FromBaseTable)this.targetTable).getTableNameField().getSchemaName()));
        if (tableDescriptor.getTableType() == 1) {
            return false;
        }
        if (tableDescriptor.getTableType() == 2) {
            return false;
        }
        if (this.getSelectSubquerys() != null && this.getSelectSubquerys().size() != 0) {
            return false;
        }
        return this.getWhereSubquerys() == null || this.getWhereSubquerys().size() == 0;
    }

    @Override
    FromTable getCursorTargetTable() {
        return this.targetTable;
    }

    @Override
    boolean referencesTarget(String string, boolean bl) throws StandardException {
        return this.fromList.referencesTarget(string, bl) || this.selectSubquerys != null && this.selectSubquerys.referencesTarget(string, bl) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(string, bl);
    }

    @Override
    boolean subqueryReferencesTarget(String string, boolean bl) throws StandardException {
        return this.selectSubquerys != null && this.selectSubquerys.referencesTarget(string, bl) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(string, bl);
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        this.fromList.bindUntypedNullsToResultColumns(resultColumnList);
    }

    @Override
    void decrementLevel(int n) {
        this.fromList.decrementLevel(n);
        this.selectSubquerys.decrementLevel(n);
        this.whereSubquerys.decrementLevel(n);
        this.wherePredicates.decrementLevel(this.fromList, n);
    }

    boolean uniqueSubquery(boolean bl) throws StandardException {
        ColumnReference columnReference = null;
        ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(0);
        if (bl && resultColumn.getExpression() instanceof ColumnReference && (columnReference = (ColumnReference)resultColumn.getExpression()).getCorrelated()) {
            columnReference = null;
        }
        return this.fromList.returnsAtMostSingleRow(columnReference == null ? null : this.getResultColumns(), this.whereClause, this.wherePredicates, this.getDataDictionary());
    }

    @Override
    int updateTargetLockMode() {
        return this.fromList.updateTargetLockMode();
    }

    @Override
    boolean returnsAtMostOneRow() {
        return this.groupByList == null && this.selectAggregates != null && !this.selectAggregates.isEmpty();
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.fromList.referencesSessionSchema() || this.selectSubquerys != null && this.selectSubquerys.referencesSessionSchema() || this.whereSubquerys != null && this.whereSubquerys.referencesSessionSchema();
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.fromList != null) {
            this.fromList = (FromList)this.fromList.accept(visitor);
        }
        if (this.whereClause != null) {
            this.whereClause = (ValueNode)this.whereClause.accept(visitor);
        }
        if (this.wherePredicates != null) {
            this.wherePredicates = (PredicateList)this.wherePredicates.accept(visitor);
        }
        if (this.havingClause != null) {
            this.havingClause = (ValueNode)this.havingClause.accept(visitor);
        }
        if (!(visitor instanceof HasCorrelatedCRsVisitor)) {
            if (this.selectSubquerys != null) {
                this.selectSubquerys = (SubqueryList)this.selectSubquerys.accept(visitor);
            }
            if (this.whereSubquerys != null) {
                this.whereSubquerys = (SubqueryList)this.whereSubquerys.accept(visitor);
            }
            if (this.groupByList != null) {
                this.groupByList = (GroupByList)this.groupByList.accept(visitor);
            }
            for (int i = 0; i < this.qec.size(); ++i) {
                ValueNode valueNode;
                ValueNode valueNode2;
                OrderByList orderByList = this.qec.getOrderByList(i);
                if (orderByList != null) {
                    this.qec.setOrderByList(i, (OrderByList)orderByList.accept(visitor));
                }
                if ((valueNode2 = this.qec.getOffset(i)) != null) {
                    this.qec.setOffset(i, (ValueNode)valueNode2.accept(visitor));
                }
                if ((valueNode = this.qec.getFetchFirst(i)) == null) continue;
                this.qec.setFetchFirst(i, (ValueNode)valueNode.accept(visitor));
            }
            if (this.preJoinFL != null) {
                this.preJoinFL = (FromList)this.preJoinFL.accept(visitor);
            }
            if (this.windows != null) {
                this.windows = (WindowList)this.windows.accept(visitor);
            }
        }
    }

    boolean hasAggregatesInSelectList() {
        return !this.selectAggregates.isEmpty();
    }

    boolean hasWindows() {
        return this.windows != null;
    }

    static void checkNoWindowFunctions(QueryTreeNode queryTreeNode, String string) throws StandardException {
        HasNodeVisitor hasNodeVisitor = new HasNodeVisitor(WindowFunctionNode.class, SubqueryNode.class);
        queryTreeNode.accept(hasNodeVisitor);
        if (hasNodeVisitor.hasNode()) {
            throw StandardException.newException("42ZC2", string);
        }
    }

    @Override
    void replaceOrForbidDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, boolean bl) throws StandardException {
    }

    boolean hasOffsetFetchFirst() {
        return this.qec.hasOffsetFetchFirst();
    }
}

