/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.container.common.spi.CDIService;
import com.sun.enterprise.container.common.spi.InterceptorInvoker;
import com.sun.enterprise.container.common.spi.JavaEEInterceptorBuilder;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldManager;
import org.jvnet.hk2.annotations.Service;

@Service
public class ACCCDIServiceImpl
implements CDIService {
    private WeldContainer weldContainer;
    @Inject
    private InjectionManager InjectionManager;

    public boolean isCurrentModuleCDIEnabled() {
        return this.hasBeansXML(Thread.currentThread().getContextClassLoader());
    }

    public boolean isCDIEnabled(BundleDescriptor bundle) {
        return this.hasBeansXML(bundle.getClassLoader());
    }

    public boolean isCDIScoped(Class<?> clazz) {
        throw new UnsupportedOperationException("Application Client Container");
    }

    public void setELResolver(ServletContext servletContext) throws NamingException {
        throw new UnsupportedOperationException("Application Client Container");
    }

    public CDIService.CDIInjectionContext createManagedObject(Class managedClass, BundleDescriptor bundle) {
        return this.createManagedObject(managedClass, bundle, true);
    }

    private <T> T createEEManagedObject(ManagedBeanDescriptor managedBeanDescriptor) throws Exception {
        JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)managedBeanDescriptor.getInterceptorBuilder();
        InterceptorInvoker interceptorInvoker = interceptorBuilder.createInvoker(null);
        for (Object interceptorInstance : interceptorInvoker.getInterceptorInstances()) {
            this.InjectionManager.injectInstance(interceptorInstance, managedBeanDescriptor.getGlobalJndiName(), false);
        }
        interceptorInvoker.invokeAroundConstruct();
        Object managedBean = interceptorInvoker.getTargetInstance();
        this.InjectionManager.injectInstance(managedBean, (JndiNameEnvironment)managedBeanDescriptor);
        interceptorInvoker.invokePostConstruct();
        managedBeanDescriptor.addBeanInstanceInfo(managedBean, (Object)interceptorInvoker);
        return (T)managedBean;
    }

    public CDIService.CDIInjectionContext createManagedObject(Class managedClass, BundleDescriptor bundle, boolean invokePostConstruct) {
        Object managedObject = null;
        try {
            managedObject = this.createEEManagedObject(bundle.getManagedBeanByBeanClass(managedClass.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WeldContainer weldContainer = this.getWeldContainer();
        if (weldContainer == null) {
            return null;
        }
        BeanManager beanManager = weldContainer.getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(managedClass);
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget target = injectionTargetFactory.createInjectionTarget(null);
        target.inject(managedObject, creationalContext);
        if (invokePostConstruct) {
            target.postConstruct(managedObject);
        }
        return new CDIInjectionContextImpl(target, creationalContext, managedObject);
    }

    public void injectManagedObject(Object managedObject, BundleDescriptor bundle) {
        WeldContainer weldContainer = this.getWeldContainer();
        if (weldContainer == null) {
            return;
        }
        BeanManager beanManager = weldContainer.getBeanManager();
        CreationalContext creationalContext = beanManager.createCreationalContext(null);
        AnnotatedType annotatedType = beanManager.createAnnotatedType(managedObject.getClass());
        InjectionTargetFactory injectionTargetFactory = beanManager.getInjectionTargetFactory(annotatedType);
        InjectionTarget target = injectionTargetFactory.createInjectionTarget(null);
        target.inject(managedObject, creationalContext);
    }

    public <T> T createInterceptorInstance(Class<T> interceptorClass, EjbDescriptor ejbDesc, CDIService.CDIInjectionContext ejbContext, Set<EjbInterceptor> ejbInterceptors) {
        Object interceptorInstance = null;
        WeldContainer weldContainer = this.getWeldContainer();
        if (weldContainer != null) {
            BeanManager beanManager = weldContainer.getBeanManager();
            AnnotatedType annotatedType = beanManager.createAnnotatedType(interceptorClass);
            WeldInjectionTarget target = ((WeldManager)beanManager).getInjectionTargetFactory(annotatedType).createInterceptorInjectionTarget();
            CreationalContext creationalContext = beanManager.createCreationalContext(null);
            interceptorInstance = target.produce(creationalContext);
            target.inject(interceptorInstance, creationalContext);
        }
        return (T)interceptorInstance;
    }

    public <T> CDIService.CDIInjectionContext<T> createCDIInjectionContext(EjbDescriptor ejbDesc, Map<Class, Object> ejbInfo) {
        return this.createCDIInjectionContext(ejbDesc, null, null);
    }

    public <T> CDIService.CDIInjectionContext<T> createCDIInjectionContext(EjbDescriptor ejbDesc, T instance, Map<Class, Object> ejbInfo) {
        throw new UnsupportedOperationException("Application Client Container");
    }

    public CDIService.CDIInjectionContext createEmptyCDIInjectionContext() {
        return new CDIInjectionContextImpl();
    }

    public void injectEJBInstance(CDIService.CDIInjectionContext injectionCtx) {
        throw new UnsupportedOperationException("Application Client Container");
    }

    private WeldContainer getWeldContainer() {
        if (this.weldContainer == null) {
            try {
                this.weldContainer = new Weld().initialize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.weldContainer;
    }

    private boolean hasBeansXML(ClassLoader classLoader) {
        return classLoader.getResource("META-INF/beans.xml") != null;
    }

    private static class CDIInjectionContextImpl
    implements CDIService.CDIInjectionContext {
        InjectionTarget injectionTarget;
        CreationalContext creationalContext;
        Object instance;

        CDIInjectionContextImpl() {
        }

        CDIInjectionContextImpl(InjectionTarget it, CreationalContext cc, Object i) {
            this.injectionTarget = it;
            this.creationalContext = cc;
            this.instance = i;
        }

        public Object getInstance() {
            return this.instance;
        }

        public void setInstance(Object instance) {
            this.instance = instance;
        }

        public void cleanup(boolean callPreDestroy) {
            if (callPreDestroy) {
                this.injectionTarget.preDestroy(this.instance);
            }
            this.injectionTarget.dispose(this.instance);
            this.creationalContext.release();
        }

        public InjectionTarget getInjectionTarget() {
            return this.injectionTarget;
        }

        public void setInjectionTarget(InjectionTarget injectionTarget) {
            this.injectionTarget = injectionTarget;
        }

        public CreationalContext getCreationalContext() {
            return this.creationalContext;
        }

        public void setCreationalContext(CreationalContext creationalContext) {
            this.creationalContext = creationalContext;
        }

        public void addDependentContext(CDIService.CDIInjectionContext dependentContext) {
        }

        public Collection<CDIService.CDIInjectionContext> getDependentContexts() {
            return new ArrayList<CDIService.CDIInjectionContext>();
        }

        public Object createEjbAfterAroundConstruct() {
            return null;
        }
    }
}

