/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.ConcurrencyUtil;
import org.eclipse.persistence.internal.helper.type.ReadLockAcquisitionMetadata;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class ReadLockManager {
    public static final int FIRST_INDEX_OF_COLLECTION = 0;
    private final Vector<ConcurrencyManager> readLocks = new Vector(1);
    private final Map<Long, List<ReadLockAcquisitionMetadata>> mapThreadToReadLockAcquisitionMetadata = new HashMap<Long, List<ReadLockAcquisitionMetadata>>();
    private final List<String> removeReadLockProblemsDetected = new ArrayList<String>();
    private final Lock instanceLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadLock(ConcurrencyManager concurrencyManager) {
        this.instanceLock.lock();
        try {
            Object primaryKey;
            Thread currentThread = Thread.currentThread();
            long currentThreadId = currentThread.getId();
            ReadLockAcquisitionMetadata readLockAcquisitionMetadata = ConcurrencyUtil.SINGLETON.createReadLockAcquisitionMetadata(concurrencyManager);
            if (concurrencyManager.isCacheKey() && (primaryKey = ((CacheKey)concurrencyManager).getKey()) == null) {
                AbstractSessionLog.getLog().log(6, "cache", "cache_key_null_read_lock_manager", new Object[]{concurrencyManager.toString()}, true);
            }
            this.readLocks.add(0, concurrencyManager);
            if (!this.mapThreadToReadLockAcquisitionMetadata.containsKey(currentThreadId)) {
                List newList = Collections.synchronizedList(new ArrayList());
                this.mapThreadToReadLockAcquisitionMetadata.put(currentThreadId, newList);
            }
            List<ReadLockAcquisitionMetadata> acquiredReadLocksInCurrentTransactionList = this.mapThreadToReadLockAcquisitionMetadata.get(currentThreadId);
            acquiredReadLocksInCurrentTransactionList.add(0, readLockAcquisitionMetadata);
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReadLock(ConcurrencyManager concurrencyManager) {
        this.instanceLock.lock();
        try {
            Thread currentThread = Thread.currentThread();
            long currentThreadId = currentThread.getId();
            boolean readLockManagerHasTracingAboutAddedReadLocksForCurrentThread = this.mapThreadToReadLockAcquisitionMetadata.containsKey(currentThreadId);
            if (!readLockManagerHasTracingAboutAddedReadLocksForCurrentThread) {
                String errorMessage = ConcurrencyUtil.SINGLETON.readLockManagerProblem02ReadLockManageHasNoEntriesForThread(concurrencyManager, currentThreadId);
                this.removeReadLockProblemsDetected.add(errorMessage);
                return;
            }
            List<ReadLockAcquisitionMetadata> readLocksAcquiredDuringCurrentThread = this.mapThreadToReadLockAcquisitionMetadata.get(currentThreadId);
            ReadLockAcquisitionMetadata readLockAquisitionMetadataToRemove = null;
            for (ReadLockAcquisitionMetadata currentReadLockAcquisitionMetadata : readLocksAcquiredDuringCurrentThread) {
                ConcurrencyManager currentCacheKeyObjectToCheck = currentReadLockAcquisitionMetadata.getCacheKeyWhoseNumberOfReadersThreadIsIncrementing();
                boolean dtoToRemoveFound = concurrencyManager.getConcurrencyManagerId() == currentCacheKeyObjectToCheck.getConcurrencyManagerId();
                if (!dtoToRemoveFound) continue;
                readLockAquisitionMetadataToRemove = currentReadLockAcquisitionMetadata;
                break;
            }
            if (readLockAquisitionMetadataToRemove == null) {
                String errorMessage = ConcurrencyUtil.SINGLETON.readLockManagerProblem03ReadLockManageHasNoEntriesForThread(concurrencyManager, currentThreadId);
                this.removeReadLockProblemsDetected.add(errorMessage);
                return;
            }
            this.readLocks.remove(concurrencyManager);
            readLocksAcquiredDuringCurrentThread.remove(readLockAquisitionMetadataToRemove);
            if (readLocksAcquiredDuringCurrentThread.isEmpty()) {
                this.mapThreadToReadLockAcquisitionMetadata.remove(currentThreadId);
            }
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    public List<ConcurrencyManager> getReadLocks() {
        this.instanceLock.lock();
        try {
            List<ConcurrencyManager> list = Collections.unmodifiableList(this.readLocks);
            return list;
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    public void addRemoveReadLockProblemsDetected(String problemDetected) {
        this.instanceLock.lock();
        try {
            this.removeReadLockProblemsDetected.add(problemDetected);
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    public Map<Long, List<ReadLockAcquisitionMetadata>> getMapThreadToReadLockAcquisitionMetadata() {
        return this.mapThreadToReadLockAcquisitionMetadata;
    }

    public List<String> getRemoveReadLockProblemsDetected() {
        return this.removeReadLockProblemsDetected;
    }

    public boolean isEmpty() {
        this.instanceLock.lock();
        try {
            boolean bl = this.readLocks.isEmpty() && this.removeReadLockProblemsDetected.isEmpty();
            return bl;
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadLockManager clone() {
        this.instanceLock.lock();
        try {
            ReadLockManager clone = new ReadLockManager();
            clone.readLocks.addAll(this.readLocks);
            for (Map.Entry<Long, List<ReadLockAcquisitionMetadata>> currentEntry : this.mapThreadToReadLockAcquisitionMetadata.entrySet()) {
                Long key = currentEntry.getKey();
                List<ReadLockAcquisitionMetadata> value = currentEntry.getValue();
                clone.mapThreadToReadLockAcquisitionMetadata.put(key, new ArrayList<ReadLockAcquisitionMetadata>(value));
            }
            clone.removeReadLockProblemsDetected.addAll(this.removeReadLockProblemsDetected);
            ReadLockManager readLockManager = clone;
            return readLockManager;
        }
        finally {
            this.instanceLock.unlock();
        }
    }
}

