/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class LOBValueWriter {
    private Collection<DatabaseCall> calls = null;
    private Accessor accessor;
    private boolean isNativeConnectionRequired;

    public LOBValueWriter(Accessor accessor) {
        this.accessor = accessor;
        DatabasePlatform platform = ((DatabaseAccessor)accessor).getPlatform();
        this.isNativeConnectionRequired = platform.isOracle() && ((OraclePlatform)platform).isNativeConnectionRequiredForLobLocator();
    }

    protected void buildAndExecuteCall(DatabaseCall dbCall, AbstractSession session) {
        DatabaseQuery query = dbCall.getQuery();
        if (!query.isWriteObjectQuery()) {
            return;
        }
        WriteObjectQuery writeQuery = (WriteObjectQuery)query;
        writeQuery.setAccessor(this.accessor);
        SQLSelectStatement selectStatement = this.buildSelectStatementForLocator(writeQuery, dbCall, session);
        DatabaseCall call = this.buildCallFromSelectStatementForLocator(selectStatement, writeQuery, dbCall, session);
        this.accessor.executeCall(call, call.getQuery().getTranslationRow(), session);
    }

    public void fetchLocatorAndWriteValue(DatabaseCall dbCall, Object resultSet) throws SQLException {
        Iterator<DatabaseField> iterator1 = dbCall.getContexts().getFields().iterator();
        Iterator iterator = dbCall.getContexts().getValues().iterator();
        AbstractSession executionSession = dbCall.getQuery().getSession().getExecutionSession(dbCall.getQuery());
        while (iterator1.hasNext()) {
            DatabaseField field = iterator1.next();
            Object value = iterator.next();
            executionSession.getPlatform().writeLOB(field, value, (ResultSet)resultSet, executionSession);
        }
    }

    private SQLSelectStatement buildSelectStatementForLocator(WriteObjectQuery writeQuery, DatabaseCall call, AbstractSession session) {
        SQLSelectStatement selectStatement = new SQLSelectStatement();
        List<DatabaseTable> tables = writeQuery.getDescriptor().getTables();
        selectStatement.setTables(tables);
        selectStatement.setFields(call.getContexts().getFields());
        selectStatement.setWhereClause(writeQuery.getDescriptor().getObjectBuilder().buildPrimaryKeyExpressionFromObject(writeQuery.getObject(), session));
        selectStatement.setLockingClause(ForUpdateClause.newInstance((short)1));
        if (tables.size() > 1) {
            Expression expression = selectStatement.getWhereClause();
            Expression additionalJoin = writeQuery.getDescriptor().getQueryManager().getAdditionalJoinExpression();
            if (additionalJoin != null) {
                expression = expression.and(additionalJoin);
            }
            selectStatement.setWhereClause(expression);
        }
        selectStatement.normalize(session, writeQuery.getDescriptor());
        return selectStatement;
    }

    private DatabaseCall buildCallFromSelectStatementForLocator(SQLSelectStatement selectStatement, WriteObjectQuery writeQuery, DatabaseCall dbCall, AbstractSession session) {
        DatabaseCall call = selectStatement.buildCall(session);
        call.setIsNativeConnectionRequired(this.isNativeConnectionRequired);
        call.setContexts(dbCall.getContexts());
        call.returnOneRow();
        call.setQuery(writeQuery);
        call.prepare(session);
        call.translate(writeQuery.getTranslationRow(), writeQuery.getModifyRow(), session);
        return call;
    }

    public void addCall(Call call) {
        if (this.calls == null) {
            this.calls = new ArrayList<DatabaseCall>(2);
        }
        this.calls.add((DatabaseCall)call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildAndExecuteSelectCalls(AbstractSession session) {
        if (this.calls == null || this.calls.isEmpty()) {
            return;
        }
        try {
            for (DatabaseCall dbCall : this.calls) {
                this.buildAndExecuteCall(dbCall, session);
            }
        }
        finally {
            this.calls.clear();
        }
    }
}

