/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.cluster;

import jakarta.websocket.CloseReason;
import jakarta.websocket.EncodeException;
import jakarta.websocket.Extension;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.cluster.ClusterContext;
import org.glassfish.tyrus.core.cluster.DistributedSession;

public class RemoteSession
implements Session,
DistributedSession {
    private static final Integer SYNC_SEND_TIMEOUT = 30;
    private final RemoteEndpoint.Basic basicRemote;
    private final RemoteEndpoint.Async asyncRemote;
    private final String sessionId;
    private final String connectionId;
    private final ClusterContext clusterContext;
    private final Map<DistributedMapKey, Object> distributedPropertyMap;
    private final TyrusEndpointWrapper endpointWrapper;

    public RemoteSession(final String sessionId, final ClusterContext clusterContext, Map<DistributedMapKey, Object> distributedPropertyMap, final TyrusEndpointWrapper endpointWrapper, final Session session) {
        this.sessionId = sessionId;
        this.clusterContext = clusterContext;
        this.distributedPropertyMap = distributedPropertyMap;
        this.endpointWrapper = endpointWrapper;
        this.connectionId = distributedPropertyMap.get(DistributedMapKey.CONNECTION_ID).toString();
        this.basicRemote = new RemoteEndpoint.Basic(){

            public void sendText(String text) throws IOException {
                Utils.checkNotNull(text, "text");
                Future<Void> future = clusterContext.sendText(sessionId, text);
                this.processFuture(future);
            }

            public void sendBinary(ByteBuffer data) throws IOException {
                Utils.checkNotNull(data, "data");
                Future<Void> future = clusterContext.sendBinary(sessionId, Utils.getRemainingArray(data));
                this.processFuture(future);
            }

            public void sendText(String partialMessage, boolean isLast) throws IOException {
                Utils.checkNotNull(partialMessage, "partialMessage");
                Future<Void> future = clusterContext.sendText(sessionId, partialMessage, isLast);
                this.processFuture(future);
            }

            public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
                Utils.checkNotNull(partialByte, "partialByte");
                Future<Void> future = clusterContext.sendBinary(sessionId, Utils.getRemainingArray(partialByte), isLast);
                this.processFuture(future);
            }

            private void processFuture(Future<?> future) throws IOException {
                try {
                    future.get(SYNC_SEND_TIMEOUT.intValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new IOException(e.getCause());
                }
                catch (TimeoutException e) {
                    throw new IOException(e.getCause());
                }
            }

            public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
                if (applicationData != null && applicationData.remaining() > 125) {
                    throw new IllegalArgumentException("Ping applicationData exceeded the maximum allowed payload of 125 bytes.");
                }
                clusterContext.sendPing(sessionId, Utils.getRemainingArray(applicationData));
            }

            public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
                if (applicationData != null && applicationData.remaining() > 125) {
                    throw new IllegalArgumentException("Pong applicationData exceeded the maximum allowed payload of 125 bytes.");
                }
                clusterContext.sendPong(sessionId, Utils.getRemainingArray(applicationData));
            }

            public void sendObject(Object data) throws IOException, EncodeException {
                Future<Void> future;
                Utils.checkNotNull(data, "data");
                Object toSend = endpointWrapper.doEncode(session, data);
                if (toSend instanceof String) {
                    future = clusterContext.sendText(sessionId, (String)toSend);
                } else if (toSend instanceof ByteBuffer) {
                    future = clusterContext.sendBinary(sessionId, Utils.getRemainingArray((ByteBuffer)toSend));
                } else if (toSend instanceof StringWriter) {
                    StringWriter writer = (StringWriter)toSend;
                    StringBuffer sb = writer.getBuffer();
                    future = clusterContext.sendText(sessionId, sb.toString());
                } else if (toSend instanceof ByteArrayOutputStream) {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
                    future = clusterContext.sendBinary(sessionId, baos.toByteArray());
                } else {
                    return;
                }
                this.processFuture(future);
            }

            public OutputStream getSendStream() throws IOException {
                return new OutputStream(){

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        if (b == null) {
                            throw new NullPointerException();
                        }
                        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        if (len == 0) {
                            return;
                        }
                        byte[] toSend = new byte[len];
                        System.arraycopy(b, off, toSend, 0, len);
                        Future<Void> future = clusterContext.sendBinary(sessionId, toSend, false);
                        try {
                            future.get();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() instanceof IOException) {
                                throw (IOException)e.getCause();
                            }
                            throw new IOException(e.getCause());
                        }
                    }

                    @Override
                    public void write(int i) throws IOException {
                        byte[] byteArray = new byte[]{(byte)i};
                        this.write(byteArray, 0, byteArray.length);
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                        clusterContext.sendBinary(sessionId, new byte[0], true);
                    }
                };
            }

            public Writer getSendWriter() throws IOException {
                return new Writer(){
                    private String buffer = null;

                    private void sendBuffer(boolean last) {
                        clusterContext.sendText(sessionId, this.buffer, last);
                    }

                    @Override
                    public void write(char[] chars, int index, int len) throws IOException {
                        if (this.buffer != null) {
                            this.sendBuffer(false);
                        }
                        this.buffer = new String(chars).substring(index, index + len);
                    }

                    @Override
                    public void flush() throws IOException {
                        this.sendBuffer(false);
                        this.buffer = null;
                    }

                    @Override
                    public void close() throws IOException {
                        this.sendBuffer(true);
                    }
                };
            }

            public void setBatchingAllowed(boolean allowed) throws IOException {
            }

            public boolean getBatchingAllowed() {
                return false;
            }

            public void flushBatch() throws IOException {
            }
        };
        this.asyncRemote = new RemoteEndpoint.Async(){

            public long getSendTimeout() {
                return 0L;
            }

            public void setSendTimeout(long timeoutmillis) {
            }

            public void sendText(String text, SendHandler handler) {
                Utils.checkNotNull(text, "text");
                Utils.checkNotNull(handler, "handler");
                clusterContext.sendText(sessionId, text, handler);
            }

            public Future<Void> sendText(String text) {
                Utils.checkNotNull(text, "text");
                return clusterContext.sendText(sessionId, text);
            }

            public Future<Void> sendBinary(ByteBuffer data) {
                Utils.checkNotNull(data, "data");
                return clusterContext.sendBinary(sessionId, Utils.getRemainingArray(data));
            }

            public void sendBinary(ByteBuffer data, SendHandler handler) {
                Utils.checkNotNull(data, "data");
                Utils.checkNotNull(handler, "handler");
                clusterContext.sendBinary(sessionId, Utils.getRemainingArray(data), handler);
            }

            public Future<Void> sendObject(Object data) {
                Future<Void> future;
                Object toSend;
                Utils.checkNotNull(data, "data");
                try {
                    toSend = endpointWrapper.doEncode(session, data);
                }
                catch (Exception e) {
                    return new Future<Void>(){

                        @Override
                        public boolean cancel(boolean mayInterruptIfRunning) {
                            return false;
                        }

                        @Override
                        public boolean isCancelled() {
                            return false;
                        }

                        @Override
                        public boolean isDone() {
                            return true;
                        }

                        @Override
                        public Void get() throws InterruptedException, ExecutionException {
                            throw new ExecutionException(e);
                        }

                        @Override
                        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                            throw new ExecutionException(e);
                        }
                    };
                }
                if (toSend instanceof String) {
                    future = clusterContext.sendText(sessionId, (String)toSend);
                } else if (toSend instanceof ByteBuffer) {
                    future = clusterContext.sendBinary(sessionId, Utils.getRemainingArray((ByteBuffer)toSend));
                } else if (toSend instanceof StringWriter) {
                    StringWriter writer = (StringWriter)toSend;
                    StringBuffer sb = writer.getBuffer();
                    future = clusterContext.sendText(sessionId, sb.toString());
                } else if (toSend instanceof ByteArrayOutputStream) {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
                    future = clusterContext.sendBinary(sessionId, baos.toByteArray());
                } else {
                    future = null;
                }
                return future;
            }

            public void sendObject(Object data, SendHandler handler) {
                Utils.checkNotNull(data, "data");
                if (data instanceof String) {
                    clusterContext.sendText(sessionId, (String)data, handler);
                } else {
                    Object toSend;
                    try {
                        toSend = endpointWrapper.doEncode(session, data);
                    }
                    catch (Throwable t) {
                        handler.onResult(new SendResult(t));
                        return;
                    }
                    if (toSend instanceof String) {
                        clusterContext.sendText(sessionId, (String)toSend, handler);
                    } else if (toSend instanceof ByteBuffer) {
                        clusterContext.sendBinary(sessionId, Utils.getRemainingArray((ByteBuffer)toSend), handler);
                    } else if (toSend instanceof StringWriter) {
                        StringWriter writer = (StringWriter)toSend;
                        StringBuffer sb = writer.getBuffer();
                        clusterContext.sendText(sessionId, sb.toString(), handler);
                    } else if (toSend instanceof ByteArrayOutputStream) {
                        ByteArrayOutputStream baos = (ByteArrayOutputStream)toSend;
                        clusterContext.sendBinary(sessionId, baos.toByteArray(), handler);
                    }
                }
            }

            public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
                if (applicationData != null && applicationData.remaining() > 125) {
                    throw new IllegalArgumentException("Ping applicationData exceeded the maximum allowed payload of 125 bytes.");
                }
                clusterContext.sendPing(sessionId, Utils.getRemainingArray(applicationData));
            }

            public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
                if (applicationData != null && applicationData.remaining() > 125) {
                    throw new IllegalArgumentException("Pong applicationData exceeded the maximum allowed payload of 125 bytes.");
                }
                clusterContext.sendPong(sessionId, Utils.getRemainingArray(applicationData));
            }

            public void setBatchingAllowed(boolean allowed) throws IOException {
            }

            public boolean getBatchingAllowed() {
                return false;
            }

            public void flushBatch() throws IOException {
            }
        };
    }

    public String getProtocolVersion() {
        return "13";
    }

    public String getNegotiatedSubprotocol() {
        return (String)this.distributedPropertyMap.get(DistributedMapKey.NEGOTIATED_SUBPROTOCOL);
    }

    public List<Extension> getNegotiatedExtensions() {
        return (List)this.distributedPropertyMap.get(DistributedMapKey.NEGOTIATED_EXTENSIONS);
    }

    public boolean isSecure() {
        return (Boolean)this.distributedPropertyMap.get(DistributedMapKey.SECURE);
    }

    public boolean isOpen() {
        return this.clusterContext.isSessionOpen(this.sessionId, this.endpointWrapper.getEndpointPath());
    }

    public long getMaxIdleTimeout() {
        return (Long)this.distributedPropertyMap.get(DistributedMapKey.MAX_IDLE_TIMEOUT);
    }

    public int getMaxBinaryMessageBufferSize() {
        return (Integer)this.distributedPropertyMap.get(DistributedMapKey.MAX_BINARY_MESSAGE_BUFFER_SIZE);
    }

    public int getMaxTextMessageBufferSize() {
        return (Integer)this.distributedPropertyMap.get(DistributedMapKey.MAX_TEXT_MESSAGE_BUFFER_SIZE);
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        return this.asyncRemote;
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        return this.basicRemote;
    }

    public String getId() {
        return this.sessionId;
    }

    public void close() throws IOException {
        this.clusterContext.close(this.sessionId);
    }

    public void close(CloseReason closeReason) throws IOException {
        this.clusterContext.close(this.sessionId, closeReason);
    }

    public URI getRequestURI() {
        return (URI)this.distributedPropertyMap.get(DistributedMapKey.REQUEST_URI);
    }

    public Map<String, List<String>> getRequestParameterMap() {
        return (Map)this.distributedPropertyMap.get(DistributedMapKey.REQUEST_PARAMETER_MAP);
    }

    public String getQueryString() {
        return (String)this.distributedPropertyMap.get(DistributedMapKey.QUERY_STRING);
    }

    public Map<String, String> getPathParameters() {
        return (Map)this.distributedPropertyMap.get(DistributedMapKey.PATH_PARAMETERS);
    }

    public Map<String, Object> getUserProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> getDistributedProperties() {
        return this.clusterContext.getDistributedUserProperties(this.connectionId);
    }

    public Principal getUserPrincipal() {
        return (Principal)this.distributedPropertyMap.get(DistributedMapKey.USER_PRINCIPAL);
    }

    public String toString() {
        return "RemoteSession{sessionId='" + this.sessionId + "', clusterContext=" + String.valueOf(this.clusterContext) + "}";
    }

    public WebSocketContainer getContainer() {
        throw new UnsupportedOperationException();
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        throw new UnsupportedOperationException();
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        throw new UnsupportedOperationException();
    }

    public Set<MessageHandler> getMessageHandlers() {
        throw new UnsupportedOperationException();
    }

    public void removeMessageHandler(MessageHandler handler) {
        throw new UnsupportedOperationException();
    }

    public void setMaxIdleTimeout(long milliseconds) {
        throw new UnsupportedOperationException();
    }

    public void setMaxBinaryMessageBufferSize(int length) {
        throw new UnsupportedOperationException();
    }

    public void setMaxTextMessageBufferSize(int length) {
        throw new UnsupportedOperationException();
    }

    public Set<Session> getOpenSessions() {
        throw new UnsupportedOperationException();
    }

    public static enum DistributedMapKey implements Serializable
    {
        NEGOTIATED_SUBPROTOCOL("negotiatedSubprotocol"),
        NEGOTIATED_EXTENSIONS("negotiatedExtensions"),
        SECURE("secure"),
        MAX_IDLE_TIMEOUT("maxIdleTimeout"),
        MAX_BINARY_MESSAGE_BUFFER_SIZE("maxBinaryBufferSize"),
        MAX_TEXT_MESSAGE_BUFFER_SIZE("maxTextBufferSize"),
        REQUEST_URI("requestURI"),
        REQUEST_PARAMETER_MAP("requestParameterMap"),
        QUERY_STRING("queryString"),
        PATH_PARAMETERS("pathParameters"),
        USER_PRINCIPAL("userPrincipal"),
        CONNECTION_ID("connectionId");

        private final String key;

        private DistributedMapKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

