/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core.virtual;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.glassfish.tyrus.core.virtual.LoomishExecutors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class VirtualThreadSupport {
    private VirtualThreadSupport() {
        throw new IllegalStateException();
    }

    public static boolean isVirtualThread() {
        return Thread.currentThread().isVirtual();
    }

    public static LoomishExecutors allowVirtual(boolean bl, ThreadFactory threadFactory) {
        return bl ? new Java21LoomishExecutors(threadFactory) : new NonLoomishExecutors(threadFactory);
    }

    private static class Java21LoomishExecutors
    implements LoomishExecutors {
        private final ThreadFactory threadFactory;

        private Java21LoomishExecutors(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ExecutorService newCachedThreadPool() {
            return Executors.newThreadPerTaskExecutor(this.threadFactory);
        }

        @Override
        public ExecutorService newFixedThreadPool(int n) {
            return Executors.newFixedThreadPool(n, this.threadFactory);
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService(int n) {
            return Executors.newScheduledThreadPool(n);
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public Thread newThread(String string, Runnable runnable) {
            return Thread.ofVirtual().name(string).unstarted(runnable);
        }

        @Override
        public boolean isVirtual() {
            return true;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class NonLoomishExecutors
    implements LoomishExecutors {
        private final ThreadFactory threadFactory;

        private NonLoomishExecutors(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ExecutorService newCachedThreadPool() {
            return Executors.newCachedThreadPool(this.threadFactory);
        }

        @Override
        public ExecutorService newFixedThreadPool(int n) {
            return Executors.newFixedThreadPool(n, this.threadFactory);
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService(int n) {
            return Executors.newScheduledThreadPool(n, this.threadFactory);
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public Thread newThread(String string, Runnable runnable) {
            return new Thread(null, runnable, string, 0L);
        }

        @Override
        public boolean isVirtual() {
            return false;
        }
    }
}

