/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.protocol.ClientRequestDispatcher;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.ee.spi.protocol.ServerRequestDispatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.pfl.basic.contain.DenseIntMapImpl;

public class RequestDispatcherRegistryImpl
implements RequestDispatcherRegistry {
    protected int defaultId;
    private DenseIntMapImpl<ServerRequestDispatcher> SDRegistry;
    private DenseIntMapImpl<ClientRequestDispatcher> CSRegistry;
    private DenseIntMapImpl<ObjectAdapterFactory> OAFRegistry;
    private DenseIntMapImpl<LocalClientRequestDispatcherFactory> LCSFRegistry;
    private Set<ObjectAdapterFactory> objectAdapterFactories;
    private Set<ObjectAdapterFactory> objectAdapterFactoriesView;
    private Map<String, ServerRequestDispatcher> stringToServerSubcontract;

    public RequestDispatcherRegistryImpl(int defaultId) {
        this.defaultId = defaultId;
        this.SDRegistry = new DenseIntMapImpl();
        this.CSRegistry = new DenseIntMapImpl();
        this.OAFRegistry = new DenseIntMapImpl();
        this.LCSFRegistry = new DenseIntMapImpl();
        this.objectAdapterFactories = new HashSet<ObjectAdapterFactory>();
        this.objectAdapterFactoriesView = Collections.unmodifiableSet(this.objectAdapterFactories);
        this.stringToServerSubcontract = new HashMap<String, ServerRequestDispatcher>();
    }

    @Override
    public synchronized void registerClientRequestDispatcher(ClientRequestDispatcher csc, int scid) {
        this.CSRegistry.set(scid, (Object)csc);
    }

    @Override
    public synchronized void registerLocalClientRequestDispatcherFactory(LocalClientRequestDispatcherFactory csc, int scid) {
        this.LCSFRegistry.set(scid, (Object)csc);
    }

    @Override
    public synchronized void registerServerRequestDispatcher(ServerRequestDispatcher ssc, int scid) {
        this.SDRegistry.set(scid, (Object)ssc);
    }

    @Override
    public synchronized void registerServerRequestDispatcher(ServerRequestDispatcher scc, String name) {
        this.stringToServerSubcontract.put(name, scc);
    }

    @Override
    public synchronized void registerObjectAdapterFactory(ObjectAdapterFactory oaf, int scid) {
        this.objectAdapterFactories.add(oaf);
        this.OAFRegistry.set(scid, (Object)oaf);
    }

    @Override
    public ServerRequestDispatcher getServerRequestDispatcher(int scid) {
        ServerRequestDispatcher sdel = (ServerRequestDispatcher)this.SDRegistry.get(scid);
        if (sdel == null) {
            sdel = (ServerRequestDispatcher)this.SDRegistry.get(this.defaultId);
        }
        return sdel;
    }

    @Override
    public ServerRequestDispatcher getServerRequestDispatcher(String name) {
        ServerRequestDispatcher sdel = this.stringToServerSubcontract.get(name);
        if (sdel == null) {
            sdel = (ServerRequestDispatcher)this.SDRegistry.get(this.defaultId);
        }
        return sdel;
    }

    @Override
    public LocalClientRequestDispatcherFactory getLocalClientRequestDispatcherFactory(int scid) {
        LocalClientRequestDispatcherFactory factory = (LocalClientRequestDispatcherFactory)this.LCSFRegistry.get(scid);
        if (factory == null) {
            factory = (LocalClientRequestDispatcherFactory)this.LCSFRegistry.get(this.defaultId);
        }
        return factory;
    }

    @Override
    public ClientRequestDispatcher getClientRequestDispatcher(int scid) {
        ClientRequestDispatcher subcontract = (ClientRequestDispatcher)this.CSRegistry.get(scid);
        if (subcontract == null) {
            subcontract = (ClientRequestDispatcher)this.CSRegistry.get(this.defaultId);
        }
        return subcontract;
    }

    @Override
    public ObjectAdapterFactory getObjectAdapterFactory(int scid) {
        ObjectAdapterFactory oaf = (ObjectAdapterFactory)this.OAFRegistry.get(scid);
        if (oaf == null) {
            oaf = (ObjectAdapterFactory)this.OAFRegistry.get(this.defaultId);
        }
        return oaf;
    }

    @Override
    public Set<ObjectAdapterFactory> getObjectAdapterFactories() {
        return this.objectAdapterFactoriesView;
    }
}

