/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class ResultVariable
extends AbstractExpression {
    private String asIdentifier;
    private boolean hasSpaceAfterAs;
    private AbstractExpression resultVariable;
    private AbstractExpression selectExpression;

    public ResultVariable(AbstractExpression parent, AbstractExpression selectExpression) {
        super(parent);
        if (selectExpression != null) {
            this.selectExpression = selectExpression;
            this.selectExpression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getSelectExpression().accept(visitor);
        this.getResultVariable().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getSelectExpression());
        children.add(this.getResultVariable());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.selectExpression != null) {
            children.add(this.selectExpression);
            children.add(this.buildStringExpression(' '));
        }
        if (this.asIdentifier != null) {
            children.add(this.buildStringExpression("AS"));
        }
        if (this.hasSpaceAfterAs) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.resultVariable != null) {
            children.add(this.resultVariable);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.selectExpression != null && this.selectExpression.isAncestor(expression)) {
            return this.getQueryBNF("select_expression");
        }
        if (this.resultVariable != null && this.resultVariable.isAncestor(expression)) {
            return this.getQueryBNF("identification_variable");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualAsIdentifier() {
        return this.asIdentifier != null ? this.asIdentifier : "";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("select_clause_select_expression");
    }

    public Expression getResultVariable() {
        if (this.resultVariable == null) {
            this.resultVariable = this.buildNullExpression();
        }
        return this.resultVariable;
    }

    public Expression getSelectExpression() {
        if (this.selectExpression == null) {
            this.selectExpression = this.buildNullExpression();
        }
        return this.selectExpression;
    }

    public boolean hasAs() {
        return this.asIdentifier != null;
    }

    public boolean hasResultVariable() {
        return this.resultVariable != null && !this.resultVariable.isNull();
    }

    public boolean hasSelectExpression() {
        return this.selectExpression != null && !this.selectExpression.isNull();
    }

    public boolean hasSpaceAfterAs() {
        return this.hasSpaceAfterAs;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        if (wordParser.startsWithIdentifier("AS")) {
            this.asIdentifier = wordParser.moveForward(2);
            boolean bl = this.hasSpaceAfterAs = wordParser.skipLeadingWhitespace() > 0;
        }
        if (tolerant) {
            this.resultVariable = this.parse(wordParser, "identification_variable", tolerant);
        } else {
            this.resultVariable = new IdentificationVariable(this, wordParser.word());
            this.resultVariable.parse(wordParser, tolerant);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.selectExpression != null) {
            this.selectExpression.toParsedText(writer, actual);
            if (!writer.isEmpty() && writer.charAt(writer.length() - 1) != ' ') {
                writer.append(' ');
            }
        }
        if (this.asIdentifier != null) {
            writer.append(actual ? this.asIdentifier : "AS");
        }
        if (this.hasSpaceAfterAs) {
            writer.append(' ');
        }
        if (this.resultVariable != null) {
            this.resultVariable.toParsedText(writer, actual);
        }
    }
}

