/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterInfoRequestInfo;
import com.sun.messaging.jmq.util.UID;

public class ClusterInfoInfo {
    private GPacket gp = null;
    private GPacket pkt = null;

    private ClusterInfoInfo() {
    }

    private ClusterInfoInfo(GPacket pkt) {
        this.pkt = pkt;
    }

    public static ClusterInfoInfo newInstance() {
        return new ClusterInfoInfo();
    }

    public static ClusterInfoInfo newInstance(GPacket pkt) {
        return new ClusterInfoInfo(pkt);
    }

    public void partitionAdded(UID partitionID) {
        Integer v;
        if (this.gp == null) {
            this.gp = GPacket.getInstance();
            this.gp.setType((short)74);
        }
        if ((v = (Integer)this.gp.getProp("T")) == null) {
            this.gp.putProp("T", 2);
        } else {
            int t = v | 2;
            this.gp.putProp("T", t);
        }
        this.gp.putProp("partition", partitionID.longValue());
    }

    public void storeSessionOwnerRequestReply(ClusterInfoRequestInfo cir, int status, String reason, String owner) {
        Integer v;
        if (this.gp == null) {
            this.gp = GPacket.getInstance();
            this.gp.setType((short)74);
        }
        if ((v = (Integer)this.gp.getProp("T")) == null) {
            this.gp.putProp("T", 1);
        } else {
            int t = v | 1;
            this.gp.putProp("T", t);
        }
        long ss = cir.getStoreSession();
        this.gp.putProp("storeSession", ss);
        this.gp.putProp("X", cir.getXid());
        this.gp.putProp("S", status);
        if (reason != null) {
            this.gp.putProp("reason", reason);
        }
        if (owner != null) {
            this.gp.putProp("storeSessionOwner", owner);
        }
    }

    public Long getXid() {
        assert (this.gp != null);
        return (Long)this.gp.getProp("X");
    }

    public void setBroadcast(boolean b) {
        assert (this.gp != null);
        if (b) {
            this.gp.setBit(2, true);
        }
    }

    public GPacket getGPacket() {
        assert (this.gp != null);
        this.gp.setBit(1, false);
        return this.gp;
    }

    public static boolean isStoreSessionOwnerInfo(GPacket pkt) {
        Integer t = (Integer)pkt.getProp("T");
        if (t == null) {
            return false;
        }
        return (t & 1) == 1;
    }

    public static boolean isPartitionAddedInfo(GPacket pkt) {
        Integer t = (Integer)pkt.getProp("T");
        if (t == null) {
            return false;
        }
        return (t & 2) == 2;
    }

    public String getStoreSessionOwner() {
        if (this.pkt != null) {
            return (String)this.pkt.getProp("storeSessionOwner");
        }
        return null;
    }

    public UID getPartition() {
        assert (this.pkt != null);
        Long v = (Long)this.pkt.getProp("partition");
        if (v == null) {
            return null;
        }
        return new UID(v);
    }

    public String toString() {
        GPacket p;
        GPacket gPacket = p = this.pkt == null ? this.gp : this.pkt;
        if (p == null) {
            return "[]";
        }
        return "[infoType=" + String.valueOf(p.getProp("T")) + ", " + String.valueOf(p.propsEntrySet()) + "]";
    }
}

