/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ProducerSpi;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.DestMetricsCounters;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jms.management.server.DestinationNotification;
import com.sun.messaging.jms.management.server.DestinationState;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class DestinationMonitor
extends MQMBeanReadOnly {
    private Destination d = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] numWildcardConsumersSignature;
    private static MBeanParameterInfo[] numWildcardProducersSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] dstNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public DestinationMonitor(Destination dest) {
        this.d = dest;
    }

    public Integer getAvgNumActiveConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getAvgActiveConsumers();
    }

    public Integer getAvgNumBackupConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getAvgFailoverConsumers();
    }

    public Integer getAvgNumConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getAvgActiveConsumers();
    }

    public Long getAvgNumMsgs() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getAverageMessages();
    }

    public Long getAvgTotalMsgBytes() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getAverageMessageBytes();
    }

    public String getConnectionID() {
        if (!this.isTemporary().booleanValue()) {
            return null;
        }
        ConnectionUID cxnId = this.d.getConnectionUID();
        if (cxnId == null) {
            return null;
        }
        return Long.toString(cxnId.longValue());
    }

    public Boolean isCreatedByAdmin() {
        boolean b = !this.d.isAutoCreated() && !this.d.isInternal() && !this.d.isDMQ() && !this.d.isAdmin();
        return b;
    }

    public Boolean getCreatedByAdmin() {
        return this.isCreatedByAdmin();
    }

    public Long getDiskReserved() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getDiskReserved();
    }

    public Long getDiskUsed() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getDiskUsed();
    }

    public Integer getDiskUtilizationRatio() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getDiskUtilizationRatio();
    }

    public Long getMsgBytesIn() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getMessageBytesIn();
    }

    public Long getMsgBytesOut() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getMessageBytesOut();
    }

    public String getName() {
        return this.d.getDestinationName();
    }

    public Integer getNumActiveConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getActiveConsumers();
    }

    public Integer getNumBackupConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getFailoverConsumers();
    }

    public Integer getNumConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getNumConsumers();
    }

    public Integer getNumWildcards() throws MBeanException {
        int numConsumers = this.getNumConsumers();
        int numProducers = this.getNumProducers();
        int count = 0;
        if (numConsumers > 0) {
            Iterator consumers = this.d.getConsumers();
            while (consumers.hasNext()) {
                Consumer oneCon = (Consumer)consumers.next();
                if (!oneCon.isWildcard()) continue;
                ++count;
            }
        }
        if (numProducers > 0) {
            Iterator producers = this.d.getProducers();
            while (producers.hasNext()) {
                ProducerSpi oneProd = (ProducerSpi)producers.next();
                if (!oneProd.isWildcard()) continue;
                ++count;
            }
        }
        return count;
    }

    public Integer getNumWildcardConsumers() throws MBeanException {
        return this.getNumWildcardConsumers(null);
    }

    public Integer getNumWildcardConsumers(String wildcard) throws MBeanException {
        int numConsumers = this.getNumConsumers();
        if (numConsumers <= 0) {
            return 0;
        }
        Iterator consumers = this.d.getConsumers();
        if (consumers == null) {
            return 0;
        }
        int count = 0;
        while (consumers.hasNext()) {
            Consumer oneCon = (Consumer)consumers.next();
            if (!oneCon.isWildcard()) continue;
            if (wildcard != null) {
                DestinationUID id = oneCon.getDestinationUID();
                if (!id.getName().equals(wildcard)) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public Integer getNumWildcardProducers() throws MBeanException {
        return this.getNumWildcardProducers(null);
    }

    public Integer getNumWildcardProducers(String wildcard) throws MBeanException {
        int numProducers = this.getNumProducers();
        if (numProducers <= 0) {
            return 0;
        }
        Iterator producers = this.d.getProducers();
        if (producers == null) {
            return 0;
        }
        int count = 0;
        while (producers.hasNext()) {
            ProducerSpi oneProd = (ProducerSpi)producers.next();
            if (!oneProd.isWildcard()) continue;
            if (wildcard != null) {
                DestinationUID id = oneProd.getDestinationUID();
                if (!id.getName().equals(wildcard)) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public String[] getWildcards() throws MBeanException {
        DestinationUID id;
        ArrayList<String> al = new ArrayList<String>();
        String[] list = null;
        int numConsumers = this.getNumConsumers();
        int numProducers = this.getNumProducers();
        if (numConsumers > 0) {
            Iterator consumers = this.d.getConsumers();
            while (consumers.hasNext()) {
                Consumer oneCon = (Consumer)consumers.next();
                if (!oneCon.isWildcard()) continue;
                id = oneCon.getDestinationUID();
                al.add(id.getName());
            }
        }
        if (numProducers > 0) {
            Iterator producers = this.d.getProducers();
            while (producers.hasNext()) {
                ProducerSpi oneProd = (ProducerSpi)producers.next();
                if (!oneProd.isWildcard()) continue;
                id = oneProd.getDestinationUID();
                al.add(id.getName());
            }
        }
        if (al.size() > 0) {
            list = new String[al.size()];
            list = al.toArray(list);
        }
        return list;
    }

    public String[] getConsumerWildcards() throws MBeanException {
        ArrayList<String> al = new ArrayList<String>();
        String[] list = null;
        int numConsumers = this.getNumConsumers();
        if (numConsumers <= 0) {
            return null;
        }
        Iterator consumers = this.d.getConsumers();
        while (consumers.hasNext()) {
            Consumer oneCon = (Consumer)consumers.next();
            if (!oneCon.isWildcard()) continue;
            DestinationUID id = oneCon.getDestinationUID();
            al.add(id.getName());
        }
        if (al.size() > 0) {
            list = new String[al.size()];
            list = al.toArray(list);
        }
        return list;
    }

    public String[] getProducerWildcards() throws MBeanException {
        ArrayList<String> al = new ArrayList<String>();
        String[] list = null;
        int numProducers = this.getNumProducers();
        if (numProducers <= 0) {
            return null;
        }
        Iterator producers = this.d.getProducers();
        while (producers.hasNext()) {
            ProducerSpi oneProd = (ProducerSpi)producers.next();
            if (!oneProd.isWildcard()) continue;
            DestinationUID id = oneProd.getDestinationUID();
            al.add(id.getName());
        }
        if (al.size() > 0) {
            list = new String[al.size()];
            list = al.toArray(list);
        }
        return list;
    }

    public Long getNumMsgs() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di == null) {
            return null;
        }
        return di.nMessages - di.nTxnMessages;
    }

    public Long getNumMsgsRemote() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di == null) {
            return null;
        }
        return di.nRemoteMessages;
    }

    public Long getNumMsgsHeldInTransaction() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di == null) {
            return null;
        }
        return di.nTxnMessages;
    }

    public Long getNumMsgsIn() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getMessagesIn();
    }

    public Long getNumMsgsOut() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getMessagesOut();
    }

    public Long getNumMsgsPendingAcks() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di == null) {
            return null;
        }
        return di.nUnackMessages;
    }

    public Long getNumMsgsInDelayDelivery() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di == null) {
            return null;
        }
        return di.nInDelayMessages;
    }

    public Integer getNumProducers() {
        return this.d.getProducerCount();
    }

    public Long getPeakMsgBytes() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getHighWaterLargestMsgBytes();
    }

    public Integer getPeakNumActiveConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getHWActiveConsumers();
    }

    public Integer getPeakNumBackupConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getHWFailoverConsumers();
    }

    public Integer getPeakNumConsumers() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getHWActiveConsumers();
    }

    public Long getPeakNumMsgs() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getHighWaterMessages();
    }

    public Long getPeakTotalMsgBytes() {
        DestMetricsCounters dmc = this.d.getMetrics();
        return dmc.getHighWaterMessageBytes();
    }

    public String getNextMessageID() {
        PacketReference ref = this.d.peekNext();
        if (ref != null) {
            return ref.getSysMessageID().toString();
        }
        return "";
    }

    public Integer getState() {
        return DestinationUtil.toExternalDestState(this.d.getState());
    }

    public String getStateLabel() {
        return DestinationState.toString(DestinationUtil.toExternalDestState(this.d.getState()));
    }

    public Boolean isTemporary() {
        return this.d.isTemporary();
    }

    public Boolean getTemporary() {
        return this.isTemporary();
    }

    public Long getTotalMsgBytes() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di == null) {
            return null;
        }
        return di.nMessageBytes - di.nTxnMessageBytes;
    }

    public Long getTotalMsgBytesRemote() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di == null) {
            return null;
        }
        return di.nRemoteMessageBytes;
    }

    public Long getTotalMsgBytesHeldInTransaction() {
        DestinationInfo di = DestinationUtil.getDestinationInfo(this.d);
        if (di == null) {
            return null;
        }
        return di.nTxnMessageBytes;
    }

    public String getType() {
        return this.d.isQueue() ? "q" : "t";
    }

    public String[] getActiveConsumerIDs() throws MBeanException {
        int numConsumers = this.getNumActiveConsumers();
        if (numConsumers <= 0) {
            return null;
        }
        Iterator consumers = this.d.getActiveConsumers().iterator();
        String[] ids = new String[numConsumers];
        int i = 0;
        while (consumers.hasNext()) {
            Consumer oneCon = (Consumer)consumers.next();
            long conID = oneCon.getConsumerUID().longValue();
            try {
                String id;
                ids[i] = id = Long.toString(conID);
            }
            catch (Exception ex) {
                this.handleOperationException("getActiveConsumerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public String[] getBackupConsumerIDs() throws MBeanException {
        int numConsumers = this.getNumBackupConsumers();
        if (numConsumers <= 0) {
            return null;
        }
        Iterator consumers = this.d.getFailoverConsumers().iterator();
        String[] ids = new String[numConsumers];
        int i = 0;
        while (consumers.hasNext()) {
            Consumer oneCon = (Consumer)consumers.next();
            long conID = oneCon.getConsumerUID().longValue();
            try {
                String id;
                ids[i] = id = Long.toString(conID);
            }
            catch (Exception ex) {
                this.handleOperationException("getBackupConsumerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public ObjectName getConnection() throws MBeanException {
        ObjectName oName = null;
        if (!this.isTemporary().booleanValue()) {
            return null;
        }
        ConnectionUID cxnId = this.d.getConnectionUID();
        if (cxnId == null) {
            return null;
        }
        try {
            oName = MQObjectName.createConnectionMonitor(Long.toString(cxnId.longValue()));
        }
        catch (Exception e) {
            this.handleOperationException("getConnection", e);
        }
        return oName;
    }

    public String[] getConsumerIDs() throws MBeanException {
        int numConsumers = this.getNumConsumers();
        if (numConsumers <= 0) {
            return null;
        }
        Iterator consumers = this.d.getConsumers();
        String[] ids = new String[numConsumers];
        int i = 0;
        while (consumers.hasNext()) {
            Consumer oneCon = (Consumer)consumers.next();
            long conID = oneCon.getConsumerUID().longValue();
            try {
                String id;
                ids[i] = id = Long.toString(conID);
            }
            catch (Exception ex) {
                this.handleOperationException("getConsumerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public String[] getProducerIDs() throws MBeanException {
        int numProducers = this.getNumProducers();
        if (numProducers <= 0) {
            return null;
        }
        Iterator producers = this.d.getProducers();
        String[] ids = new String[numProducers];
        int i = 0;
        while (producers.hasNext()) {
            ProducerSpi oneProd = (ProducerSpi)producers.next();
            long prodID = oneProd.getProducerUID().longValue();
            try {
                ids[i] = Long.toString(prodID);
            }
            catch (Exception ex) {
                this.handleOperationException("getProducerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    @Override
    public String getMBeanName() {
        return "DestinationMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1134");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyDestinationCompact() {
        DestinationNotification n = new DestinationNotification("mq.destination.compact", this, this.sequenceNumber++);
        n.setDestinationName(this.getName());
        n.setDestinationType(this.getType());
        this.sendNotification(n);
    }

    public void notifyDestinationPause(String pauseType) {
        DestinationNotification n = new DestinationNotification("mq.destination.pause", this, this.sequenceNumber++);
        n.setDestinationName(this.getName());
        n.setDestinationType(this.getType());
        n.setPauseType(pauseType);
        this.sendNotification(n);
    }

    public void notifyDestinationPurge() {
        DestinationNotification n = new DestinationNotification("mq.destination.purge", this, this.sequenceNumber++);
        n.setDestinationName(this.getName());
        n.setDestinationType(this.getType());
        this.sendNotification(n);
    }

    public void notifyDestinationResume() {
        DestinationNotification n = new DestinationNotification("mq.destination.resume", this, this.sequenceNumber++);
        n.setDestinationName(this.getName());
        n.setDestinationType(this.getType());
        this.sendNotification(n);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[41];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("AvgNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1090"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("AvgNumBackupConsumers", Integer.class.getName(), mbr.getString("MB1091"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("AvgNumConsumers", Integer.class.getName(), mbr.getString("MB1092"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("AvgNumMsgs", Long.class.getName(), mbr.getString("MB1093"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("AvgTotalMsgBytes", Long.class.getName(), mbr.getString("MB1094"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("ConnectionID", String.class.getName(), mbr.getString("MB1095"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("CreatedByAdmin", Boolean.class.getName(), mbr.getString("MB1096"), true, false, true);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("DiskReserved", Long.class.getName(), mbr.getString("MB1097"), true, false, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("DiskUsed", Long.class.getName(), mbr.getString("MB1098"), true, false, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("DiskUtilizationRatio", Integer.class.getName(), mbr.getString("MB1099"), true, false, false);
        mBeanAttributeInfoArray[10] = new MBeanAttributeInfo("MsgBytesIn", Long.class.getName(), mbr.getString("MB1100"), true, false, false);
        mBeanAttributeInfoArray[11] = new MBeanAttributeInfo("MsgBytesOut", Long.class.getName(), mbr.getString("MB1101"), true, false, false);
        mBeanAttributeInfoArray[12] = new MBeanAttributeInfo("Name", String.class.getName(), mbr.getString("MB1087"), true, false, false);
        mBeanAttributeInfoArray[13] = new MBeanAttributeInfo("NumActiveConsumers", Integer.class.getName(), mbr.getString("MB1102"), true, false, false);
        mBeanAttributeInfoArray[14] = new MBeanAttributeInfo("NumBackupConsumers", Integer.class.getName(), mbr.getString("MB1103"), true, false, false);
        mBeanAttributeInfoArray[15] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1104"), true, false, false);
        mBeanAttributeInfoArray[16] = new MBeanAttributeInfo("NumWildcards", Integer.class.getName(), mbr.getString("MB1243"), true, false, false);
        mBeanAttributeInfoArray[17] = new MBeanAttributeInfo("NumWildcardConsumers", Integer.class.getName(), mbr.getString("MB1244"), true, false, false);
        mBeanAttributeInfoArray[18] = new MBeanAttributeInfo("NumWildcardProducers", Integer.class.getName(), mbr.getString("MB1245"), true, false, false);
        mBeanAttributeInfoArray[19] = new MBeanAttributeInfo("NumMsgs", Long.class.getName(), mbr.getString("MB1105"), true, false, false);
        mBeanAttributeInfoArray[20] = new MBeanAttributeInfo("NumMsgsRemote", Long.class.getName(), mbr.getString("MB1262"), true, false, false);
        mBeanAttributeInfoArray[21] = new MBeanAttributeInfo("NumMsgsHeldInTransaction", Long.class.getName(), mbr.getString("MB1106"), true, false, false);
        mBeanAttributeInfoArray[22] = new MBeanAttributeInfo("NumMsgsIn", Long.class.getName(), mbr.getString("MB1107"), true, false, false);
        mBeanAttributeInfoArray[23] = new MBeanAttributeInfo("NumMsgsOut", Long.class.getName(), mbr.getString("MB1108"), true, false, false);
        mBeanAttributeInfoArray[24] = new MBeanAttributeInfo("NumMsgsPendingAcks", Long.class.getName(), mbr.getString("MB1109"), true, false, false);
        mBeanAttributeInfoArray[25] = new MBeanAttributeInfo("NumMsgsInDelayDelivery", Long.class.getName(), mbr.getString("MB1273"), true, false, false);
        mBeanAttributeInfoArray[26] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1110"), true, false, false);
        mBeanAttributeInfoArray[27] = new MBeanAttributeInfo("PeakMsgBytes", Long.class.getName(), mbr.getString("MB1111"), true, false, false);
        mBeanAttributeInfoArray[28] = new MBeanAttributeInfo("PeakNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1112"), true, false, false);
        mBeanAttributeInfoArray[29] = new MBeanAttributeInfo("PeakNumBackupConsumers", Integer.class.getName(), mbr.getString("MB1113"), true, false, false);
        mBeanAttributeInfoArray[30] = new MBeanAttributeInfo("PeakNumConsumers", Integer.class.getName(), mbr.getString("MB1114"), true, false, false);
        mBeanAttributeInfoArray[31] = new MBeanAttributeInfo("PeakNumMsgs", Long.class.getName(), mbr.getString("MB1115"), true, false, false);
        mBeanAttributeInfoArray[32] = new MBeanAttributeInfo("PeakTotalMsgBytes", Long.class.getName(), mbr.getString("MB1116"), true, false, false);
        mBeanAttributeInfoArray[33] = new MBeanAttributeInfo("NextMessageID", String.class.getName(), mbr.getString("MB1266"), true, false, false);
        mBeanAttributeInfoArray[34] = new MBeanAttributeInfo("State", Integer.class.getName(), mbr.getString("MB1117"), true, false, false);
        mBeanAttributeInfoArray[35] = new MBeanAttributeInfo("StateLabel", String.class.getName(), mbr.getString("MB1118"), true, false, false);
        mBeanAttributeInfoArray[36] = new MBeanAttributeInfo("Temporary", Boolean.class.getName(), mbr.getString("MB1119"), true, false, true);
        mBeanAttributeInfoArray[37] = new MBeanAttributeInfo("TotalMsgBytes", Long.class.getName(), mbr.getString("MB1120"), true, false, false);
        mBeanAttributeInfoArray[38] = new MBeanAttributeInfo("TotalMsgBytesRemote", Long.class.getName(), mbr.getString("MB1263"), true, false, false);
        mBeanAttributeInfoArray[39] = new MBeanAttributeInfo("TotalMsgBytesHeldInTransaction", Long.class.getName(), mbr.getString("MB1121"), true, false, false);
        mBeanAttributeInfoArray[40] = new MBeanAttributeInfo("Type", String.class.getName(), mbr.getString("MB1088"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("wildcard", String.class.getName(), mbr.getString("MB1251"));
        numWildcardConsumersSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("wildcard", String.class.getName(), mbr.getString("MB1252"));
        numWildcardProducersSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[10];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getActiveConsumerIDs", mbr.getString("MB1128"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getBackupConsumerIDs", mbr.getString("MB1129"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getConnection", mbr.getString("MB1130"), null, ObjectName.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1131"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1132"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("getWildcards", mbr.getString("MB1246"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("getConsumerWildcards", mbr.getString("MB1247"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[7] = new MBeanOperationInfo("getNumWildcardConsumers", mbr.getString("MB1248"), numWildcardConsumersSignature, Integer.class.getName(), 0);
        mBeanOperationInfoArray[8] = new MBeanOperationInfo("getProducerWildcards", mbr.getString("MB1249"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[9] = new MBeanOperationInfo("getNumWildcardProducers", mbr.getString("MB1250"), numWildcardProducersSignature, Integer.class.getName(), 0);
        ops = mBeanOperationInfoArray;
        dstNotificationTypes = new String[]{"mq.destination.compact", "mq.destination.pause", "mq.destination.purge", "mq.destination.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(dstNotificationTypes, DestinationNotification.class.getName(), mbr.getString("MB1133"));
        notifs = mBeanNotificationInfoArray;
    }
}

