/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.embeddable.client.ApplicationClientCLIEncoding;

public class AgentArguments {
    private static Pattern agentArgPattern = Pattern.compile("(?:([^=,]*?)=)?((?:\"([^\"]*)\")|[^,]+)", 32);
    private static final int KEYWORD = 1;
    private static final int QUOTED = 2;
    private static final int UNQUOTED = 3;
    private final Map<String, List<String>> values = new HashMap<String, List<String>>();

    public static AgentArguments newInstance(String args) {
        AgentArguments result = new AgentArguments();
        result.scan(args);
        return result;
    }

    public List<String> namedValues(String keyword) {
        return this.actualOrEmptyList(keyword);
    }

    public List<String> unnamedValues() {
        return this.actualOrEmptyList(null);
    }

    private List<String> actualOrEmptyList(String keyword) {
        return this.values.get(keyword) != null ? this.values.get(keyword) : Collections.emptyList();
    }

    private void scan(String args) {
        if (args == null) {
            return;
        }
        Matcher agentArgMatcher = agentArgPattern.matcher(args);
        while (agentArgMatcher.find()) {
            String keyword = agentArgMatcher.group(1);
            String value = ApplicationClientCLIEncoding.decodeArg((String)(agentArgMatcher.group(2) == null ? agentArgMatcher.group(3) : agentArgMatcher.group(2)));
            this.values.computeIfAbsent(keyword, e -> new ArrayList()).add(value);
        }
    }
}

