/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveBase;
import org.eclipse.persistence.jpa.Archive;

public class DirectoryInsideJarURLArchive
extends ArchiveBase
implements Archive {
    private JarFile jarFile;
    private String relativeRootPath;
    private List<String> entries = new ArrayList<String>();
    private Logger logger;

    public DirectoryInsideJarURLArchive(URL url, String descriptorLocation) throws IOException {
        this(url, descriptorLocation, Logger.global);
    }

    public DirectoryInsideJarURLArchive(URL url, String descriptorLocation, Logger logger) throws IOException {
        logger.entering("DirectoryInsideJarURLArchive", "DirectoryInsideJarURLArchive", new Object[]{url});
        this.logger = logger;
        assert (url.getProtocol().equals("jar"));
        this.rootURL = url;
        this.descriptorLocation = descriptorLocation;
        JarURLConnection conn = (JarURLConnection)url.openConnection();
        this.jarFile = conn.getJarFile();
        logger.logp(Level.FINER, "DirectoryInsideJarURLArchive", "DirectoryInsideJarURLArchive", "jarFile = {0}", this.jarFile);
        this.relativeRootPath = conn.getEntryName();
        this.init();
    }

    private void init() {
        Enumeration<JarEntry> jarEntries = this.jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory()) continue;
            String jarEntryName = jarEntry.getName();
            if (this.relativeRootPath == null) {
                this.entries.add(jarEntryName);
                continue;
            }
            if (!jarEntryName.startsWith(this.relativeRootPath)) continue;
            this.entries.add(jarEntryName.substring(this.relativeRootPath.length()));
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        InputStream is = this.entries.contains(entryPath) ? this.jarFile.getInputStream(this.jarFile.getEntry(this.relativeRootPath + entryPath)) : null;
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        this.rootURL = this.rootURL.toString().startsWith("jar:") ? this.rootURL : new URL("jar:" + this.rootURL);
        URL result = this.entries.contains(entryPath) ? new URL(this.rootURL + entryPath) : null;
        return result;
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

