/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.CommonResourceDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.security.common.Role;

public abstract class EjbBeanDescriptor
extends CommonResourceDescriptor
implements EjbDescriptor {
    private static final long serialVersionUID = 1L;
    private static final System.Logger LOG = System.getLogger(EjbBeanDescriptor.class.getName());
    private String ejbClassName;
    private SimpleJndiName jndiName = SimpleJndiName.of((String)"");
    private String mappedName;
    private String transactionType;
    private long uniqueId;
    private String homeClassName;
    private boolean localBean;
    private final Set<String> localBusinessClassNames;
    private String localClassName;
    private String localHomeClassName;
    private final Set<LifecycleCallbackDescriptor> postConstructDescs = new HashSet<LifecycleCallbackDescriptor>();
    private final Set<LifecycleCallbackDescriptor> preDestroyDescs = new HashSet<LifecycleCallbackDescriptor>();
    private final Set<String> remoteBusinessClassNames;
    private String remoteClassName;
    private MethodDescriptor timedObjectMethod;
    private List<MethodDescriptor> timerMethodDescriptors = new ArrayList<MethodDescriptor>();
    private List<ScheduledTimerDescriptor> timerSchedules = new ArrayList<ScheduledTimerDescriptor>();
    private RunAsIdentityDescriptor runAsIdentity;
    private Boolean usesCallerIdentity;
    private final Set<RoleReference> roleReferences = new HashSet<RoleReference>();
    private String webServiceEndpointInterfaceName;
    private WritableJndiNameEnvironment env;
    private final Set<EjbReferenceDescriptor> ejbReferences = new HashSet<EjbReferenceDescriptor>();
    private final Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryReferences = new HashSet<EntityManagerFactoryReferenceDescriptor>();
    private final Set<EntityManagerReferenceDescriptor> entityManagerReferences = new HashSet<EntityManagerReferenceDescriptor>();
    private final Set<EnvironmentProperty> environmentProperties = new HashSet<EnvironmentProperty>();
    private final Set<EjbInterceptor> allInterceptorClasses = new HashSet<EjbInterceptor>();
    private final List<EjbInterceptor> interceptorChain = new LinkedList<EjbInterceptor>();
    private final Map<MethodDescriptor, List<EjbInterceptor>> methodInterceptorsMap = new HashMap<MethodDescriptor, List<EjbInterceptor>>();
    private final Set<EjbIORConfigurationDescriptor> iorConfigDescriptors = new OrderedSet<EjbIORConfigurationDescriptor>();
    private final Set<MessageDestinationReferenceDescriptor> messageDestReferences = new HashSet<MessageDestinationReferenceDescriptor>();
    private final HashMap<MethodPermission, ArrayList<MethodDescriptor>> methodPermissionsFromDD = new HashMap();
    private final Map<MethodPermission, Set<MethodDescriptor>> permissionedMethodsByPermission = new Hashtable<MethodPermission, Set<MethodDescriptor>>();
    private Map<MethodDescriptor, Set<MethodPermission>> styledMethodDescriptors = new HashMap<MethodDescriptor, Set<MethodPermission>>();
    private final Set<ResourceEnvReferenceDescriptor> resourceEnvReferences = new HashSet<ResourceEnvReferenceDescriptor>();
    private final Set<ResourceReferenceDescriptor> resourceReferences = new HashSet<ResourceReferenceDescriptor>();
    private final Set<ServiceReferenceDescriptor> serviceReferences = new HashSet<ServiceReferenceDescriptor>();

    protected EjbBeanDescriptor() {
        this.localBusinessClassNames = new HashSet<String>();
        this.remoteBusinessClassNames = new HashSet<String>();
    }

    public EjbBeanDescriptor(EjbBeanDescriptor other) {
        super(other);
        this.jndiName = other.jndiName;
        this.homeClassName = other.homeClassName;
        this.localBean = other.localBean;
        this.localBusinessClassNames = new HashSet<String>(other.localBusinessClassNames);
        this.localClassName = other.localClassName;
        this.localHomeClassName = other.localHomeClassName;
        this.remoteBusinessClassNames = new HashSet<String>(other.remoteBusinessClassNames);
        this.remoteClassName = other.remoteClassName;
        this.webServiceEndpointInterfaceName = other.webServiceEndpointInterfaceName;
    }

    @Override
    public Application getApplication() {
        if (this.getEjbBundleDescriptor() == null) {
            return null;
        }
        return this.getEjbBundleDescriptor().getApplication();
    }

    @Override
    public final String getEjbClassName() {
        return this.ejbClassName;
    }

    public void setEjbClassName(String ejbClassName) {
        this.ejbClassName = ejbClassName;
    }

    @Override
    public SimpleJndiName getJndiName() {
        if (this.jndiName == null) {
            this.jndiName = new SimpleJndiName("");
        }
        return this.jndiName.isEmpty() ? new SimpleJndiName(this.getMappedName()) : this.jndiName;
    }

    @Override
    public void setJndiName(SimpleJndiName jndiName) {
        this.jndiName = jndiName;
        if (this.getName().isEmpty()) {
            super.setName(jndiName == null ? null : jndiName.toString());
        }
    }

    public String getMappedName() {
        return this.mappedName == null ? "" : this.mappedName;
    }

    public void setMappedName(String mappedName) {
        this.mappedName = mappedName;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public long getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(long id) {
        this.uniqueId = id;
    }

    @Override
    public boolean isRemoteInterfacesSupported() {
        return this.getHomeClassName() != null;
    }

    @Override
    public String getHomeClassName() {
        return this.homeClassName;
    }

    public void setHomeClassName(String homeClassName) {
        this.homeClassName = homeClassName;
    }

    @Override
    public boolean isLocalBean() {
        return this.localBean;
    }

    public void setLocalBean(boolean localBean) {
        this.localBean = localBean;
    }

    @Override
    public boolean isLocalBusinessInterfacesSupported() {
        return !this.localBusinessClassNames.isEmpty();
    }

    @Override
    public Set<String> getLocalBusinessClassNames() {
        return new HashSet<String>(this.localBusinessClassNames);
    }

    public void addLocalBusinessClassName(String className) {
        this.localBusinessClassNames.add(className);
    }

    @Override
    public String getLocalClassName() {
        return this.localClassName;
    }

    public void setLocalClassName(String localClassName) {
        this.localClassName = localClassName;
    }

    @Override
    public boolean isLocalInterfacesSupported() {
        return this.getLocalHomeClassName() != null;
    }

    @Override
    public final String getLocalHomeClassName() {
        return this.localHomeClassName;
    }

    public void setLocalHomeClassName(String localHomeClassName) {
        this.localHomeClassName = localHomeClassName;
    }

    @Override
    public final Set<EjbReferenceDescriptor> getEjbReferenceDescriptors() {
        if (this.env == null) {
            return this.ejbReferences;
        }
        return this.env.getEjbReferenceDescriptors();
    }

    @Override
    public EjbReferenceDescriptor getEjbReference(String name) {
        for (EjbReferenceDescriptor reference : this.getEjbReferenceDescriptors()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException(MessageFormat.format("This bean {0} has no ejb reference by the name of {1}", this.getName(), name));
    }

    @Override
    public final void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        try {
            EjbReferenceDescriptor existing = this.getEjbReference(ejbReference.getName());
            for (InjectionTarget next : ejbReference.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.env == null) {
                this.ejbReferences.add(ejbReference);
            } else {
                this.env.addEjbReferenceDescriptor(ejbReference);
            }
            ejbReference.setReferringBundleDescriptor(this.getEjbBundleDescriptor());
        }
    }

    @Override
    public final List<InjectionCapable> getInjectableResourcesByClass(String className) {
        if (this.env == null) {
            return this.getEjbBundleDescriptor().getInjectableResourcesByClass(className, this);
        }
        return this.env.getInjectableResourcesByClass(className);
    }

    @Override
    public final InjectionInfo getInjectionInfoByClass(Class<?> clazz) {
        if (this.env == null) {
            return this.getEjbBundleDescriptor().getInjectionInfoByClass(clazz, this);
        }
        return this.env.getInjectionInfoByClass(clazz);
    }

    @Override
    public final Set<MessageDestinationReferenceDescriptor> getMessageDestinationReferenceDescriptors() {
        if (this.env == null) {
            return this.messageDestReferences;
        }
        return this.env.getMessageDestinationReferenceDescriptors();
    }

    @Override
    public final void removeEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        if (this.env == null) {
            this.ejbReferences.remove(ejbReference);
        } else {
            this.env.removeEjbReferenceDescriptor(ejbReference);
        }
        ejbReference.setReferringBundleDescriptor(null);
    }

    @Override
    public final Set<EnvironmentProperty> getEnvironmentProperties() {
        if (this.env == null) {
            return this.environmentProperties;
        }
        return this.env.getEnvironmentProperties();
    }

    @Override
    public final Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
        if (this.env == null) {
            return this.entityManagerFactoryReferences;
        }
        return this.env.getEntityManagerFactoryReferenceDescriptors();
    }

    @Override
    public final EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name) {
        if (this.env != null) {
            return this.env.getEntityManagerFactoryReferenceByName(name);
        }
        for (EntityManagerFactoryReferenceDescriptor reference : this.getEntityManagerFactoryReferenceDescriptors()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException(MessageFormat.format("This ejb {0} has no entity manager factory reference by the name of {1}", this.getName(), name));
    }

    @Override
    public final void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor reference) {
        try {
            String refName = reference.getName();
            EntityManagerFactoryReferenceDescriptor existing = this.getEntityManagerFactoryReferenceByName(refName);
            for (InjectionTarget injectionTarget : reference.getInjectionTargets()) {
                existing.addInjectionTarget(injectionTarget);
            }
        }
        catch (IllegalArgumentException e) {
            EjbBundleDescriptor bundleDescriptor = this.getEjbBundleDescriptor();
            if (bundleDescriptor != null) {
                reference.setReferringBundleDescriptor(bundleDescriptor);
            }
            if (this.env == null) {
                this.entityManagerFactoryReferences.add(reference);
            }
            this.env.addEntityManagerFactoryReferenceDescriptor(reference);
        }
    }

    @Override
    public final Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        if (this.env == null) {
            return this.entityManagerReferences;
        }
        return this.env.getEntityManagerReferenceDescriptors();
    }

    @Override
    public final EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name) throws IllegalArgumentException {
        if (this.env != null) {
            return this.env.getEntityManagerReferenceByName(name);
        }
        for (EntityManagerReferenceDescriptor reference : this.getEntityManagerReferenceDescriptors()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException(MessageFormat.format("This ejb {0} has no entity manager reference by the name of {1}", this.getName(), name));
    }

    @Override
    public final void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor reference) {
        try {
            EntityManagerReferenceDescriptor existing = this.getEntityManagerReferenceByName(reference.getName());
            for (InjectionTarget next : reference.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.getEjbBundleDescriptor() != null) {
                reference.setReferringBundleDescriptor(this.getEjbBundleDescriptor());
            }
            if (this.env == null) {
                this.getEntityManagerReferenceDescriptors().add(reference);
            }
            this.env.addEntityManagerReferenceDescriptor(reference);
        }
    }

    @Override
    public final EnvironmentProperty getEnvironmentPropertyByName(String name) {
        if (this.env != null) {
            return this.env.getEnvironmentPropertyByName(name);
        }
        for (EnvironmentProperty property : this.getEnvironmentProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        throw new IllegalArgumentException(MessageFormat.format("This bean {0} has no environment property by the name of {1}", this.getName(), name));
    }

    @Override
    public final void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        if (this.env != null) {
            this.env.addEnvironmentProperty(environmentProperty);
            return;
        }
        if (this.environmentProperties.contains(environmentProperty)) {
            this.removeEnvironmentProperty(environmentProperty);
            this.addEnvironmentProperty(environmentProperty);
        } else {
            this.environmentProperties.add(environmentProperty);
        }
    }

    @Override
    public final void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        if (this.env == null) {
            this.getEnvironmentProperties().remove(environmentProperty);
        } else {
            this.env.removeEnvironmentProperty(environmentProperty);
        }
    }

    public Set<String> getInterceptorClassNames() {
        HashSet<String> classNames = new HashSet<String>();
        for (EjbInterceptor interceptor : this.getInterceptorClasses()) {
            classNames.add(interceptor.getInterceptorClassName());
        }
        return classNames;
    }

    public Set<EjbInterceptor> getInterceptorClasses() {
        return new HashSet<EjbInterceptor>(this.allInterceptorClasses);
    }

    @Override
    public boolean hasInterceptorClass(String interceptorClassName) {
        for (String interceptor : this.getInterceptorClassNames()) {
            if (!interceptor.equals(interceptorClassName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addInterceptorClass(EjbInterceptor interceptor) {
        this.allInterceptorClasses.add(interceptor);
    }

    protected void setInterceptorClasses(Collection<EjbInterceptor> classes) {
        this.allInterceptorClasses.clear();
        this.allInterceptorClasses.addAll(classes);
    }

    public final List<EjbInterceptor> getInterceptorChain() {
        return new LinkedList<EjbInterceptor>(this.interceptorChain);
    }

    @Override
    public void appendToInterceptorChain(List<EjbInterceptor> chain) {
        this.interceptorChain.addAll(chain);
    }

    protected void setInterceptorChain(List<EjbInterceptor> interceptors) {
        this.interceptorChain.clear();
        this.interceptorChain.addAll(interceptors);
    }

    public final Map<MethodDescriptor, List<EjbInterceptor>> getMethodInterceptorsMap() {
        return new HashMap<MethodDescriptor, List<EjbInterceptor>>(this.methodInterceptorsMap);
    }

    protected void setMethodInterceptorsMap(Map<MethodDescriptor, List<EjbInterceptor>> map) {
        this.methodInterceptorsMap.clear();
        this.methodInterceptorsMap.putAll(map);
    }

    @Override
    public Set<EjbIORConfigurationDescriptor> getIORConfigurationDescriptors() {
        return this.iorConfigDescriptors;
    }

    public void addIORConfigurationDescriptor(EjbIORConfigurationDescriptor val) {
        this.iorConfigDescriptors.add(val);
    }

    @Override
    public final MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        if (this.env != null) {
            return this.env.getMessageDestinationReferenceByName(name);
        }
        for (MessageDestinationReferenceDescriptor mdr : this.messageDestReferences) {
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        throw new IllegalArgumentException(MessageFormat.format("This ejb [{0}] has no message destination reference by the name of [{1}]", this.getName(), name));
    }

    @Override
    public final void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        block5: {
            try {
                MessageDestinationReferenceDescriptor existing = this.getMessageDestinationReferenceByName(messageDestRef.getName());
                for (InjectionTarget injectionTarget : messageDestRef.getInjectionTargets()) {
                    existing.addInjectionTarget(injectionTarget);
                }
            }
            catch (IllegalArgumentException e) {
                if (this.env == null) {
                    this.messageDestReferences.add(messageDestRef);
                } else {
                    this.env.addMessageDestinationReferenceDescriptor(messageDestRef);
                }
                if (this.getEjbBundleDescriptor() == null) break block5;
                messageDestRef.setReferringBundleDescriptor(this.getEjbBundleDescriptor());
            }
        }
    }

    @Override
    public final void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        if (this.env == null) {
            this.messageDestReferences.remove(msgDestRef);
        } else {
            this.env.removeMessageDestinationReferenceDescriptor(msgDestRef);
        }
    }

    public final HashMap<MethodPermission, ArrayList<MethodDescriptor>> getMethodPermissionsFromDD() {
        return this.methodPermissionsFromDD;
    }

    @Override
    public Set<MethodDescriptor> getMethodDescriptors() {
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        Set<MethodDescriptor> methods = this.getBusinessMethodDescriptors();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getHomeClassName()), "Home");
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getLocalHomeClassName()), "LocalHome");
            }
        }
        catch (Exception t) {
            throw new RuntimeException(this.getEjbClassName(), t);
        }
        return methods;
    }

    @Override
    public Set<MethodPermission> getMethodPermissionsFor(MethodDescriptor methodDescriptor) {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        return this.getMethodPermissions(methodDescriptor);
    }

    @Override
    public Set<Role> getPermissionedRoles() {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        HashSet<Role> allPermissionedRoles = new HashSet<Role>();
        for (MethodPermission pm : this.getPermissionedMethodsByPermission().keySet()) {
            if (!pm.isRoleBased()) continue;
            allPermissionedRoles.add(pm.getRole());
        }
        return allPermissionedRoles;
    }

    public Set<MethodDescriptor> getDenyAllMethodPermission() {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        Map<MethodPermission, Set<MethodDescriptor>> all = this.getPermissionedMethodsByPermission();
        LOG.log(System.Logger.Level.INFO, "getDenyAllMethodPermission, all: \n{0}", all);
        return all.get((Object)MethodPermission.getDenyAllMethodPermission());
    }

    public Set<MethodDescriptor> getPermitAllMethodDescriptors() {
        if (this.needToConvertMethodPermissions()) {
            this.convertMethodPermissions();
        }
        Map<MethodPermission, Set<MethodDescriptor>> all = this.getPermissionedMethodsByPermission();
        LOG.log(System.Logger.Level.INFO, "getPermitAllMethodDescriptors, all: \n{0}", all);
        return all.get((Object)MethodPermission.getPermitAllMethodPermission());
    }

    @Override
    public void addPermissionedMethod(MethodPermission mp, MethodDescriptor md) {
        LOG.log(System.Logger.Level.DEBUG, "addPermissionedMethod {0}: {1}", new Object[]{mp, md});
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException("Cannot add roles when the descriptor is not part of a bundle");
        }
        if (mp.isRoleBased() && !this.getEjbBundleDescriptor().getRoles().contains(mp.getRole()) && !"**".equals(mp.getRole().getName())) {
            throw new IllegalArgumentException("Cannot add roles when the bundle does not have them");
        }
        if (md.isExact()) {
            this.updateMethodPermissionForMethod(mp, md);
        } else {
            this.addMethodPermissionForStyledMethodDescriptor(mp, md);
        }
        this.saveMethodPermissionFromDD(mp, md);
    }

    public void removePermissionedMethod(MethodPermission mp, MethodDescriptor md) {
        if (this.getEjbBundleDescriptor() == null) {
            throw new IllegalArgumentException("Cannot add roles when the descriptor is not part of a bundle");
        }
        if (mp.isRoleBased() && !this.getEjbBundleDescriptor().getRoles().contains(mp.getRole())) {
            throw new IllegalArgumentException("Cannot add roles when the bundle does not have them");
        }
        if (this.getPermissionedMethodsByPermission().containsKey((Object)mp)) {
            Set<MethodDescriptor> alreadyPermissionedMethodsForThisRole = this.getPermissionedMethodsByPermission().get((Object)mp);
            alreadyPermissionedMethodsForThisRole.remove((Object)md);
            this.getPermissionedMethodsByPermission().put(mp, alreadyPermissionedMethodsForThisRole);
        }
    }

    @Override
    public Set<MethodDescriptor> getSecurityBusinessMethodDescriptors() {
        return this.getBusinessMethodDescriptors();
    }

    public Map<MethodPermission, Set<MethodDescriptor>> getStyledPermissionedMethodsByPermission() {
        if (this.styledMethodDescriptors == null) {
            return null;
        }
        HashMap<MethodPermission, Set<MethodDescriptor>> styledMethodDescriptorsByPermission = new HashMap<MethodPermission, Set<MethodDescriptor>>();
        for (Map.Entry<MethodDescriptor, Set<MethodPermission>> md : this.styledMethodDescriptors.entrySet()) {
            Set<MethodPermission> methodPermissions = md.getValue();
            for (MethodPermission mp : methodPermissions) {
                HashSet<MethodDescriptor> methodDescriptors = (HashSet<MethodDescriptor>)styledMethodDescriptorsByPermission.get((Object)mp);
                if (methodDescriptors == null) {
                    methodDescriptors = new HashSet<MethodDescriptor>();
                }
                methodDescriptors.add(md.getKey());
                styledMethodDescriptorsByPermission.put(mp, methodDescriptors);
            }
        }
        return styledMethodDescriptorsByPermission;
    }

    private boolean needToConvertMethodPermissions() {
        return this.styledMethodDescriptors != null;
    }

    private Set<MethodDescriptor> getBusinessMethodDescriptors() {
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        Set<MethodDescriptor> methods = this.getLocalRemoteBusinessMethodDescriptors();
        try {
            if (this.hasWebServiceEndpointInterface()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getWebServiceEndpointInterfaceName()), "ServiceEndpoint");
            }
        }
        catch (Exception t) {
            throw new RuntimeException(this.getEjbClassName(), t);
        }
        return methods;
    }

    protected void addAllInterfaceMethodsIn(Collection<MethodDescriptor> methodDescriptors, Class<?> c, String methodIntf) {
        Method[] methods;
        for (Method method : methods = c.getMethods()) {
            if (method.getDeclaringClass() == Object.class) continue;
            methodDescriptors.add(new MethodDescriptor(method, methodIntf));
        }
    }

    private Set<MethodDescriptor> getLocalRemoteBusinessMethodDescriptors() {
        ClassLoader classLoader = this.getEjbBundleDescriptor().getClassLoader();
        HashSet<MethodDescriptor> methods = new HashSet<MethodDescriptor>();
        try {
            if (this.isRemoteInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getRemoteClassName()), "Remote");
            }
            if (this.isRemoteBusinessInterfacesSupported()) {
                for (String intf : this.getRemoteBusinessClassNames()) {
                    this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf), "Remote");
                }
            }
            if (this.isLocalInterfacesSupported()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getLocalClassName()), "Local");
            }
            if (this.isLocalBusinessInterfacesSupported()) {
                for (String intf : this.getLocalBusinessClassNames()) {
                    this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf), "Local");
                }
            }
            if (this.isLocalBean()) {
                this.addAllInterfaceMethodsIn(methods, classLoader.loadClass(this.getEjbClassName()), "Local");
            }
        }
        catch (Exception t) {
            throw new RuntimeException(this.getEjbClassName(), t);
        }
        return methods;
    }

    private void convertMethodPermissions() {
        if (this.styledMethodDescriptors == null) {
            return;
        }
        Set<MethodDescriptor> allMethods = this.getMethodDescriptors();
        Set<MethodDescriptor> unpermissionedMethods = this.getMethodDescriptors();
        Set<Map.Entry<MethodDescriptor, Set<MethodPermission>>> methodDescriptors = this.styledMethodDescriptors.entrySet();
        for (Map.Entry<MethodDescriptor, Set<MethodPermission>> entry : methodDescriptors) {
            MethodDescriptor styledMd = entry.getKey();
            Set<MethodPermission> newPermissions = entry.getValue();
            Vector<MethodDescriptor> mds = styledMd.doStyleConversion(this, allMethods);
            for (MethodDescriptor md : mds) {
                unpermissionedMethods.remove((Object)md);
                for (MethodPermission newMp : newPermissions) {
                    this.updateMethodPermissionForMethod(newMp, md);
                }
            }
        }
        MethodPermission permitAll = MethodPermission.getPermitAllMethodPermission();
        for (MethodDescriptor md : unpermissionedMethods) {
            if (!this.getMethodPermissions(md).isEmpty()) continue;
            this.addMethodPermissionForMethod(permitAll, md);
        }
        this.styledMethodDescriptors = null;
    }

    private void updateMethodPermissionForMethod(MethodPermission mp, MethodDescriptor md) {
        Set<MethodPermission> oldPermissions = this.getMethodPermissions(md);
        if (oldPermissions.isEmpty()) {
            this.addMethodPermissionForMethod(mp, md);
            return;
        }
        if (mp.isExcluded()) {
            for (MethodPermission oldMp : oldPermissions) {
                this.removePermissionedMethod(oldMp, md);
            }
            this.addMethodPermissionForMethod(mp, md);
            return;
        }
        if (mp.isUnchecked()) {
            for (MethodPermission oldMp : oldPermissions) {
                if (oldMp.isExcluded()) continue;
                this.removePermissionedMethod(oldMp, md);
                this.addMethodPermissionForMethod(mp, md);
            }
            return;
        }
        for (MethodPermission oldMp : oldPermissions) {
            if (oldMp.isExcluded() || oldMp.isUnchecked()) continue;
            this.addMethodPermissionForMethod(mp, md);
        }
    }

    private Set<MethodPermission> getMethodPermissions(MethodDescriptor methodDescriptor) {
        HashSet<MethodPermission> methodPermissionsForMethod = new HashSet<MethodPermission>();
        for (MethodPermission nextPermission : this.getPermissionedMethodsByPermission().keySet()) {
            Set<MethodDescriptor> permissionedMethods = this.getPermissionedMethodsByPermission().get((Object)nextPermission);
            for (MethodDescriptor md : permissionedMethods) {
                if (!md.equals((Object)methodDescriptor)) continue;
                methodPermissionsForMethod.add(nextPermission);
            }
        }
        return methodPermissionsForMethod;
    }

    private void addMethodPermissionForMethod(MethodPermission mp, MethodDescriptor md) {
        if (this.getPermissionedMethodsByPermission().containsKey((Object)mp)) {
            Set<MethodDescriptor> alreadyPermissionedMethodsForThisRole = this.getPermissionedMethodsByPermission().get((Object)mp);
            alreadyPermissionedMethodsForThisRole.add(md);
            this.getPermissionedMethodsByPermission().put(mp, alreadyPermissionedMethodsForThisRole);
        } else {
            HashSet<MethodDescriptor> permissionedMethodsForThisRole = new HashSet<MethodDescriptor>();
            permissionedMethodsForThisRole.add(md);
            this.getPermissionedMethodsByPermission().put(mp, permissionedMethodsForThisRole);
        }
    }

    private void addMethodPermissionForStyledMethodDescriptor(MethodPermission mp, MethodDescriptor md) {
        Set<MethodPermission> permissions;
        if (this.styledMethodDescriptors == null) {
            this.styledMethodDescriptors = new HashMap<MethodDescriptor, Set<MethodPermission>>();
        }
        if ((permissions = this.styledMethodDescriptors.get((Object)md)) == null) {
            permissions = new HashSet<MethodPermission>();
        }
        permissions.add(mp);
        this.styledMethodDescriptors.put(md, permissions);
    }

    private void saveMethodPermissionFromDD(MethodPermission methodPermission, MethodDescriptor methodDescriptor) {
        LOG.log(System.Logger.Level.DEBUG, "saveMethodPermissionFromDD {0}: {1}", new Object[]{methodPermission, methodDescriptor});
        this.methodPermissionsFromDD.computeIfAbsent(methodPermission, e -> new ArrayList()).add(methodDescriptor);
    }

    @Override
    public final Map<MethodPermission, Set<MethodDescriptor>> getPermissionedMethodsByPermission() {
        return this.permissionedMethodsByPermission;
    }

    @Override
    public final Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        return this.postConstructDescs;
    }

    @Override
    public final void addPostConstructDescriptor(LifecycleCallbackDescriptor postConstructDesc) {
        String className = postConstructDesc.getLifecycleCallbackClass();
        for (LifecycleCallbackDescriptor callback : this.postConstructDescs) {
            if (!callback.getLifecycleCallbackClass().equals(className)) continue;
            return;
        }
        this.postConstructDescs.add(postConstructDesc);
    }

    @Override
    public final LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        return this.getEjbBundleDescriptor().getPostConstructDescriptorByClass(className, this);
    }

    @Override
    public final Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        return this.preDestroyDescs;
    }

    @Override
    public final LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        return this.getEjbBundleDescriptor().getPreDestroyDescriptorByClass(className, this);
    }

    @Override
    public final void addPreDestroyDescriptor(LifecycleCallbackDescriptor preDestroyDesc) {
        String className = preDestroyDesc.getLifecycleCallbackClass();
        for (LifecycleCallbackDescriptor callback : this.preDestroyDescs) {
            if (!callback.getLifecycleCallbackClass().equals(className)) continue;
            return;
        }
        this.preDestroyDescs.add(preDestroyDesc);
    }

    @Override
    public boolean allMechanismsRequireSSL() {
        if (this.iorConfigDescriptors == null || this.iorConfigDescriptors.isEmpty()) {
            return false;
        }
        for (EjbIORConfigurationDescriptor iorDesc : this.iorConfigDescriptors) {
            if ("REQUIRED".equalsIgnoreCase(iorDesc.getConfidentiality()) || "REQUIRED".equalsIgnoreCase(iorDesc.getConfidentiality()) || "REQUIRED".equalsIgnoreCase(iorDesc.getEstablishTrustInTarget()) || "REQUIRED".equalsIgnoreCase(iorDesc.getEstablishTrustInClient())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRemoteBusinessInterfacesSupported() {
        return !this.remoteBusinessClassNames.isEmpty();
    }

    @Override
    public Set<String> getRemoteBusinessClassNames() {
        return new HashSet<String>(this.remoteBusinessClassNames);
    }

    public void addRemoteBusinessClassName(String className) {
        this.remoteBusinessClassNames.add(className);
    }

    @Override
    public String getRemoteClassName() {
        return this.remoteClassName;
    }

    public void setRemoteClassName(String remoteClassName) {
        this.remoteClassName = remoteClassName;
    }

    @Override
    public final Set<ResourceDescriptor> getAllResourcesDescriptors() {
        if (this.env == null) {
            return super.getAllResourcesDescriptors();
        }
        return this.env.getAllResourcesDescriptors();
    }

    @Override
    public final Set<ResourceDescriptor> getAllResourcesDescriptors(Class<?> givenClazz) {
        if (this.env == null) {
            return super.getAllResourcesDescriptors(givenClazz);
        }
        return this.env.getAllResourcesDescriptors(givenClazz);
    }

    @Override
    public final Set<ResourceDescriptor> getResourceDescriptors(JavaEEResourceType type) {
        if (this.env == null) {
            return super.getResourceDescriptors(type);
        }
        return this.env.getResourceDescriptors(type);
    }

    @Override
    public final void addResourceDescriptor(ResourceDescriptor descriptor) {
        if (this.env == null) {
            super.addResourceDescriptor(descriptor);
        } else {
            this.env.addResourceDescriptor(descriptor);
        }
    }

    @Override
    public final void removeResourceDescriptor(ResourceDescriptor descriptor) {
        if (this.env == null) {
            super.removeResourceDescriptor(descriptor);
        } else {
            this.env.removeResourceDescriptor(descriptor);
        }
    }

    @Override
    public final Set<ResourceEnvReferenceDescriptor> getResourceEnvReferenceDescriptors() {
        if (this.env == null) {
            return this.resourceEnvReferences;
        }
        return this.env.getResourceEnvReferenceDescriptors();
    }

    @Override
    public final ResourceEnvReferenceDescriptor getResourceEnvReferenceByName(String name) {
        for (ResourceEnvReferenceDescriptor jdr : this.getResourceEnvReferenceDescriptors()) {
            if (!jdr.getName().equals(name)) continue;
            return jdr;
        }
        throw new IllegalArgumentException(MessageFormat.format("This bean {0} has no resource environment reference by the name of {1}", this.getName(), name));
    }

    @Override
    public final void addResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvReference) {
        try {
            ResourceEnvReferenceDescriptor existing = this.getResourceEnvReferenceByName(resourceEnvReference.getName());
            for (InjectionTarget injectionTarget : resourceEnvReference.getInjectionTargets()) {
                existing.addInjectionTarget(injectionTarget);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.env == null) {
                this.resourceEnvReferences.add(resourceEnvReference);
            }
            this.env.addResourceEnvReferenceDescriptor(resourceEnvReference);
        }
    }

    @Override
    public final void removeResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvReference) {
        if (this.env == null) {
            this.resourceEnvReferences.remove(resourceEnvReference);
        } else {
            this.env.removeResourceEnvReferenceDescriptor(resourceEnvReference);
        }
    }

    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors(boolean resolved) {
        HashSet<ResourceReferenceDescriptor> toReturn = new HashSet<ResourceReferenceDescriptor>();
        for (ResourceReferenceDescriptor reference : this.getResourceReferenceDescriptors()) {
            if (reference.isResolved() != resolved) continue;
            toReturn.add(reference);
        }
        return toReturn;
    }

    @Override
    public final Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        if (this.env == null) {
            return this.resourceReferences;
        }
        return this.env.getResourceReferenceDescriptors();
    }

    @Override
    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        for (ResourceReferenceDescriptor reference : this.getResourceReferenceDescriptors()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException(MessageFormat.format("This bean {0} has no resource reference by the name of {1}", this.getName(), name));
    }

    @Override
    public final void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        try {
            ResourceReferenceDescriptor existing = this.getResourceReferenceByName(resourceReference.getName());
            for (InjectionTarget next : resourceReference.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.env == null) {
                this.resourceReferences.add(resourceReference);
            }
            this.env.addResourceReferenceDescriptor(resourceReference);
        }
    }

    @Override
    public final void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        if (this.env == null) {
            this.resourceReferences.remove(resourceReference);
        } else {
            this.env.removeResourceReferenceDescriptor(resourceReference);
        }
    }

    @Override
    public Boolean getUsesCallerIdentity() {
        return this.usesCallerIdentity;
    }

    @Override
    public void setUsesCallerIdentity(boolean flag) {
        this.usesCallerIdentity = flag;
    }

    @Override
    public void setRunAsIdentity(RunAsIdentityDescriptor desc) {
        if (this.usesCallerIdentity == null || this.usesCallerIdentity.booleanValue()) {
            throw new IllegalStateException("Cannot set RunAs identity when using caller identity. Set usesCallerIdentity to false first.");
        }
        this.runAsIdentity = desc;
    }

    @Override
    public RunAsIdentityDescriptor getRunAsIdentity() {
        return this.runAsIdentity;
    }

    @Override
    public final Set<RoleReference> getRoleReferences() {
        return this.roleReferences;
    }

    @Override
    public RoleReference getRoleReferenceByName(String roleReferenceName) {
        for (RoleReference nextRR : this.roleReferences) {
            if (!nextRR.getName().equals(roleReferenceName)) continue;
            return nextRR;
        }
        return null;
    }

    @Override
    public void addRoleReference(RoleReference roleReference) {
        this.roleReferences.add(roleReference);
    }

    @Override
    public void removeRole(Role role) {
        this.getPermissionedMethodsByPermission().remove((Object)new MethodPermission(role));
        HashSet<RoleReference> refs = new HashSet<RoleReference>(this.roleReferences);
        for (RoleReference roleReference : refs) {
            if (!roleReference.getRole().equals((Object)role)) continue;
            roleReference.setValue("");
        }
    }

    public void removeRoleReference(RoleReference roleReference) {
        this.roleReferences.remove(roleReference);
    }

    @Override
    public final Set<ServiceReferenceDescriptor> getServiceReferenceDescriptors() {
        if (this.env == null) {
            return this.serviceReferences;
        }
        return this.env.getServiceReferenceDescriptors();
    }

    @Override
    public final ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        if (this.env != null) {
            return this.env.getServiceReferenceByName(name);
        }
        for (ServiceReferenceDescriptor srd : this.serviceReferences) {
            if (!srd.getName().equals(name)) continue;
            return srd;
        }
        throw new IllegalArgumentException(MessageFormat.format("This ejb [{0}] has no service reference by the name of [{1}]", this.getName(), name));
    }

    @Override
    public final void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        try {
            ServiceReferenceDescriptor existing = this.getServiceReferenceByName(serviceRef.getName());
            for (InjectionTarget next : serviceRef.getInjectionTargets()) {
                existing.addInjectionTarget(next);
            }
        }
        catch (IllegalArgumentException e) {
            if (this.env == null) {
                this.serviceReferences.add(serviceRef);
            } else {
                this.env.addServiceReferenceDescriptor(serviceRef);
            }
            serviceRef.setBundleDescriptor(this.getEjbBundleDescriptor());
        }
    }

    @Override
    public final void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        if (this.env == null) {
            this.serviceReferences.remove(serviceRef);
        } else {
            this.env.removeServiceReferenceDescriptor(serviceRef);
        }
    }

    public boolean isTimedObject() {
        return this.timedObjectMethod != null || !this.timerSchedules.isEmpty();
    }

    public MethodDescriptor getEjbTimeoutMethod() {
        return this.timedObjectMethod;
    }

    public void setEjbTimeoutMethod(MethodDescriptor method) {
        this.timedObjectMethod = method;
    }

    public List<ScheduledTimerDescriptor> getScheduledTimerDescriptors() {
        return this.timerSchedules;
    }

    public void addScheduledTimerDescriptor(ScheduledTimerDescriptor scheduleDescriptor) {
        this.timerSchedules.add(scheduleDescriptor);
    }

    public void addScheduledTimerDescriptorFromDD(ScheduledTimerDescriptor scheduleDescriptor) {
        this.timerMethodDescriptors.add(scheduleDescriptor.getTimeoutMethod());
        this.timerSchedules.add(scheduleDescriptor);
    }

    public boolean hasScheduledTimerMethodFromDD(Method timerMethod) {
        for (MethodDescriptor descriptor : this.timerMethodDescriptors) {
            if (!descriptor.getName().equals(timerMethod.getName()) || descriptor.getParameterClassNames() != null && descriptor.getParameterClassNames().length != timerMethod.getParameterTypes().length) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public Set<MethodDescriptor> getTxBusinessMethodDescriptors() {
        Set<MethodDescriptor> txBusMethods = this.getBusinessMethodDescriptors();
        if (this.isTimedObject() && this.timedObjectMethod != null) {
            txBusMethods.add(this.timedObjectMethod);
        }
        return txBusMethods;
    }

    @Override
    public final boolean hasWebServiceEndpointInterface() {
        return this.getWebServiceEndpointInterfaceName() != null;
    }

    @Override
    public final String getWebServiceEndpointInterfaceName() {
        return this.webServiceEndpointInterfaceName;
    }

    @Override
    public final void setWebServiceEndpointInterfaceName(String name) {
        this.webServiceEndpointInterfaceName = name;
    }

    @Override
    public void addMethodLevelChain(List<EjbInterceptor> chain, Method m, boolean aroundInvoke) {
        if (chain.isEmpty()) {
            return;
        }
        MethodDescriptor methodDesc = new MethodDescriptor(m);
        List<EjbInterceptor> existingChain = null;
        for (MethodDescriptor next : this.methodInterceptorsMap.keySet()) {
            if (!next.implies((Object)methodDesc)) continue;
            existingChain = this.methodInterceptorsMap.get((Object)methodDesc);
            break;
        }
        if (existingChain != null) {
            existingChain.addAll(chain);
            return;
        }
        LinkedList<EjbInterceptor> newChain = new LinkedList<EjbInterceptor>();
        for (EjbInterceptor interceptor : this.interceptorChain) {
            boolean include = aroundInvoke ? interceptor.hasAroundInvokeDescriptor() : interceptor.hasAroundTimeoutDescriptor();
            if (!include) continue;
            newChain.add(interceptor);
        }
        newChain.addAll(chain);
        this.methodInterceptorsMap.put(methodDesc, newChain);
    }

    @Override
    public void notifyNewModule(WebBundleDescriptor wbd) {
        wbd.addJndiNameEnvironment(this);
        this.environmentProperties.clear();
        this.ejbReferences.clear();
        this.resourceEnvReferences.clear();
        this.messageDestReferences.clear();
        this.resourceReferences.clear();
        this.serviceReferences.clear();
        this.entityManagerFactoryReferences.clear();
        this.entityManagerReferences.clear();
        this.env = wbd;
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n jndiName=").append(this.jndiName);
        toStringBuffer.append("\n ejbClassName=").append(this.ejbClassName);
        toStringBuffer.append("\n homeClassName=").append(this.homeClassName);
        toStringBuffer.append("\n isLocalBean=").append(this.isLocalBean()).append("\n");
        toStringBuffer.append("\n localBusinessIntfs=").append(this.localBusinessClassNames);
        toStringBuffer.append("\n localClassName=").append(this.localClassName);
        toStringBuffer.append("\n localHomeClassName=").append(this.localHomeClassName);
        toStringBuffer.append("\n remoteBusinessIntfs=").append(this.remoteBusinessClassNames);
        toStringBuffer.append("\n remoteClassName=").append(this.remoteClassName);
        toStringBuffer.append("\n transactionType=").append(this.transactionType);
        toStringBuffer.append("\n ejbReferences=");
        EjbBeanDescriptor.printDescriptorSet(this.ejbReferences, toStringBuffer);
        toStringBuffer.append("\n environmentProperties=");
        EjbBeanDescriptor.printDescriptorSet(this.environmentProperties, toStringBuffer);
        toStringBuffer.append("\n messageDestReferences=");
        EjbBeanDescriptor.printDescriptorSet(this.messageDestReferences, toStringBuffer);
        toStringBuffer.append("\n resourceEnvReferences=");
        EjbBeanDescriptor.printDescriptorSet(this.resourceEnvReferences, toStringBuffer);
        toStringBuffer.append("\n resourceReferences=");
        EjbBeanDescriptor.printDescriptorSet(this.resourceReferences, toStringBuffer);
        toStringBuffer.append("\n roleReferences=");
        EjbBeanDescriptor.printDescriptorSet(this.roleReferences, toStringBuffer);
        toStringBuffer.append("\n serviceReferences=");
        EjbBeanDescriptor.printDescriptorSet(this.serviceReferences, toStringBuffer);
    }

    protected static void copyEjbDescriptor(EjbBeanDescriptor source, EjbBeanDescriptor target) {
        target.ejbClassName = source.ejbClassName;
        target.transactionType = source.transactionType;
        target.roleReferences.addAll(source.getRoleReferences());
        target.permissionedMethodsByPermission.putAll(source.getPermissionedMethodsByPermission());
        if (target.env == null) {
            target.getEnvironmentProperties().addAll(source.getEnvironmentProperties());
            target.getEjbReferenceDescriptors().addAll(source.getEjbReferenceDescriptors());
            target.getResourceEnvReferenceDescriptors().addAll(source.getResourceEnvReferenceDescriptors());
            target.getMessageDestinationReferenceDescriptors().addAll(source.getMessageDestinationReferenceDescriptors());
            target.getResourceReferenceDescriptors().addAll(source.getResourceReferenceDescriptors());
            target.getServiceReferenceDescriptors().addAll(source.getServiceReferenceDescriptors());
            Set<ResourceDescriptor> allResources = source.getAllResourcesDescriptors();
            if (!allResources.isEmpty()) {
                for (ResourceDescriptor resource : allResources) {
                    source.addResourceDescriptor(resource);
                }
            }
            target.getEntityManagerFactoryReferenceDescriptors().addAll(source.getEntityManagerFactoryReferenceDescriptors());
            target.getEntityManagerReferenceDescriptors().addAll(source.getEntityManagerReferenceDescriptors());
        }
        target.timerMethodDescriptors = new ArrayList<MethodDescriptor>(source.timerMethodDescriptors);
        target.timerSchedules = new ArrayList<ScheduledTimerDescriptor>(source.timerSchedules);
        target.usesCallerIdentity = source.usesCallerIdentity;
        target.getIORConfigurationDescriptors().addAll(source.getIORConfigurationDescriptors());
    }

    private static void printDescriptorSet(Set<? extends Descriptor> descSet, StringBuffer sbuf) {
        for (Descriptor descriptor : descSet) {
            descriptor.print(sbuf);
        }
    }
}

