/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import jakarta.security.auth.message.AuthException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.epicyro.config.factory.ConfigParser;

public class ObjectUtils {
    private static final Logger logger = Logger.getLogger(ObjectUtils.class.getName());
    private static final Class<?>[] EMPTY_PARAMS = new Class[0];
    private static final Object[] EMPTY_ARGS = new Object[0];

    public static <T> T createObject(String className) {
        ClassLoader loader = ObjectUtils.getClassLoader();
        if (System.getSecurityManager() != null) {
            try {
                return (T)AccessController.doPrivileged(() -> Class.forName(className, true, loader).newInstance());
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException(pae.getException());
            }
        }
        try {
            return (T)Class.forName(className, true, loader).newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static ConfigParser newConfigParser(String parserClassName) throws IOException {
        return ObjectUtils.newConfigParser(parserClassName, null);
    }

    public static ConfigParser newConfigParser(String parserClassName, Object config) throws IOException {
        if (parserClassName == null) {
            return null;
        }
        ConfigParser newParser = (ConfigParser)ObjectUtils.createObject(parserClassName);
        newParser.initialize(config);
        return newParser;
    }

    public static Object newAuthModule(String moduleClassName) throws AuthException {
        return ObjectUtils.newAuthModule(moduleClassName, EMPTY_PARAMS, EMPTY_ARGS);
    }

    public static Object newAuthModule(String moduleClassName, Class<?>[] parameterTypes, Object[] initargs) throws AuthException {
        try {
            return Class.forName(moduleClassName, true, ObjectUtils.getClassLoader()).getConstructor(parameterTypes).newInstance(initargs);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "jaspic.provider_unable_to_load_authmodule", new String[]{moduleClassName, e.toString()});
            }
            throw (AuthException)new AuthException().initCause((Throwable)e);
        }
    }

    public static ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

