/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import com.sun.jdo.api.persistence.enhancer.util.ClassPathElement;
import com.sun.jdo.api.persistence.enhancer.util.ZipFileClassPackageEnumerator;
import com.sun.jdo.api.persistence.enhancer.util.ZipFileRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ZipFileClassPathElement
extends ClassPathElement {
    private File zipFileElement;
    private ZipFile zipFile;

    @Override
    public ClassFileSource sourceOf(String className) {
        ZipEntry entry;
        if (this.zipFile != null && (entry = this.zipFile.getEntry(ClassPath.zipFileNameOf(className))) != null) {
            return new ClassFileSource(className, this.zipFile);
        }
        return null;
    }

    @Override
    public Enumeration classesInPackage(String packageName) {
        if (this.zipFile == null) {
            return null;
        }
        return new ZipFileClassPackageEnumerator(this.zipFile, packageName);
    }

    @Override
    boolean matches(File directory) {
        return false;
    }

    ZipFileClassPathElement(File elementSpec) {
        this.zipFileElement = elementSpec;
        this.checkValid();
    }

    private void checkValid() {
        if (ZipFileClassPathElement.looksLikeZipName(this.zipFileElement.getPath()) && this.zipFileElement.isFile()) {
            try {
                this.zipFile = ZipFileRegistry.openZipFile(this.zipFileElement);
            }
            catch (IOException e) {
                System.err.println("IO exception while reading " + this.zipFileElement.getPath());
                this.zipFile = null;
            }
        }
    }
}

