/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jdke.i18n;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;

public class LocalStringsImpl {
    private static final boolean LOG_ERRORS = Boolean.parseBoolean(System.getenv("AS_LOG_I18N_ERRORS"));
    private static final String LOG_TARGET_FILE = System.getenv("AS_LOG_I18N_LOG_FILE");
    private static final PrintStream LOG_TARGET;
    private static final String thisPackage = "com.elf.util";
    private static final ResourceBundle.Control rbcontrol;
    private final ResourceBundle bundle;

    public LocalStringsImpl(Class clazz) {
        this.bundle = LocalStringsImpl.load(clazz);
    }

    private static ResourceBundle load(Class clazz) {
        String className = clazz.getName();
        String props = className.substring(0, className.lastIndexOf(46)) + ".LocalStrings";
        try {
            return ResourceBundle.getBundle(props, Locale.getDefault(), clazz.getModule());
        }
        catch (Exception e) {
            if (LOG_ERRORS) {
                LOG_TARGET.println("Could not find resource bundle: " + props);
                e.printStackTrace(LOG_TARGET);
            }
            return null;
        }
    }

    public String get(String key) {
        try {
            return this.getBundle().getString(key);
        }
        catch (Exception e) {
            if (LOG_ERRORS) {
                LOG_TARGET.println("Could not resolve: " + key);
                e.printStackTrace(LOG_TARGET);
            }
            return key;
        }
    }

    public String get(String key, Object ... objects) {
        String template = this.get(key);
        if (template == key) {
            return key + ": " + Arrays.toString(objects);
        }
        try {
            MessageFormat mf = new MessageFormat(template);
            return mf.format(objects);
        }
        catch (Exception e) {
            if (LOG_ERRORS) {
                e.printStackTrace(LOG_TARGET);
            }
            return template;
        }
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.getBundle().getString(key);
        }
        catch (Exception e) {
            if (LOG_ERRORS) {
                LOG_TARGET.println("Could not resolve: " + key);
                e.printStackTrace(LOG_TARGET);
            }
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            String s = this.getBundle().getString(key);
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            if (LOG_ERRORS) {
                LOG_TARGET.println("Could not resolve: " + key);
                e.printStackTrace(LOG_TARGET);
            }
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.getBundle().getString(key));
        }
        catch (Exception e) {
            if (LOG_ERRORS) {
                LOG_TARGET.println("Could not resolve: " + key);
                e.printStackTrace(LOG_TARGET);
            }
            return defaultValue;
        }
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    static {
        rbcontrol = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        if (LOG_ERRORS) {
            if (LOG_TARGET_FILE == null) {
                LOG_TARGET = System.err;
            } else {
                try {
                    LOG_TARGET = new PrintStream(LOG_TARGET_FILE);
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> LOG_TARGET.close()));
                }
                catch (FileNotFoundException e) {
                    throw new Error(e);
                }
            }
        } else {
            LOG_TARGET = null;
        }
    }
}

