/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.ListManager;
import com.sun.webui.jsf.component.ListSelector;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.model.OptionGroup;
import com.sun.webui.jsf.model.Separator;
import com.sun.webui.jsf.model.list.ListItem;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.text.Collator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;

public class AddRemove
extends ListSelector
implements ListManager {
    public static final String ADD_BUTTON_ID = "_addButton";
    public static final String ADD_BUTTON_FACET = "addButton";
    public static final String ADDALL_BUTTON_ID = "_addAllButton";
    public static final String ADDALL_BUTTON_FACET = "addAllButton";
    public static final String REMOVE_BUTTON_ID = "_removeButton";
    public static final String REMOVE_BUTTON_FACET = "removeButton";
    public static final String REMOVEALL_BUTTON_ID = "_removeAllButton";
    public static final String REMOVEALL_BUTTON_FACET = "removeAllButton";
    public static final String MOVEUP_BUTTON_ID = "_moveUpButton";
    public static final String MOVEUP_BUTTON_FACET = "moveUpButton";
    public static final String MOVEDOWN_BUTTON_ID = "_moveDownButton";
    public static final String MOVEDOWN_BUTTON_FACET = "moveDownButton";
    public static final String AVAILABLE_LABEL_ID = "_availableLabel";
    public static final String AVAILABLE_LABEL_FACET = "availableLabel";
    public static final String READ_ONLY_LABEL_FACET = "readonlyLabel";
    public static final String SELECTED_LABEL_ID = "_selectedLabel";
    public static final String SELECTED_LABEL_FACET = "selectedLabel";
    public static final String HEADER_FACET = "header";
    public static final String HEADER_ID = "_header";
    public static final String FOOTER_FACET = "footer";
    public static final String AVAILABLE_ID = "_available";
    public static final String AVAILABLE_TEXT_KEY = "AddRemove.available";
    public static final String SELECTED_ID = "_selected";
    public static final String SELECTED_TEXT_KEY = "AddRemove.selected";
    public static final String READONLY_ID = "_readonly";
    public static final String RETURN = "return false;";
    public static final String ADD_FUNCTION = ".add(); ";
    public static final String ADD_TEXT_KEY = "AddRemove.add";
    public static final String ADDVERTICAL_TEXT_KEY = "AddRemove.addVertical";
    public static final String ADDALL_FUNCTION = ".addAll();";
    public static final String ADDALL_TEXT_KEY = "AddRemove.addAll";
    public static final String ADDALLVERTICAL_TEXT_KEY = "AddRemove.addAllVertical";
    public static final String REMOVE_FUNCTION = ".remove(); ";
    public static final String REMOVE_TEXT_KEY = "AddRemove.remove";
    public static final String REMOVEVERTICAL_TEXT_KEY = "AddRemove.removeVertical";
    public static final String REMOVEALL_FUNCTION = ".removeAll(); ";
    public static final String REMOVEALL_TEXT_KEY = "AddRemove.removeAll";
    public static final String REMOVEALLVERTICAL_TEXT_KEY = "AddRemove.removeAllVertical";
    public static final String MOVEUP_FUNCTION = ".moveUp(); ";
    public static final String MOVEUP_TEXT_KEY = "AddRemove.moveUp";
    public static final String MOVEDOWN_FUNCTION = ".moveDown();";
    public static final String MOVEDOWN_TEXT_KEY = "AddRemove.moveDown";
    public static final String UPDATEBUTTONS_FUNCTION = ".updateButtons(); ";
    public static final String AVAILABLE_ONCHANGE_FUNCTION = ".availableOnChange(); ";
    public static final String SELECTED_ONCHANGE_FUNCTION = ".selectedOnChange(); ";
    public static final String MULTIPLEADDITIONS_FUNCTION = ".allowMultipleAdditions()";
    public static final String SPACER_STRING = "_";
    private static final String KEY_STRING = "a";
    private static final String DUP_STRING = "1";
    public static final String SEPARATOR_VALUE = "com.sun.webui.jsf.separator";
    public static final String ADDREMOVE_LABEL_LEVEL = "AddRemove.labelLevel";
    private TreeMap<String, ListItem> availableItems = null;
    private TreeMap<String, ListItem> selectedItems = null;
    private Collator collator = null;
    private String allValues = "";
    private String selectedValues = "";
    private static final boolean DEBUG = false;
    private String availableItemsLabel = null;
    private boolean duplicateSelections = false;
    private boolean duplicateSelectionsSet = false;
    private boolean moveButtons = false;
    private boolean moveButtonsSet = false;
    private boolean selectAll = false;
    private boolean selectAllSet = false;
    private String selectedItemsLabel = null;
    private boolean sorted = false;
    private boolean sortedSet = false;
    private boolean vertical = false;
    private boolean verticalSet = false;

    public AddRemove() {
        this.setMultiple(true);
        this.setRendererType("com.sun.webui.jsf.AddRemove");
    }

    @Override
    public String getFamily() {
        return "com.sun.webui.jsf.AddRemove";
    }

    @Override
    public int getRows() {
        int rows = super.getRows();
        if (rows < 1) {
            rows = 12;
        }
        return rows;
    }

    public String getSeparator() {
        return "|";
    }

    public Iterator getSelectedItems() {
        FacesContext context = FacesContext.getCurrentInstance();
        Iterator itr = this.getListItems(context, true);
        return this.selectedItems.values().iterator();
    }

    public String getAllValues() {
        return this.allValues;
    }

    public String getSelectedValues() {
        FacesContext context = FacesContext.getCurrentInstance();
        Iterator itr = this.getListItems(context, true);
        return this.selectedValues;
    }

    public UIComponent getAddButtonComponent(FacesContext context) {
        return this.getAddButtonComponent();
    }

    public UIComponent getAddButtonComponent() {
        String msgKey = this.isVertical() ? ADDVERTICAL_TEXT_KEY : ADD_TEXT_KEY;
        return this.getButtonFacet(ADD_BUTTON_FACET, false, AddRemove.getTheme().getMessage(msgKey), ADD_FUNCTION);
    }

    public UIComponent getAddAllButtonComponent() {
        String msgKey = this.isVertical() ? ADDALLVERTICAL_TEXT_KEY : ADDALL_TEXT_KEY;
        return this.getButtonFacet(ADDALL_BUTTON_FACET, false, AddRemove.getTheme().getMessage(msgKey), ADDALL_FUNCTION);
    }

    public UIComponent getRemoveButtonComponent() {
        String msgKey = this.isVertical() ? REMOVEVERTICAL_TEXT_KEY : REMOVE_TEXT_KEY;
        return this.getButtonFacet(REMOVE_BUTTON_FACET, false, AddRemove.getTheme().getMessage(msgKey), REMOVE_FUNCTION);
    }

    public UIComponent getRemoveAllButtonComponent() {
        String msgKey = this.isVertical() ? REMOVEALLVERTICAL_TEXT_KEY : REMOVEALL_TEXT_KEY;
        return this.getButtonFacet(REMOVEALL_BUTTON_FACET, false, AddRemove.getTheme().getMessage(msgKey), REMOVEALL_FUNCTION);
    }

    public UIComponent getMoveUpButtonComponent() {
        return this.getButtonFacet(MOVEUP_BUTTON_FACET, false, AddRemove.getTheme().getMessage(MOVEUP_TEXT_KEY), MOVEUP_FUNCTION);
    }

    public UIComponent getMoveDownButtonComponent() {
        return this.getButtonFacet(MOVEDOWN_BUTTON_FACET, false, AddRemove.getTheme().getMessage(MOVEDOWN_TEXT_KEY), MOVEDOWN_FUNCTION);
    }

    private UIComponent getButtonFacet(String facetName, boolean primary, String text, String onclickFunction) {
        UIComponent buttonComponent = this.getFacet(facetName);
        if (buttonComponent != null) {
            return buttonComponent;
        }
        Button button = (Button)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (button == null) {
            button = new Button();
            button.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)button);
        }
        this.initButtonFacet(button, primary, text, onclickFunction);
        return button;
    }

    private void initButtonFacet(Button button, boolean primary, String text, String onclickFunction) {
        button.setPrimary(primary);
        button.setText(text);
        int tindex = this.getTabIndex();
        if (tindex > 0) {
            button.setTabIndex(tindex);
        }
        StringBuilder buff = new StringBuilder();
        buff.append(JavaScriptUtilities.getDomNode(this.getFacesContext(), (UIComponent)this)).append(onclickFunction).append(RETURN);
        button.setOnClick(buff.toString());
        button.setDisabled(this.isDisabled());
    }

    public UIComponent getAvailableLabelComponent() {
        String labelString = this.getAvailableItemsLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = AddRemove.getTheme().getMessage(AVAILABLE_TEXT_KEY);
        }
        String styleClass = AddRemove.getTheme().getStyleClass("ADDREMOVE_LABEL2");
        String forId = this.getLabelFacetForId(AVAILABLE_ID);
        return this.getLabelFacet(AVAILABLE_LABEL_FACET, labelString, styleClass, forId);
    }

    public UIComponent getSelectedLabelComponent() {
        String labelString = this.getSelectedItemsLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = AddRemove.getTheme().getMessage(SELECTED_TEXT_KEY);
        }
        String styleClass = AddRemove.getTheme().getStyleClass("ADDREMOVE_LABEL2");
        String forId = this.getClientId(FacesContext.getCurrentInstance());
        return this.getLabelFacet(SELECTED_LABEL_FACET, labelString, styleClass, forId);
    }

    public UIComponent getReadOnlyLabelComponent() {
        String labelString = this.getSelectedItemsLabel();
        if (labelString == null || labelString.length() == 0) {
            labelString = AddRemove.getTheme().getMessage(SELECTED_TEXT_KEY);
        }
        String styleClass = AddRemove.getTheme().getStyleClass("ADDREMOVE_LABEL2_READONLY");
        return this.getLabelFacet(READ_ONLY_LABEL_FACET, labelString, styleClass, null);
    }

    public UIComponent getHeaderComponent() {
        String labelString = this.getLabel();
        String styleClass = AddRemove.getTheme().getStyleClass("ADDREMOVE_LABEL");
        String forId = this.getClientId(FacesContext.getCurrentInstance()).concat(AVAILABLE_ID);
        return this.getLabelFacet(HEADER_FACET, labelString, styleClass, forId);
    }

    private UIComponent getLabelFacet(String facetName, String labelText, String styleClass, String forId) {
        UIComponent labelComponent = this.getFacet(facetName);
        if (labelComponent != null) {
            return labelComponent;
        }
        if (labelText == null) {
            return null;
        }
        Label label = (Label)ComponentUtilities.getPrivateFacet((UIComponent)this, facetName, true);
        if (label == null) {
            label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, facetName));
            ComponentUtilities.putPrivateFacet((UIComponent)this, facetName, (UIComponent)label);
        }
        this.initLabelFacet(label, facetName, labelText, styleClass, forId);
        return label;
    }

    protected void initLabelFacet(Label label, String facetName, String labelText, String styleClass, String forId) {
        if (label == null) {
            return;
        }
        String text = labelText;
        if (text == null || text.length() < 1) {
            text = new String();
        }
        label.setLabelLevel(Integer.parseInt(AddRemove.getTheme().getMessage(ADDREMOVE_LABEL_LEVEL)));
        label.setText(text);
        label.setStyleClass(styleClass);
        if (forId != null) {
            label.setFor(forId);
        }
    }

    private String getLabelFacetForId(String idSuffix) {
        return this.getClientId(FacesContext.getCurrentInstance()).concat(idSuffix);
    }

    @Override
    public String getPrimaryElementID(FacesContext context) {
        return this.getClientId(context).concat(AVAILABLE_ID);
    }

    @Override
    public String getLabeledElementId(FacesContext context) {
        if (this.isReadOnly()) {
            return null;
        }
        return this.getClientId(context).concat(AVAILABLE_ID);
    }

    @Override
    public String getFocusElementId(FacesContext context) {
        return this.getLabeledElementId(context);
    }

    private static Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    @Override
    public Iterator getListItems(FacesContext context, boolean rulerAtEnd) throws FacesException {
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(3);
        this.availableItems = new TreeMap(this.collator);
        this.selectedItems = new TreeMap(this.collator);
        this.processOptions(context, this.collator, locale, rulerAtEnd);
        this.allValues = this.constructValueString(this.availableItems);
        this.processSelections();
        this.selectedValues = this.constructValueString(this.selectedItems, SEPARATOR_VALUE);
        return this.availableItems.values().iterator();
    }

    protected void processOptions(FacesContext context, Collator zCollator, Locale locale, boolean rulerAtEnd) {
        Option[] options = this.getOptions();
        int length = options.length;
        String lastKey = "";
        String longestString = "";
        StringBuilder unsortedKeyBuffer = new StringBuilder();
        boolean isSorted = this.isSorted();
        for (int counter = 0; counter < length; ++counter) {
            String msg;
            if (options[counter] instanceof OptionGroup) {
                msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "AddRemove.noGrouping");
                AddRemove.log(msg);
                continue;
            }
            if (options[counter] instanceof Separator) {
                msg = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "AddRemove.noGrouping");
                AddRemove.log(msg);
                continue;
            }
            ListItem listItem = this.createListItem(options[counter]);
            String label = listItem.getLabel();
            if (label.length() > longestString.length()) {
                longestString = label;
            }
            if (isSorted) {
                this.availableItems.put(label, listItem);
                if (zCollator.compare(label, lastKey) <= 0) continue;
                lastKey = label;
                continue;
            }
            unsortedKeyBuffer.append(KEY_STRING);
            this.availableItems.put(unsortedKeyBuffer.toString(), listItem);
            lastKey = unsortedKeyBuffer.toString();
        }
        if (rulerAtEnd) {
            int seplength = longestString.length() + 5;
            StringBuilder labelBuffer = new StringBuilder(seplength);
            for (int counter = 0; counter < seplength; ++counter) {
                labelBuffer.append(SPACER_STRING);
            }
            ListItem item = new ListItem(labelBuffer.toString());
            item.setDisabled(true);
            item.setValue(SEPARATOR_VALUE);
            if (isSorted) {
                lastKey = lastKey.concat(KEY_STRING);
                this.availableItems.put(lastKey, item);
                lastKey = lastKey.concat(KEY_STRING);
                this.selectedItems.put(lastKey, item);
            } else {
                unsortedKeyBuffer.append(KEY_STRING);
                this.availableItems.put(unsortedKeyBuffer.toString(), item);
                unsortedKeyBuffer.append(KEY_STRING);
                this.selectedItems.put(unsortedKeyBuffer.toString(), item);
            }
        }
    }

    private String constructValueString(TreeMap map) {
        return this.constructValueString(map, null);
    }

    private String constructValueString(TreeMap map, String filter) {
        StringBuilder valuesBuffer = new StringBuilder();
        Iterator values = map.values().iterator();
        String separator = this.getSeparator();
        valuesBuffer.append(separator);
        while (values.hasNext()) {
            ListItem listItem = (ListItem)values.next();
            if (filter != null && listItem.getValue().equals(filter)) continue;
            valuesBuffer.append(listItem.getValue());
            valuesBuffer.append(separator);
        }
        return valuesBuffer.toString();
    }

    public Iterator getSelectedListItems() {
        return this.selectedItems.values().iterator();
    }

    @Override
    protected void markSelectedListItems(List list, boolean processed) {
        Iterator selected = list.iterator();
        boolean allowDups = this.isDuplicateSelections();
        boolean isSorted = this.isSorted() && !this.isMoveButtons();
        HashSet<String> removeItems = new HashSet<String>();
        String selectedKey = "";
        block2: while (selected.hasNext()) {
            Object selectedValue = selected.next();
            Iterator<String> keys = this.availableItems.keySet().iterator();
            boolean match = false;
            while (keys.hasNext()) {
                String key = keys.next();
                ListItem nextItem = this.availableItems.get(key);
                ListItem listItem = null;
                try {
                    listItem = nextItem;
                }
                catch (Exception e) {
                    AddRemove.log("An available item was not a ListItem.");
                    continue;
                }
                match = processed ? listItem.getValueObject().equals(selectedValue) : selectedValue.toString().equals(listItem.getValue());
                if (!match) continue;
                selectedKey = isSorted ? key : selectedKey.concat(KEY_STRING);
                if (removeItems.contains(key)) {
                    if (!allowDups) continue block2;
                    String key2 = selectedKey.concat(DUP_STRING);
                    while (this.selectedItems.containsKey(key2)) {
                        key2 = key2.concat(DUP_STRING);
                    }
                    this.selectedItems.put(key2, listItem);
                    continue block2;
                }
                removeItems.add(key);
                this.selectedItems.put(selectedKey, listItem);
                continue block2;
            }
        }
        if (!allowDups) {
            for (String key : removeItems) {
                this.availableItems.remove(key);
            }
        }
    }

    @Override
    public boolean mainListSubmits() {
        return false;
    }

    public Object getValue() {
        return super.getValue();
    }

    @Override
    public int getLabelLevel() {
        return super.getLabelLevel();
    }

    @Override
    public boolean isSeparators() {
        return super.isSeparators();
    }

    @Override
    public String getOnBlur() {
        return super.getOnBlur();
    }

    @Override
    public String getOnChange() {
        return super.getOnChange();
    }

    @Override
    public String getOnClick() {
        return super.getOnClick();
    }

    @Override
    public String getOnDblClick() {
        return super.getOnDblClick();
    }

    @Override
    public String getOnFocus() {
        return super.getOnFocus();
    }

    @Override
    public String getOnKeyDown() {
        return super.getOnKeyDown();
    }

    @Override
    public String getOnKeyPress() {
        return super.getOnKeyPress();
    }

    @Override
    public String getOnKeyUp() {
        return super.getOnKeyUp();
    }

    @Override
    public String getOnMouseDown() {
        return super.getOnMouseDown();
    }

    @Override
    public String getOnMouseMove() {
        return super.getOnMouseMove();
    }

    @Override
    public String getOnMouseOut() {
        return super.getOnMouseOut();
    }

    @Override
    public String getOnMouseOver() {
        return super.getOnMouseOver();
    }

    @Override
    public String getOnMouseUp() {
        return super.getOnMouseUp();
    }

    @Override
    public String getOnSelect() {
        return super.getOnSelect();
    }

    public String getAvailableItemsLabel() {
        if (this.availableItemsLabel != null) {
            return this.availableItemsLabel;
        }
        ValueExpression vb = this.getValueExpression("availableItemsLabel");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAvailableItemsLabel(String newAvailableItemsLabel) {
        this.availableItemsLabel = newAvailableItemsLabel;
    }

    public boolean isDuplicateSelections() {
        if (this.duplicateSelectionsSet) {
            return this.duplicateSelections;
        }
        ValueExpression vb = this.getValueExpression("duplicateSelections");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setDuplicateSelections(boolean newDuplicateSelections) {
        this.duplicateSelections = newDuplicateSelections;
        this.duplicateSelectionsSet = true;
    }

    public boolean isMoveButtons() {
        if (this.moveButtonsSet) {
            return this.moveButtons;
        }
        ValueExpression vb = this.getValueExpression("moveButtons");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setMoveButtons(boolean newMoveButtons) {
        this.moveButtons = newMoveButtons;
        this.moveButtonsSet = true;
    }

    public boolean isSelectAll() {
        if (this.selectAllSet) {
            return this.selectAll;
        }
        ValueExpression vb = this.getValueExpression("selectAll");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setSelectAll(boolean newSelectAll) {
        this.selectAll = newSelectAll;
        this.selectAllSet = true;
    }

    public String getSelectedItemsLabel() {
        if (this.selectedItemsLabel != null) {
            return this.selectedItemsLabel;
        }
        ValueExpression vb = this.getValueExpression("selectedItemsLabel");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSelectedItemsLabel(String newSelectedItemsLabel) {
        this.selectedItemsLabel = newSelectedItemsLabel;
    }

    public boolean isSorted() {
        if (this.sortedSet) {
            return this.sorted;
        }
        ValueExpression vb = this.getValueExpression("sorted");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setSorted(boolean newSorted) {
        this.sorted = newSorted;
        this.sortedSet = true;
    }

    public boolean isVertical() {
        if (this.verticalSet) {
            return this.vertical;
        }
        ValueExpression vb = this.getValueExpression("vertical");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setVertical(boolean newVertical) {
        this.vertical = newVertical;
        this.verticalSet = true;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.availableItemsLabel = (String)values[1];
        this.duplicateSelections = (Boolean)values[2];
        this.duplicateSelectionsSet = (Boolean)values[3];
        this.moveButtons = (Boolean)values[4];
        this.moveButtonsSet = (Boolean)values[5];
        this.selectAll = (Boolean)values[6];
        this.selectAllSet = (Boolean)values[7];
        this.selectedItemsLabel = (String)values[8];
        this.sorted = (Boolean)values[9];
        this.sortedSet = (Boolean)values[10];
        this.vertical = (Boolean)values[11];
        this.verticalSet = (Boolean)values[12];
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.availableItemsLabel, this.duplicateSelections ? Boolean.TRUE : Boolean.FALSE, this.duplicateSelectionsSet ? Boolean.TRUE : Boolean.FALSE, this.moveButtons ? Boolean.TRUE : Boolean.FALSE, this.moveButtonsSet ? Boolean.TRUE : Boolean.FALSE, this.selectAll ? Boolean.TRUE : Boolean.FALSE, this.selectAllSet ? Boolean.TRUE : Boolean.FALSE, this.selectedItemsLabel, this.sorted ? Boolean.TRUE : Boolean.FALSE, this.sortedSet ? Boolean.TRUE : Boolean.FALSE, this.vertical ? Boolean.TRUE : Boolean.FALSE, this.verticalSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    private static void log(String msg) {
        LogUtil.finest(AddRemove.class.getName() + "::" + msg);
    }
}

