/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import org.jboss.jdeparser.BasicJBlock;
import org.jboss.jdeparser.BasicJCommentable;
import org.jboss.jdeparser.BlockContent;
import org.jboss.jdeparser.CaseJBlock;
import org.jboss.jdeparser.DefaultJBlock;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JSwitch;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class ImplJSwitch
extends BasicJCommentable
implements JSwitch,
BlockContent {
    private final BasicJBlock parent;
    private final JExpr expr;
    private final ArrayList<CaseJBlock> cases = new ArrayList();
    private DefaultJBlock _default;

    ImplJSwitch(BasicJBlock parent, JExpr expr) {
        this.parent = parent;
        this.expr = expr;
    }

    private <T extends CaseJBlock> T add(T item) {
        this.cases.add(item);
        return item;
    }

    @Override
    public JBlock _case(JExpr expr) {
        return this.add(new CaseJBlock(this, expr));
    }

    @Override
    public JBlock _case(String constName) {
        return this._case(JExprs.name(constName));
    }

    @Override
    public JBlock _default() {
        if (this._default == null) {
            this._default = new DefaultJBlock(this);
        }
        return this._default;
    }

    JExpr getExpression() {
        return this.expr;
    }

    BasicJBlock getParent() {
        return this.parent;
    }

    ArrayList<CaseJBlock> getCases() {
        return this.cases;
    }

    DefaultJBlock getDefault() {
        return this._default;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        writer.write(Tokens$.KW.SWITCH);
        writer.write(FormatPreferences.Space.BEFORE_PAREN_SWITCH);
        writer.write(Tokens$.PUNCT.PAREN.OPEN);
        writer.write(FormatPreferences.Space.WITHIN_PAREN_SWITCH);
        writer.write(this.expr);
        writer.write(Tokens$.PUNCT.PAREN.CLOSE);
        writer.write(FormatPreferences.Space.BEFORE_BRACE_SWITCH);
        writer.write(Tokens$.PUNCT.BRACE.OPEN);
        writer.pushIndent(FormatPreferences.Indentation.LINE);
        try {
            writer.write(FormatPreferences.Space.WITHIN_BRACES_CODE);
            for (CaseJBlock _case : this.cases) {
                _case.write(writer);
            }
            if (this._default != null) {
                this._default.write(writer);
            }
        }
        finally {
            writer.popIndent(FormatPreferences.Indentation.LINE);
        }
        writer.write(FormatPreferences.Space.WITHIN_BRACES_CODE);
        writer.write(Tokens$.PUNCT.BRACE.CLOSE);
    }
}

