/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import com.sun.appserv.ProxyHandler;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Session;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.apache.catalina.connector.CoyoteWriter;
import org.apache.catalina.connector.OutputBuffer;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.ResponseFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.RequestUtil;
import org.glassfish.common.util.InputValidationUtil;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.CookieHeaderGenerator;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.UEncoder;
import org.glassfish.web.util.HtmlEntityEncoder;

public class Response
implements HttpResponse,
HttpServletResponse {
    public static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected static final String info = "org.apache.catalina.connector.Response/1.0";
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static boolean enforceScope;
    private String detailErrorMsg;
    protected SimpleDateFormat format;
    protected Context context;
    protected boolean upgrade;
    protected Connector connector;
    protected Request connectorRequest;
    protected ResponseFacade connectorResponsefacade;
    protected org.glassfish.grizzly.http.server.Response grizzlyResponse;
    protected OutputBuffer outputBuffer;
    protected CoyoteOutputStream outputStream;
    protected CoyoteWriter writer;
    protected boolean appCommitted;
    protected boolean included;
    private boolean isCharacterEncodingSet;
    protected boolean error;
    protected boolean usingOutputStream;
    protected boolean usingWriter;
    protected UEncoder urlEncoder = new UEncoder();
    protected CharChunk redirectURLCharChunk = new CharChunk();

    public Response() {
        this.outputBuffer = new OutputBuffer();
        this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        this.writer = this.createWriter(this.outputBuffer);
        this.urlEncoder.addSafeCharacter('/');
    }

    public Response(boolean chunkingDisabled) {
        this.outputBuffer = new OutputBuffer();
        this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        this.writer = this.createWriter(this.outputBuffer);
        this.urlEncoder.addSafeCharacter('/');
    }

    public static void setEnforceScope(boolean enforce) {
        enforceScope = enforce;
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setCoyoteResponse(org.glassfish.grizzly.http.server.Response coyoteResponse) {
        this.grizzlyResponse = coyoteResponse;
        this.outputBuffer.setCoyoteResponse(this);
    }

    public org.glassfish.grizzly.http.server.Response getCoyoteResponse() {
        return this.grizzlyResponse;
    }

    @Override
    public Context getContext() {
        return this.connectorRequest.getContext();
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void recycle() {
        if (this.connectorRequest != null && this.connectorRequest.isAsyncStarted()) {
            return;
        }
        this.context = null;
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.error = false;
        this.isCharacterEncodingSet = false;
        this.detailErrorMsg = null;
        if (enforceScope) {
            if (this.connectorResponsefacade != null) {
                this.connectorResponsefacade.clear();
                this.connectorResponsefacade = null;
            }
            if (this.outputStream != null) {
                this.outputStream.clear();
                this.outputStream = null;
            }
            if (this.writer != null) {
                this.writer.clear();
                this.writer = null;
            }
        } else {
            this.writer.recycle();
        }
    }

    @Override
    public int getContentCount() {
        return this.outputBuffer.getContentWritten();
    }

    @Override
    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    @Override
    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted() || this.isSuspended() || this.getContentLength() > 0 && this.getContentCount() >= this.getContentLength();
    }

    @Override
    public boolean getIncluded() {
        return this.included;
    }

    @Override
    public void setIncluded(boolean included) {
        this.included = included;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public org.apache.catalina.Request getRequest() {
        return this.connectorRequest;
    }

    @Override
    public void setRequest(org.apache.catalina.Request request) {
        if (request instanceof Request) {
            this.connectorRequest = (Request)request;
        }
    }

    public HttpServletResponse getResponse() {
        if (this.connectorResponsefacade == null) {
            this.connectorResponsefacade = new ResponseFacade(this);
        }
        return this.connectorResponsefacade;
    }

    @Override
    public OutputStream getStream() {
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public void setStream(OutputStream stream) {
    }

    @Override
    public void setSuspended(boolean suspended) {
        this.outputBuffer.setSuspended(suspended);
    }

    @Override
    public boolean isSuspended() {
        return this.outputBuffer.isSuspended();
    }

    @Override
    public void setError() {
        this.error = true;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    @Override
    public void setDetailMessage(String message) {
        this.detailErrorMsg = message;
    }

    @Override
    public String getDetailMessage() {
        return this.detailErrorMsg;
    }

    @Override
    public ServletOutputStream createOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    @Override
    public void finishResponse() throws IOException {
        try {
            this.outputBuffer.close();
        }
        catch (IOException iOException) {
        }
        catch (Throwable t) {
            this.log(rb.getString("AS-WEB-CORE-00075"), t);
        }
    }

    @Override
    public int getContentLength() {
        return this.grizzlyResponse.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.grizzlyResponse.getContentType();
    }

    @Override
    public PrintWriter getReporter() throws IOException {
        if (!this.outputBuffer.isNew()) {
            return null;
        }
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = this.createWriter(this.outputBuffer);
        }
        return this.writer;
    }

    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.grizzlyResponse.getCharacterEncoding();
    }

    public void setCharacterEncoding(String charset) {
        if (this.isCommitted() || this.included || this.usingWriter) {
            return;
        }
        this.grizzlyResponse.setCharacterEncoding(charset);
        this.isCharacterEncodingSet = true;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00076"));
        }
        this.usingOutputStream = true;
        if (this.outputStream == null) {
            this.outputStream = new CoyoteOutputStream(this.outputBuffer);
        }
        return this.outputStream;
    }

    public Locale getLocale() {
        return this.grizzlyResponse.getLocale();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00077"));
        }
        this.setCharacterEncoding(this.getCharacterEncoding());
        this.usingWriter = true;
        this.outputBuffer.checkConverter();
        if (this.writer == null) {
            this.writer = this.createWriter(this.outputBuffer);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.grizzlyResponse.isCommitted();
    }

    public void reset() {
        if (this.included) {
            return;
        }
        this.grizzlyResponse.reset();
        this.outputBuffer.reset();
        this.grizzlyResponse.resetBuffer(true);
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.isCharacterEncodingSet = false;
    }

    @Override
    public void resetBuffer() {
        this.resetBuffer(false);
    }

    @Override
    public void resetBuffer(boolean resetWriterStreamFlags) {
        if (this.isCommitted()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00078"));
        }
        this.outputBuffer.reset();
        if (resetWriterStreamFlags) {
            this.usingOutputStream = false;
            this.usingWriter = false;
            this.isCharacterEncodingSet = false;
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00079"));
        }
        this.outputBuffer.setBufferSize(size);
    }

    public void setContentLength(int length) {
        this.setContentLengthLong(length);
    }

    public void setContentLengthLong(long length) {
        if (this.isCommitted() || this.included || this.usingWriter) {
            return;
        }
        this.grizzlyResponse.setContentLengthLong(length);
    }

    public void setContentType(String type) {
        int index;
        if (this.isCommitted() || this.included) {
            return;
        }
        if (this.usingWriter && type != null && (index = type.indexOf(";")) != -1) {
            type = type.substring(0, index);
        }
        this.grizzlyResponse.setContentType(type);
        if (type != null && (index = type.indexOf(";")) != -1) {
            int len = type.length();
            ++index;
            while (index < len && Character.isWhitespace(type.charAt(index))) {
                ++index;
            }
            if (index + 7 < len && type.charAt(index) == 'c' && type.charAt(index + 1) == 'h' && type.charAt(index + 2) == 'a' && type.charAt(index + 3) == 'r' && type.charAt(index + 4) == 's' && type.charAt(index + 5) == 'e' && type.charAt(index + 6) == 't' && type.charAt(index + 7) == '=') {
                this.isCharacterEncodingSet = true;
            }
        }
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted() || this.included) {
            return;
        }
        this.grizzlyResponse.setLocale(locale);
        if (this.usingWriter) {
            return;
        }
        if (this.isCharacterEncodingSet) {
            return;
        }
        String charset = this.getContext().getCharsetMapper().getCharset(locale);
        if (charset != null) {
            this.grizzlyResponse.setCharacterEncoding(charset);
        }
    }

    @Override
    public String getHeader(String name) {
        return this.grizzlyResponse.getHeader(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        ArrayList<String> headerNames = new ArrayList<String>();
        for (String headerName : this.grizzlyResponse.getResponse().getHeaders().names()) {
            headerNames.add(headerName);
        }
        return headerNames;
    }

    @Override
    public Collection<String> getHeaders(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        for (String headerValue : this.grizzlyResponse.getResponse().getHeaders().values(name)) {
            headers.add(headerValue);
        }
        return headers;
    }

    @Override
    public String getMessage() {
        return this.grizzlyResponse.getMessage();
    }

    @Override
    public int getStatus() {
        return this.grizzlyResponse.getStatus();
    }

    @Override
    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    public void addCookie(Cookie cookie) {
        if (this.isCommitted() || this.included) {
            return;
        }
        String cookieValue = this.getCookieString(cookie);
        this.addHeader("Set-Cookie", cookieValue);
    }

    @Override
    public void addSessionCookieInternal(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        String name = cookie.getName();
        String headername = "Set-Cookie";
        String startsWith = name + "=";
        String cookieString = this.getCookieString(cookie);
        boolean set = false;
        MimeHeaders headers = this.grizzlyResponse.getResponse().getHeaders();
        int headersSize = headers.size();
        for (int i = 0; i < headersSize; ++i) {
            if (!headers.getName(i).toString().equals("Set-Cookie") || !headers.getValue(i).toString().startsWith(startsWith)) continue;
            headers.getValue(i).setString(cookieString);
            set = true;
        }
        if (!set) {
            this.addHeader("Set-Cookie", cookieString);
        }
    }

    public void addDateHeader(String name, long value) {
        if (name == null || name.length() == 0 || this.isCommitted() || this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.addHeader(name, FastHttpDateFormat.formatDate((long)value, (DateFormat)this.format));
    }

    public void addHeader(String name, String value) {
        if (name == null || name.length() == 0 || value == null || this.isCommitted() || this.included) {
            return;
        }
        this.grizzlyResponse.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (name == null || name.length() == 0 || this.isCommitted() || this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        return this.grizzlyResponse.containsHeader(name);
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        return this.grizzlyResponse.getTrailers();
    }

    public void setTrailerFields(Supplier<Map<String, String>> supplier) {
        this.grizzlyResponse.setTrailers(supplier);
    }

    public String encodeRedirectURL(String url) {
        if (!this.isEncodeable(this.toAbsolute(url))) {
            return url;
        }
        String sessionVersion = null;
        Map<String, String> sessionVersions = this.connectorRequest.getSessionVersionsRequestAttribute();
        if (sessionVersions != null) {
            sessionVersion = RequestUtil.createSessionVersionString(sessionVersions);
        }
        return this.toEncoded(url, this.connectorRequest.getSessionInternal().getIdInternal(), sessionVersion);
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute((String)url);
        if (!this.isEncodeable(absolute)) {
            return url;
        }
        if (((String)url).equalsIgnoreCase("")) {
            url = absolute;
        } else if (((String)url).equals(absolute) && !this.hasPath((String)url)) {
            url = (String)url + "/";
        }
        String sessionVersion = null;
        Map<String, String> sessionVersions = this.connectorRequest.getSessionVersionsRequestAttribute();
        if (sessionVersions != null) {
            sessionVersion = RequestUtil.createSessionVersionString(sessionVersions);
        }
        return this.toEncoded((String)url, this.connectorRequest.getSessionInternal().getIdInternal(), sessionVersion);
    }

    @Override
    public String encode(String url) {
        return this.urlEncoder.encodeURL(url);
    }

    @Override
    public void sendAcknowledgement() throws IOException {
        if (this.isCommitted() || this.included) {
            return;
        }
        this.grizzlyResponse.sendAcknowledgement();
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00080"));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.grizzlyResponse.setStatus(status);
        this.grizzlyResponse.getResponse().setHtmlEncodingCustomReasonPhrase(false);
        this.grizzlyResponse.setDetailMessage(HtmlEntityEncoder.encodeXSS((String)message));
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(location, true);
    }

    public void sendRedirect(String location, boolean isTemporary) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00081"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.getContext().getAllowRelativeRedirect() ? location : this.toAbsolute(location);
            if (isTemporary) {
                this.setStatus(302);
            } else {
                this.setStatus(301);
            }
            this.setHeader("Location", absolute);
            this.setContentType("text/html");
            this.setLocale(Locale.getDefault());
            String href = HtmlEntityEncoder.encodeXSS((String)absolute);
            StringBuilder sb = new StringBuilder(150 + href.length());
            sb.append("<html>\r\n");
            sb.append("<head><title>Document moved</title></head>\r\n");
            sb.append("<body><h1>Document moved</h1>\r\n");
            sb.append("This document has moved <a href=\"");
            sb.append(href);
            sb.append("\">here</a>.<p>\r\n");
            sb.append("</body>\r\n");
            sb.append("</html>\r\n");
            try {
                this.getWriter().write(sb.toString());
            }
            catch (IllegalStateException ise1) {
                try {
                    this.getOutputStream().print(sb.toString());
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    public void setDateHeader(String name, long value) {
        if (name == null || name.length() == 0 || this.isCommitted() || this.included) {
            return;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat(HTTP_RESPONSE_DATE_HEADER, Locale.US);
            this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.setHeader(name, FastHttpDateFormat.formatDate((long)value, (DateFormat)this.format));
    }

    public void setHeader(String name, String value) {
        if (name == null || name.length() == 0 || value == null || this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        try {
            this.grizzlyResponse.setHeader(InputValidationUtil.getSafeHeaderName((String)name), InputValidationUtil.getSafeHeaderValue((String)value));
        }
        catch (Exception e) {
            try {
                this.grizzlyResponse.sendError(403, "Forbidden");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setIntHeader(String name, int value) {
        if (name == null || name.length() == 0 || this.isCommitted() || this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    @Override
    public void setError(int status, String message) {
        this.setStatus(status, message);
    }

    private void setStatus(int status, String message) {
        if (this.isCommitted() || this.included) {
            return;
        }
        this.grizzlyResponse.setStatus(status);
        this.grizzlyResponse.getResponse().setHtmlEncodingCustomReasonPhrase(false);
        this.grizzlyResponse.setDetailMessage(HtmlEntityEncoder.encodeXSS((String)message));
    }

    protected boolean isEncodeable(final String location) {
        if (location == null || location.startsWith("#")) {
            return false;
        }
        final Session session = this.connectorRequest.getSessionInternal(false);
        if (session == null) {
            return false;
        }
        if (this.connectorRequest.isRequestedSessionIdFromCookie() || this.getContext() != null && !this.getContext().isEnableURLRewriting()) {
            return false;
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Response.this.doIsEncodeable(Response.this.connectorRequest, session, location);
                }
            });
        }
        return this.doIsEncodeable(this.connectorRequest, session, location);
    }

    private boolean doIsEncodeable(Request hreq, Session session, String location) {
        String contextPath;
        int urlPort;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol()) || !hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        Context ctx = this.getContext();
        if (ctx != null && (contextPath = ctx.getPath()) != null) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            String sessionParamName = ctx.getSessionParameterName();
            if (file.contains(";" + sessionParamName + "=" + session.getIdInternal())) {
                return false;
            }
        }
        return true;
    }

    protected String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (location.startsWith("//")) {
            this.redirectURLCharChunk.recycle();
            String scheme = this.getRedirectScheme();
            try {
                this.redirectURLCharChunk.append(scheme, 0, scheme.length());
                this.redirectURLCharChunk.append(':');
                this.redirectURLCharChunk.append(location, 0, location.length());
                return this.redirectURLCharChunk.toString();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(location, e);
            }
        }
        if (leadingSlash || location.indexOf("://") == -1) {
            this.redirectURLCharChunk.recycle();
            String scheme = this.getRedirectScheme();
            String name = this.connectorRequest.getServerName();
            int port = this.connectorRequest.getServerPort();
            try {
                this.redirectURLCharChunk.append(scheme, 0, scheme.length());
                this.redirectURLCharChunk.append("://", 0, 3);
                this.redirectURLCharChunk.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    this.redirectURLCharChunk.append(':');
                    String portS = "" + port;
                    this.redirectURLCharChunk.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.connectorRequest.getDecodedRequestURI();
                    relativePath = relativePath.substring(0, relativePath.lastIndexOf(47));
                    String encodedURI = null;
                    final String frelativePath = relativePath;
                    if (SecurityUtil.isPackageProtectionEnabled()) {
                        try {
                            encodedURI = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                                @Override
                                public String run() throws IOException {
                                    return Response.this.urlEncoder.encodeURL(frelativePath);
                                }
                            });
                        }
                        catch (PrivilegedActionException pae) {
                            IllegalArgumentException iae = new IllegalArgumentException(location);
                            iae.initCause(pae.getCause());
                            throw iae;
                        }
                    } else {
                        encodedURI = this.urlEncoder.encodeURL(relativePath);
                    }
                    this.redirectURLCharChunk.append(encodedURI, 0, encodedURI.length());
                    this.redirectURLCharChunk.append('/');
                }
                this.redirectURLCharChunk.append(location, 0, location.length());
                this.normalize(this.redirectURLCharChunk);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(location, e);
            }
            return this.redirectURLCharChunk.toString();
        }
        return location;
    }

    private String getRedirectScheme() {
        String scheme = this.connectorRequest.getScheme();
        if (this.getConnector() != null) {
            ProxyHandler proxyHandler;
            if (this.getConnector().getProxyScheme() != null) {
                scheme = this.getConnector().getProxyScheme();
            }
            if (this.getConnector().getAuthPassthroughEnabled() && (proxyHandler = this.getConnector().getProxyHandler()) != null && proxyHandler.getSSLKeysize((HttpServletRequest)this.connectorRequest) > 0) {
                scheme = "https";
            }
        }
        return scheme;
    }

    protected String toEncoded(String url, String sessionId) {
        return this.toEncoded(url, sessionId, null);
    }

    private String toEncoded(String url, String sessionId, String sessionVersion) {
        StringBuilder urlBuilder;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((urlBuilder = new StringBuilder(path)).length() > 0) {
            String replicaLocation;
            Session session;
            String jrouteId;
            StandardContext ctx = (StandardContext)this.getContext();
            String sessionParamName = ctx != null ? ctx.getSessionParameterName() : "jsessionid";
            urlBuilder.append(";" + sessionParamName + "=");
            urlBuilder.append(sessionId);
            if (ctx != null && ctx.getJvmRoute() != null) {
                urlBuilder.append('.').append(ctx.getJvmRoute());
            }
            if ((jrouteId = this.connectorRequest.getHeader("proxy-jroute")) != null) {
                urlBuilder.append(":");
                urlBuilder.append(jrouteId);
            }
            if ((session = this.connectorRequest.getSessionInternal(false)) != null && (replicaLocation = (String)session.getNote("com.sun.enterprise.http.jreplicaLocation")) != null) {
                urlBuilder.append(";jreplica=");
                urlBuilder.append(replicaLocation);
            }
            if (sessionVersion != null) {
                urlBuilder.append(";jsessionidversion=");
                urlBuilder.append(sessionVersion);
            }
        }
        urlBuilder.append(anchor);
        urlBuilder.append(query);
        return urlBuilder.toString();
    }

    protected CoyoteWriter createWriter(OutputBuffer outbuf) {
        return new CoyoteWriter(outbuf);
    }

    protected String getCookieString(final Cookie cookie) {
        String cookieValue = null;
        cookieValue = SecurityUtil.isPackageProtectionEnabled() ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return CookieHeaderGenerator.generateHeader((String)cookie.getName(), (String)cookie.getValue(), (int)cookie.getMaxAge(), (String)cookie.getDomain(), (String)cookie.getPath(), (boolean)cookie.getSecure(), (boolean)cookie.isHttpOnly(), (Map)cookie.getAttributes());
            }
        }) : CookieHeaderGenerator.generateHeader((String)cookie.getName(), (String)cookie.getValue(), (int)cookie.getMaxAge(), (String)cookie.getDomain(), (String)cookie.getPath(), (boolean)cookie.getSecure(), (boolean)cookie.isHttpOnly(), (Map)cookie.getAttributes());
        return cookieValue;
    }

    public void removeSessionCookies() {
        Object matchExpression = "^" + this.getContext().getSessionCookieName() + "=.*";
        this.grizzlyResponse.getResponse().getHeaders().removeHeaderMatches("Set-Cookie", (String)matchExpression);
        matchExpression = "^JSESSIONIDSSO=.*";
        this.grizzlyResponse.getResponse().getHeaders().removeHeaderMatches("Set-Cookie", (String)matchExpression);
    }

    public void setUpgrade(boolean upgrade) {
        this.upgrade = upgrade;
    }

    void disableWriteHandler() {
        this.outputBuffer.disableWriteHandler();
    }

    private void normalize(CharChunk cc) {
        int truncate = cc.indexOf('?');
        if (truncate == -1) {
            truncate = cc.indexOf('#');
        }
        char[] truncateCC = null;
        if (truncate > -1) {
            truncateCC = Arrays.copyOfRange(cc.getBuffer(), cc.getStart() + truncate, cc.getEnd());
            cc.setEnd(cc.getStart() + truncate);
        }
        if (cc.endsWith("/.") || cc.endsWith("/..")) {
            try {
                cc.append('/');
            }
            catch (IOException e) {
                throw new IllegalArgumentException(cc.toString(), e);
            }
        }
        char[] c = cc.getChars();
        int start = cc.getStart();
        int end = cc.getEnd();
        int index = 0;
        int startIndex = 0;
        for (int i = 0; i < 3; ++i) {
            startIndex = cc.indexOf('/', startIndex + 1);
        }
        index = startIndex;
        while ((index = cc.indexOf("/./", 0, 3, index)) >= 0) {
            this.copyChars(c, start + index, start + index + 2, end - start - index - 2);
            cc.setEnd(end -= 2);
        }
        index = startIndex;
        while ((index = cc.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == startIndex) {
                throw new IllegalArgumentException();
            }
            int index2 = -1;
            for (int pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (c[pos] != '/') continue;
                index2 = pos;
            }
            this.copyChars(c, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            cc.setEnd(end);
            index = index2;
        }
        if (truncateCC != null) {
            try {
                cc.append(truncateCC, 0, truncateCC.length);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException(ioe);
            }
        }
    }

    private void copyChars(char[] c, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            c[pos + dest] = c[pos + src];
        }
    }

    private boolean hasPath(String uri) {
        int pos = uri.indexOf("://");
        if (pos < 0) {
            return false;
        }
        return (pos = uri.indexOf(47, pos + 3)) >= 0;
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        if (this.connector != null && this.connector.getContainer() != null) {
            logger = this.connector.getContainer().getLogger();
        }
        String localName = "Response";
        if (logger != null) {
            logger.log(localName + " " + message, t, 2);
        } else {
            log.log(Level.WARNING, localName + " " + message, t);
        }
    }
}

